/*
 * Decompiled with CFR 0.152.
 */
package bits;

import bits.BitFixer;
import bits.Conjunction;
import bits.Disjunction;
import bits.IBooleanVariable;
import bits.IProblem;
import bits.Problem;
import bits.exceptions.ConditionalDisjunctionException;

public class ConditionalDisjunction
extends Problem
implements IProblem {
    public ConditionalDisjunction(IProblem[] problemArray, IBooleanVariable[] booleanVariableArray) throws Exception {
        if (problemArray == null) {
            throw new ConditionalDisjunctionException("Null IProblem array passed to constructor.");
        }
        if (booleanVariableArray == null) {
            throw new ConditionalDisjunctionException("Null IBooleanVariable array passed to constructor.");
        }
        int numberOfProblems = problemArray.length;
        if (numberOfProblems == 0) {
            throw new ConditionalDisjunctionException("IProblem array of zero length passed to constructor.");
        }
        if (numberOfProblems == 1) {
            this.setClauses(problemArray[0].getClauses());
        }
        if (numberOfProblems != booleanVariableArray.length) {
            throw new ConditionalDisjunctionException("IProblem array and IBooleanVariable array of unequal length passed to constructor.");
        }
        IProblem[] subProblems = new IProblem[numberOfProblems];
        int i = 0;
        while (i < numberOfProblems) {
            subProblems[i] = new Conjunction(new BitFixer(booleanVariableArray[i], true), problemArray[i]);
            ++i;
        }
        this.setClauses(new Disjunction(subProblems).getClauses());
    }
}

