/*
 * Decompiled with CFR 0.152.
 */
package bits;

import bits.Conjunction;
import bits.Disjunction;
import bits.IBooleanVariable;
import bits.IProblem;
import bits.Problem;
import bits.exceptions.ConditionalConjunctionException;

public class ConditionalConjunction
extends Problem
implements IProblem {
    public ConditionalConjunction(IProblem[] problemArray, IBooleanVariable[] booleanVariableArray) throws Exception {
        if (problemArray == null) {
            throw new ConditionalConjunctionException("Null IProblem array passed to constructor.");
        }
        if (booleanVariableArray == null) {
            throw new ConditionalConjunctionException("Null IBooleanVariable array passed to constructor.");
        }
        int numberOfProblems = problemArray.length;
        if (numberOfProblems == 0) {
            throw new ConditionalConjunctionException("IProblem array of zero length passed to constructor.");
        }
        if (numberOfProblems == 1) {
            this.setClauses(problemArray[0].getClauses());
        }
        if (numberOfProblems != booleanVariableArray.length) {
            throw new ConditionalConjunctionException("IProblem array and IBooleanVariable array of unequal length passed to constructor.");
        }
        IProblem[] subProblems = new IProblem[numberOfProblems];
        int i = 0;
        while (i < numberOfProblems) {
            subProblems[i] = new Disjunction(problemArray[i], Problem.trivialProblem(), booleanVariableArray[i]);
            ++i;
        }
        this.setClauses(new Conjunction(subProblems).getClauses());
    }
}

