/*
 * Decompiled with CFR 0.152.
 */
package bits;

import bits.IBooleanVariable;
import bits.exceptions.BooleanVariableException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class BooleanVariable
implements IBooleanVariable {
    private static long boolCount;
    private static HashSet<IBooleanVariable> instances;
    private static boolean verbose;
    private String name;
    private boolean value;

    static {
        instances = new HashSet();
    }

    public static long getBoolCount() {
        return boolCount;
    }

    public static IBooleanVariable getBooleanVariable() throws Exception {
        return new BooleanVariable();
    }

    public static IBooleanVariable getBooleanVariable(boolean x) throws Exception {
        IBooleanVariable res = BooleanVariable.getBooleanVariable();
        res.setValue(x);
        return res;
    }

    public static IBooleanVariable getBooleanVariable(String n) throws Exception {
        if (n == null || "".compareTo(n) == 0) {
            throw new BooleanVariableException("Empty string or null was passed to getBooleanVariable method.");
        }
        Object[] inarray = BooleanVariable.getInstances().toArray();
        int i = 0;
        while (i < inarray.length) {
            IBooleanVariable nx = (IBooleanVariable)inarray[i];
            if (n.compareTo(nx.getName()) == 0) {
                return nx;
            }
            ++i;
        }
        return new BooleanVariable(n);
    }

    public static IBooleanVariable getBooleanVariable(String n, boolean x) throws Exception {
        if (n == null || "".compareTo(n) == 0) {
            throw new BooleanVariableException("Null or empty String passed to getBooleanVariable method.");
        }
        IBooleanVariable res = BooleanVariable.getBooleanVariable(n);
        res.setValue(x);
        return res;
    }

    public static HashSet<IBooleanVariable> getInstances() {
        return instances;
    }

    public static void listVariables() {
        HashSet<IBooleanVariable> s = BooleanVariable.getInstances();
        IBooleanVariable[] ary = s.toArray(new BooleanVariable[0]);
        List<IBooleanVariable> lis = Arrays.asList(ary);
        Collections.sort(lis);
        System.out.println(lis);
    }

    public static void setVerbose(boolean verbose) {
        BooleanVariable.verbose = verbose;
    }

    protected BooleanVariable() throws Exception {
        this("BooleanVariable-" + boolCount, false);
        ++boolCount;
    }

    private BooleanVariable(String n) throws Exception {
        this(n, false);
    }

    private BooleanVariable(String n, boolean x) throws Exception {
        if (n == null || "".compareTo(n) == 0) {
            throw new BooleanVariableException("Null or empty string was passed to a constructor.");
        }
        this.setName(n);
        this.setValue(x);
        BooleanVariable.getInstances().add(this);
        if (this.isVerbose()) {
            System.out.println(this.getName());
        }
    }

    @Override
    public int compareTo(Object o) {
        String thisName = this.getName();
        String oName = ((IBooleanVariable)o).getName();
        return thisName.compareTo(oName);
    }

    @Override
    public boolean equals(Object anObject) {
        if (anObject == null) {
            return false;
        }
        if (anObject instanceof IBooleanVariable) {
            BooleanVariable bv = (BooleanVariable)anObject;
            return this.getName().compareTo(bv.getName()) == 0;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean getValue() {
        return this.value;
    }

    public boolean isVerbose() {
        return verbose;
    }

    public void setName(String name) throws BooleanVariableException {
        if (name == null || "".compareTo(name) == 0) {
            throw new BooleanVariableException("Null or empty String passed to setName method.");
        }
        this.name = name;
    }

    @Override
    public void setValue(boolean x) {
        this.value = x;
    }

    public String toString() {
        return "<" + this.getName() + "=" + this.getValue() + ">";
    }
}

