#ifndef __MYUTIL_H__
#define __MYUTIL_H__

#include <Arduino.h>
#include <inttypes.h>

/**
 * @brief Little Endian 4byte -> Little Endian unsigned long(4byte)
 */
#define	b4l_to_uint32(s)	(*((uint32_t*)(s)))
/**
 * @brief Little Endian 2byte -> Little Endian signed int(2byte)
 */
#define	b2l_to_int16(s)	(*((int16_t*)(s)))

/**
 * 数値のフォーマット出力
 */
char *Fmt02d(int i, char *s);
char *Fmt03d(int i, char *s);
char *Fmt04d(int i, char *s);
char *FmtP03d(int i, char *s);
char *FmtP04d(int i, char *s);
char *Fmt02X(byte iX, char *sz);

char* xv_int2str(int v, char *p);
char* xv_long2str(long v, char *p);
char* xv_str2str(char *v, char *p);

char* fmtDouble(double val, uint8_t precision, char *buf, uint16_t bufLen = 0xffff);
//unsigned fmtUnsigned(unsigned long val, char *buf, unsigned bufLen = 0xffff, byte width = 0);
unsigned fmtUnsigned(uint32_t val, char *buf, uint16_t bufLen = 0xffff, uint8_t width = 0);


#endif
