
#include <Arduino.h>
#include <stdlib.h>
#include <string.h>
#include "myutil.h"

/**
 * 数値のフォーマット出力
 * 固定桁数　先頭ゼロ付き　符号正のみ
 */
// "%02d"
char *Fmt02d(int i, char *s)
{
	if (i > 99)
		i = 99;
	*s++ = (i / 10) | 0x30;
	*s++ = (i % 10) | 0x30;
	*s = 0;
	return s;
}
 // "%03d"
char *Fmt03d(int i, char *s)
{
	if (i > 999)
		i = 999;
	*s++ = (i /   100) | 0x30; i %=   100;
	*s++ = (i /    10) | 0x30; i %=    10;
	*s++ = i | 0x30;
	*s = 0;
	return s;
}

// "%04d"
char *Fmt04d(int i, char *s)
{
	if (i > 9999)
		i = 9999;
	*s++ = (i /  1000) | 0x30; i %=  1000;
	*s++ = (i /   100) | 0x30; i %=   100;
	*s++ = (i /    10) | 0x30; i %=    10;
	*s++ = i | 0x30;
	*s = 0;
	return s;
}
/**
 * 	@brief intを5桁固定長、符号有り、先頭ゼロの文字列に変換
 *	@details 先頭桁　マイナス時−　プラス時+
 *	　　　　　sprintf("%+04d")
 *
 */
char *FmtP04d(int i, char *s)
{
	if (i < 0) {
		s[0] = '-';
	} else {
		s[0] = '+';
	}
	i = abs(i);
	if (i > 9999)
		i = 9999;
	s[1] = (i /  1000) | 0x30; i %=  1000;
	s[2] = (i /   100) | 0x30; i %=   100;
	s[3] = (i /    10) | 0x30; i %=    10;
	s[4] = i | 0x30;
	s[5] = 0;
	return s+5;
}
/**
 * 	@brief intを4桁固定長、符号有り、先頭ゼロの文字列に変換
 *	@details 先頭桁　マイナス時−　プラス時+
 *	　　　　　sprintf("%+03d")
 *
 */
char *FmtP03d(int i, char *s)
{
	if (i < 0) {
		s[0] = '-';
	} else {
		s[0] = '+';
	}
	i = abs(i);
	if (i > 999)
		i = 999;
	s[1] = (i /   100) | 0x30; i %=   100;
	s[2] = (i /    10) | 0x30; i %=    10;
	s[3] = i | 0x30;
	s[4] = 0;
	return s+4;
}
/*
	1バイト整数を16進文字列に変換する
	byte iX:
		変換元
	char *sz:
		変換先　2文字　大文字　最後に0が付けられる
*/
char *Fmt02X(byte iX, char *sz)
{
	unsigned char c, c1;

	for(c = 0; c <= 1; c++) {
		c1 = (iX & 0x0F);
		if (c1 <= 9) {
			sz[1 - c] = c1 + 0x30;
		} else if (10 <= c1 && c1 <= 15) {
			sz[1 - c] = c1 - 10 + 0x41;
		} else {
			sz[1 - c] = '*';
		}
		iX >>= 4;
	}
	sz[2] = 0;
	return sz+2;
}

/**
 * @brief 整数値(int)を文字列に変換
 * @details 文字列変数にコピーし、末尾のポインター(注意!NULLの位置)を返す
 * @param v [in] 変換する整数値
 * @param p [in] 変換結果の文字列のコピー先ポインタ　末尾にはNULLを付けて返す
 * @return 文字列の末尾のポインター(注意!NULLの位置を返す)
 */
char* xv_int2str(int v, char *p)
{
	int	len;
	char	buf[10];

	itoa(v , buf, 10);
	len = strlen(buf);
	memcpy(p, buf, len);
	p[len] = 0;
	p += len;
	return p;
}
/**
 * @brief 整数値(long)を文字列に変換
 * @details 文字列変数にコピーし、末尾のポインター(注意!NULLの位置)を返す
 * @param v [in] 変換する整数値
 * @param p [in] 変換結果の文字列のコピー先ポインタ　末尾にはNULLを付けて返す
 * @return 文字列の末尾のポインター(注意!NULLの位置を返す)
 */
char* xv_long2str(long v, char *p)
{
	int	len;
	char	buf[12];

	ltoa(v , buf, 10);
	len = strlen(buf);
	memcpy(p, buf, len);
	p[len] = 0;
	p += len;
	return p;
}
/**
 * @brief 文字列を文字列変数にコピーする
 * @details 文字列を文字列変数にコピーし、末尾のポインター(注意!NULLの位置)を返す
 * 　　　　　strcat()との違い、コピー先の文字列末尾は探さない
 *           コピー先文字列末尾のポインタを返す
 * @param src [in] コピー元文字列　末尾にはNULLが必要
 * @param dst [in] 文字列のコピー先ポインタ　末尾にはNULLを付けて返す
 * @return 文字列の末尾のポインター(注意!NULLの位置を返す)
 */
char* xv_str2str(char *src, char *dst)
{
	int	len;

	len = strlen(src);
	memcpy(dst, src, len);
	dst[len] = 0;
	dst += len;
	return dst;
}


//
// Produce a formatted string in a buffer corresponding to the value provided.
// If the 'width' parameter is non-zero, the value will be padded with leading
// zeroes to achieve the specified width.  The number of characters added to
// the buffer (not including the null termination) is returned.
//
unsigned fmtUnsigned(uint32_t val, char *buf, uint16_t bufLen, uint8_t width)
{
	if (!buf || !bufLen)
		return(0);

	// produce the digit string (backwards in the digit buffer)
	char dbuf[10];
	uint16_t idx = 0;
	while (idx < sizeof(dbuf))	{
		dbuf[idx++] = (val % 10) + '0';
		if ((val /= 10) == 0)
			break;
	}

	// copy the optional leading zeroes and digits to the target buffer
	uint16_t len = 0;
	uint8_t padding = (width > idx) ? width - idx : 0;
	char c = '0';
	while ((--bufLen > 0) && (idx || padding))	{
		if (padding)
			padding--;
		else
			c = dbuf[--idx];
		*buf++ = c;
		len++;
	}

	// add the null termination
	*buf = '\0';
	return(len);
}

//
// Format a floating point value with number of decimal places.
// The 'precision' parameter is a number from 0 to 6 indicating the desired decimal places.
// The 'buf' parameter points to a buffer to receive the formatted string.	This must be
// sufficiently large to contain the resulting string.	The buffer's length may be
// optionally specified.	If it is given, the maximum length of the generated string
// will be one less than the specified value.
//
// example: fmtDouble(3.1415, 2, buf); // produces 3.14 (two decimal places)
//
char* fmtDouble(double val, uint8_t precision, char *buf, uint16_t bufLen)
{
	if (!buf || !bufLen)
		return NULL;

	// limit the precision to the maximum allowed value
	const uint8_t maxPrecision = 6;
	if (precision > maxPrecision)
		precision = maxPrecision;

	if (--bufLen > 0) {
		// check for a negative value
		if (val < 0.0) {
			val = -val;
			*buf++ = '-';
			bufLen--;
		}

		// compute the rounding factor and fractional multiplier
		double roundingFactor = 0.5;
		uint32_t mult = 1;
		for (uint8_t i = 0; i < precision; i++) {
			roundingFactor /= 10.0;
			mult *= 10;
		}

		if (bufLen > 0) {
			// apply the rounding factor
			val += roundingFactor;

			// add the integral portion to the buffer
			uint16_t len = fmtUnsigned((uint32_t)val, buf, bufLen);
			buf += len;
			bufLen -= len;
		}

		// handle the fractional portion
		if ((precision > 0) && (bufLen > 0)) {
			*buf++ = '.';
			if (--bufLen > 0)
				buf += fmtUnsigned((uint32_t)((val - (uint32_t)val) * mult), buf, bufLen, precision);
		}
	}

	// null-terminate the string
	*buf = '\0';
	return buf;
}

