#pragma once

#include "ofMain.h"
#include "ofxStk.h"
#include "ofxSimpleButton.h"
#include "ofxSimpleDial.h"

class testApp : public ofBaseApp, ofxSimpleButtonListener, ofxSimpleDialListener {

public:
	void setup();
	void update();
	void draw();

	void keyPressed(int key);
	void keyReleased(int key);
	void mouseMoved(int x, int y );
	void mouseDragged(int x, int y, int button);
	void mousePressed(int x, int y, int button);
	void mouseReleased(int x, int y, int button);
	void windowResized(int w, int h);
	void dragEvent(ofDragInfo dragInfo);
	void gotMessage(ofMessage msg);

	void audioOut(float * output, int size, int channels);

	void buttonNotify(ofxSimpleButtonEvent event);
	void dialNotify(ofxSimpleDialEvent &event);
	
private:
	int sigAreaX, sigAreaY, sigAreaW, sigAreaH;
	int buttonX, buttonY, buttonSize;
	int dialX, dialY, dialSize, dialLocationMargin;

	int mNumStkInstrmnt;
	int mCurrentInstrmnt;
	
    vector<float> lrAudio;
	vector<ofxSimpleButton> buttons;
	vector<ofxSimpleDial> dials;
	vector<stk::Instrmnt*> insts;
};



