#include "testApp.h"

#define AUDIO_BUFFER_SIZE 1024
#define NUM_DIALS 8

void test_ofxStk()
{
	const vector<string> &names = ofxStkGetInstrmntNames();
	for(vector<string>::const_iterator itr = names.begin(); itr != names.end(); itr++) {
		string name = ((string)*itr);
		int num_cc = ofxStkGetNumControlChange(name);
		printf("%s, %d\n", name.c_str(), num_cc);
		const vector<ControlChangeInfo> &infos = ofxStkControlChangeInfos(name);
		for(vector<ControlChangeInfo>::const_iterator itr = infos.begin(); itr != infos.end(); itr++) {
			ControlChangeInfo info = ((ControlChangeInfo)*itr);
			printf("%d, %s\n", info.number, info.name.c_str());
		}
	}
}

//--------------------------------------------------------------
void testApp::setup()
{
	//test_ofxStk();
	
	// init parameter
	const vector<string> &names = ofxStkGetInstrmntNames();
	mNumStkInstrmnt = names.size();
	mCurrentInstrmnt = 0;
	
	// STK instrmnt
	insts.resize(mNumStkInstrmnt);
	for(int i = 0; i < mNumStkInstrmnt; i++) {
		insts[i] = ofxStkNewInstrmnt(names[i]);
	}
	
	sigAreaX = (int)(0.3 * ofGetWidth());
	sigAreaY = (int)(0.05 * ofGetHeight());
	sigAreaW = (int)(0.65 * ofGetWidth());
	sigAreaH = (int)(0.70 * ofGetHeight());

	buttonX = (int)(0.05 * ofGetWidth());
	buttonY = (int)(0.05 * ofGetHeight());
	buttonSize = (int)(0.018 * ofGetHeight());

	dialX = (int)(0.3 * ofGetWidth());
	dialY = (int)(0.75 * ofGetHeight());
	dialSize = (int)(0.03 * ofGetHeight());
	dialLocationMargin = (int)(0.03 * ofGetHeight());

	// setup of background
    ofBackground(50, 50, 50);

	// setup buttons
	buttons.resize(mNumStkInstrmnt);
	for(int i = 0; i < mNumStkInstrmnt; i++) {
		buttons[i].setup(buttonX, buttonY + (buttonSize << 1) * i,
						 buttonSize, buttonSize, true);
		buttons[i].addListener(this);
	}

	// setup dials
	dials.resize(NUM_DIALS);
	for(int i = 0; i < NUM_DIALS; i++) {
		int xx = dialX + dialLocationMargin + ((dialSize*4.0 + dialLocationMargin) * (i % 4));
		int yy = dialY + dialLocationMargin + ((dialSize*2.3 + dialLocationMargin) * (i / 4));
		dials[i].setup(xx, yy, dialSize, true);
		dials[i].addListener(this);
	}
	
    // audio setup
    ofSoundStreamSetup(2, 0, this, 44100, AUDIO_BUFFER_SIZE, 4);
	lrAudio.assign(AUDIO_BUFFER_SIZE, 0.0);
}

//--------------------------------------------------------------
void testApp::update(){

}

//--------------------------------------------------------------
void testApp::draw(){
	ofPushStyle();
	ofNoFill();

	//ofSetFrameRate(30);
	
	ofDrawBitmapString(ofToString(ofGetFrameRate())+"fps", 10, 15);

	const vector<string> &names = ofxStkGetInstrmntNames();
	
	// draw button names
	for(int i = 0; i < mNumStkInstrmnt; i++) {
		ofDrawBitmapString(names[i],
						   buttonX + (buttonSize << 1),
						   buttonY + (buttonSize * 0.8) + (buttonSize << 1) *i);
	}
	
	// draw dial names
	const vector<ControlChangeInfo> &infos = ofxStkControlChangeInfos(names[mCurrentInstrmnt]);
	for(int i = 0; i < infos.size(); i++)
	{
		int bitmap_font_size = 5;
		int name_length_offset = (dialSize >> 1) - ((infos[i].name.size() * bitmap_font_size) >> 1);
		int xx = dialX + dialLocationMargin + ((dialSize*4.0 + dialLocationMargin) * (i % 4));
		int yy = dialY + dialLocationMargin + ((dialSize*2.3 + dialLocationMargin) * (i / 4));
		string short_name = infos[i].name.substr(0, 8);
		ofDrawBitmapString(infos[i].name, xx + name_length_offset, yy);
	}
	
	// draw signal scope rect
	{
		ofColor(100, 100, 100); 
		ofRect(sigAreaX, sigAreaY, sigAreaW, sigAreaH);
	}

	// draw signal scope
	{
		int hh = sigAreaH >> 1;
		ofPushMatrix();
		ofTranslate(sigAreaX, sigAreaY);
		ofColor(150, 150, 10);
		ofBeginShape();
		for(int i = 0; i < AUDIO_BUFFER_SIZE; i++)
		{
			double x = ofMap(i, 0, AUDIO_BUFFER_SIZE, 0, sigAreaW);
			double y = hh + (sigAreaH * lrAudio[i]);
			ofVertex(x, y);
		}
		ofEndShape();
		ofPopMatrix();
	}
	
	ofPopStyle();
}

void testApp::audioOut(float *output, int size, int channels)
{
    for(int i = 0; i < size; i++) {
        double v = insts[mCurrentInstrmnt]->tick();
        output[i * channels] = v;
        output[i * channels + 1] = v;
		lrAudio[i] = v;
    }
}

void testApp::buttonNotify(ofxSimpleButtonEvent event)
{
	for(int i = 0; i < mNumStkInstrmnt; i++) {
		if(event.button == &buttons[i]) {
			const vector<string> &names = ofxStkGetInstrmntNames();
			const string nm = names[i];
			const vector<ControlChangeInfo> &infos = ofxStkControlChangeInfos(nm);
			printf("Instrmnt : %s\n", nm.c_str());
			for(vector<ControlChangeInfo>::const_iterator itr = infos.begin(); itr != infos.end(); itr++) {
				ControlChangeInfo info = ((ControlChangeInfo)*itr);
				printf("%d, %s\n", info.number, info.name.c_str());
			}
			
			if(event.type == BUTTON_PRESSED) {
				insts[i]->noteOn(220, 0.5);
			} else if(event.type == BUTTON_RELEASED) {
				insts[i]->noteOff(0.5);
			}

			mCurrentInstrmnt = i;

			break;
		}
	}
}
void testApp::dialNotify(ofxSimpleDialEvent &event)
{
	for(int i = 0; i < NUM_DIALS; i++) {
		if(event.dial == &dials[i]) {
			printf("dial number = %d, value = %f\n", i, event.value);
		}
	}
}

//--------------------------------------------------------------
void testApp::keyPressed(int key){

}

//--------------------------------------------------------------
void testApp::keyReleased(int key){

}

//--------------------------------------------------------------
void testApp::mouseMoved(int x, int y ){

}

//--------------------------------------------------------------
void testApp::mouseDragged(int x, int y, int button){

}

//--------------------------------------------------------------
void testApp::mousePressed(int x, int y, int button){

}

//--------------------------------------------------------------
void testApp::mouseReleased(int x, int y, int button){

}

//--------------------------------------------------------------
void testApp::windowResized(int w, int h){

}

//--------------------------------------------------------------
void testApp::gotMessage(ofMessage msg){

}

//--------------------------------------------------------------
void testApp::dragEvent(ofDragInfo dragInfo){ 

}
