#ifndef __OFX_SIMPLE_DIAL__
#define __OFX_SIMPLE_DIAL__

#include "ofMain.h"

class ofxSimpleDial;

typedef enum ofxSimpleDialEventType {
	DIAL_PRESSED,
	DIAL_RELEASED,
	DIAL_CHANGED,
} ofxSimpleDialEventType;

struct ofxSimpleDialEvent {
	ofxSimpleDial *dial;
	ofxSimpleDialEventType type;
	float value;
};

class ofxSimpleDialListener {
public:
	virtual void dialNotify(ofxSimpleDialEvent &event) = 0;
};

class ofxSimpleDial {
public:
	void setup(int x, int y, int size, bool fill);
	void draw(ofEventArgs& event);
	
	void mousePressed(ofMouseEventArgs& event);
	void mouseReleased(ofMouseEventArgs& event);
	void mouseDragged(ofMouseEventArgs& event);
	
	void setOnColor(ofColor &color) { this->mOnColor = color; }
	void setOffColor(ofColor &color) { this->mOffColor = color; }

	void addListener(ofxSimpleDialListener *listener);
	void removeListner(ofxSimpleDialListener *listener);
	
private:
	int mX, mY, mSize;
	int mPressX, mPressY;
	bool mFill;
	ofxSimpleDialEventType mState;
	ofColor mOnColor, mOffColor, mCurrentColor;
	
	float mValue;
	float mRotateDegree;
	float mDialSpeed;

	float mDrawPrecision;
	float mRingOpenRatio;
	
	vector<ofxSimpleDialListener *> mDialListeners;
	
	void sendNotify(ofxSimpleDialEventType type);
};

#endif // __OFX_SIMPLE_DIAL__
