#include "ofxSimpleButton.h"

void ofxSimpleButton::setup(int x, int y, int w, int h, bool fill)
{
	this->x = x;
	this->y = y;
	this->w = w;
	this->h = h;
	this->fill = fill;
	this->state = false;

	onColor = ofColor(150, 150, 100);
	offColor = ofColor(70, 70, 70);
 
	ofAddListener(ofEvents().draw, this, &ofxSimpleButton::draw);
	ofAddListener(ofEvents().mousePressed, this, &ofxSimpleButton::mousePressed);	
	ofAddListener(ofEvents().mouseReleased, this, &ofxSimpleButton::mouseReleased);	
}

void ofxSimpleButton::draw(ofEventArgs& event)
{
	ofPushStyle();
	ofPushMatrix();
	
	ofSetColor((state ? onColor : offColor));

	ofRect(x, y, w, h);

	ofPopMatrix();
	ofPopStyle();
}

void ofxSimpleButton::sendNotify(ofxSimpleButtonEventType type)
{
	ofxSimpleButtonEvent event;
	event.button = this;
	event.type = type;
	for(vector<ofxSimpleButtonListener*>::iterator itr = listeners.begin();
		itr != listeners.end(); itr++) {
		((ofxSimpleButtonListener*)*itr)->buttonNotify(event);
	}
}

void ofxSimpleButton::mousePressed(ofMouseEventArgs& event)
{
	if(x < event.x && event.x < (x + w) &&
	   y < event.y && event.y < (y + h)) {
		sendNotify(BUTTON_PRESSED);
		state = true;
	}
}

void ofxSimpleButton::mouseReleased(ofMouseEventArgs& event)
{
	if(state) {
		sendNotify(BUTTON_RELEASED);
	}
	state = false;
}

void ofxSimpleButton::addListener(ofxSimpleButtonListener *listener)
{
	listeners.push_back(listener);
}

void ofxSimpleButton::removeListner(ofxSimpleButtonListener *listener)
{
	vector<ofxSimpleButtonListener*>::iterator itr = remove(listeners.begin(),
															listeners.end(), listener);
	listeners.erase(itr, listeners.end());
}
