#ifndef __PDRAW_TEST_003__
#define __PDRAW_TEST_003__

#include "BlitSaw.h"
#include "Clarinet.h"
#include "ADSR.h"
#include "Saxofony.h"
#include "Rhodey.h"

#include "GrMain.h";
#include "AuMain.h";
#include "GrButton.h"
#include "GrDial.h"
#include "GrColors.h"

//using namespace stk;

#include "ofxMaxim.h"

enum eSoundKind {
	SoundKindSin = 0,
	SoundKindSaw,
	SoundKindClarinet,
	SoundKindSaxofony,
	SoundKindRhodey,
};

class PDrawTest003 : public GrDrawer, GrMouse, PAudioOutStream, GrButtonListener, GrDialListener
{
public:
	PDrawTest003(GrMain *grmain);
	~PDrawTest003();

	virtual void draw();

	virtual void audioOut(double *output, int size, int channels);

	void buttonNotify(eGrButtonEventKind kind, GrButton *button);
	void dialValueChanged(GrDial *grDial, double value);
	
private:
	GrMain *parent;
	GrButton *mNoteHold;
	vector<GrButton*> mButtons;
	vector<GrDial*> mDials;
	vector<double> mAudioBuffer;

	stk::ADSR mAdsr;
	PSin mSin;
	stk::BlitSaw mSaw;
	stk::Clarinet mClarinet;
	stk::Saxofony mSaxopony;
	stk::Rhodey mRhodey;
	
	int mSoundNumber;
	double mFreq, mGain;
	bool mHold;
	bool mNote;

	ofxMaxiFFT mfft;
	float *mFftPowdB;
};

#endif // __PDRAW_TEST_003__
