#include "GrShapeCurve.h"
#include "GrTextArea.h"

static void drawCurve(vector<ofPoint> &points, ofColor lineColor);
static void drawBezier(vector<ofPoint> &points, ofColor lineColor);

static void drawBezier(vector<ofPoint> &points, ofColor lineColor) {
	ofPath path;
	//bezierColor.set(128, 200);
	path.setColor(lineColor);
	path.setStrokeColor(lineColor);
	path.setFilled(true);

	vector<ofPoint>::iterator itr = points.begin();
	if(itr != points.end()) {
		path.moveTo(*itr++);
	}
	while (itr < points.end()) {
		if((itr+3) <= points.end()) {
			path.bezierTo(*itr, *(itr+1), *(itr+2));
		}
		itr += 3;
	}
	path.draw();
}

static void drawCurve(vector<ofPoint> &points, ofColor lineColor) {
	ofPath path;
	path.setColor(lineColor);
	path.setStrokeColor(lineColor);
	path.setFilled(false);
	for(vector<ofPoint>::iterator itr = points.begin(); itr != points.end(); itr++) {
		ofPoint &p = *itr;
		path.curveTo(p.x, p.y);
	}
	path.draw();
}

CurveTest::CurveTest(float size, int numPoints, float pointSize,
					 ofColor lineColor, ofColor pointColor) :
	size(size),
	numPoints(numPoints),
	pointSize(pointSize),
	lineColor(lineColor),
	pointColor(pointColor)
{
	updatePoints();
}

void CurveTest::updatePoints() {
	string dstr = "CurveText::updatePoints";
	ostringstream oss;
	oss << "CurveText::updatePoints num=" << numPoints;
	mutex.lock();
	points.clear();
	for(int i = 0; i < numPoints; i++) {
		ofPoint p(ofRandom(size), ofRandom(size));
		oss << " x=" << p.x << " y=" << p.y;
		points.push_back(p);
	}
	mutex.unlock();
	//textArea->addTextLine(string("CurveText::updatePoints"));
	if(textArea != NULL) {
		textArea->addTextLine(oss.str());
	}
}

void CurveTest::draw() {
	ofPushStyle();
	ofNoFill();
	ofTranslate((ofGetWidth()-size)/2, (ofGetHeight()-size)/2);
	
	// mutex.lock();
	// ofBeginShape();
	// for(vector<ofPoint>::iterator itr = points.begin(); itr != points.end(); itr++) {
	// 	ofCurveVertex(*itr);
	// }
	// ofEndShape();

	drawCurve(points, lineColor);

	drawBezier(points, lineColor);

	// draw line points
	ofSetColor(pointColor);	
	for(vector<ofPoint>::iterator itr = points.begin(); itr != points.end(); itr++) {
		ofPoint &p = *itr;
		ofCircle(p.x, p.y, pointSize);
	}
	mutex.unlock();
	
	ofPopStyle();
}

void CurveTest::mousePressed(int x, int y, int button) {
	updatePoints();
}

