#include "GrDial.h"
#include "PDraw.h"
#include "GrColors.h"

GrDial::GrDial(GrMain *parent, int x, int y, int size) : parent(parent),
																  mState(GR_DIAL_RELEASED),
																  mValue(0), mDialSpeed(1.5)
{
	this->mX = x;
	this->mY = y;
	this->mSize = size;

	double ratio = ofGetWidth() / ofGetHeight();

	PArc *arc = new PArc();
	arc->w = this->mSize; // half size
	arc->h = this->mSize;
	arc->radS = 0.05; // 0~1
	arc->radE = 0.95; // 0~1
	arc->weight = 0.5;
	arc->num = 30 + mSize * 0.2;

	PDraw *pdraw = new PDraw(arc);

	PPos *pos = new PPos(this->mX + this->mSize * ratio,
						 this->mY + this->mSize);
	pdraw->addStyle(pos);

	rotz = new PRotZ(0.0);
	pdraw->addStyle(rotz);
	rotz->z = (double)(-150 + (300 * mValue));

	PColor *color = new PColor(colorSet[COLOR_COOL_4C_BLUE]);
	pdraw->addStyle(color);

	parent->add(pdraw);
}

GrDial::~GrDial()
{
	
}

void GrDial::mouseMoved(int x, int y)
{
}

void GrDial::mouseDragged(int x, int y, int button)
{
	if(mState == GR_DIAL_PRESSED) {
		int distY = mPressY - y;
		mPressY = y;
		mValue += distY * mDialSpeed / (double)ofGetHeight();
		
		if(mValue > 1) {
			mValue = 1;
		} else if(mValue < 0) {
			mValue = 0;
		}
		rotz->z = (double)(-150 + (300 * mValue));
		//printf("dial level %d\n", distY);
		for(vector<GrDialListener*>::iterator itr = mDialListeners.begin();
			itr != mDialListeners.end(); itr++) {
			(*itr)->dialValueChanged(this, mValue);
		}
	}
}

void GrDial::mousePressed(int x, int y, int button)
{
	double dist = grDistance(mX+mSize, mY+mSize, x, y);
	if(dist < mSize) {
		mState = GR_DIAL_PRESSED;
		mPressX = x;
		mPressY = y;
	}
}

void GrDial::mouseReleased(int x, int y, int button)
{
	mState = GR_DIAL_RELEASED;
}

void GrDial::addGrDialListener(GrDialListener *listener)
{
	mDialListeners.push_back(listener);
}

void GrDial::removeGrDialListener(GrDialListener *listener)
{
	vector<GrDialListener*>::iterator end = std::remove(mDialListeners.begin(),
														mDialListeners.end(), listener);
	mDialListeners.erase(end, mDialListeners.end());
}




