#if 1

#include <stdio.h>
#include <string.h>

#define usage "usage : raw2table input.raw > table.c\n"

#define BIG_ENDIAN

int main(int argc, char *argv[]) 
{
	FILE *fp;
	int cnt = 0;
	char *name;
	fpos_t sizeByte;
	int sizeShort;
	
	short data;
	char bytes[2];
	
	if(argc != 2) {
		printf(usage);
		return -1;
	}

	if((fp = fopen(argv[1], "rb")) == NULL) {
		printf(usage);
		return -2;
	}

	// file siez
	fseek(fp, 0, SEEK_END);
	fgetpos(fp, &sizeByte);
	fseek(fp, 0, SEEK_SET);

	sizeShort = (int)sizeByte /2;

	name = strtok(argv[1], ".");
	
	printf("short StkRawTable_%s[%d] = {\n", argv[1], sizeShort);

#ifdef BIG_ENDIAN
	while(fread(&bytes[0], sizeof(char), 2, fp)) {
		data = ((bytes[0] << 8) & 0xff00) | (bytes[1] & 0x00FF);
		printf("\t%d,", data);
		if(++cnt == 8) {
			printf("\n");
			cnt = 0;
		}
	}
#else // BIG_ENDIAN
	while(fread(&data, sizeof(short), 1, fp)) {
		printf("\t%d,", data);
		if(++cnt == 8) {
			printf("\n");
			cnt = 0;
		}
	}
#endif // BIG_ENDIAN

	if(cnt != 0) {
		printf("\n");
	}

	printf("};\n\n");
}


#endif
