static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*******************************************************/
/* <clfunc.c>                                          */
/*      func                                           */
/*******************************************************/
#include "colmn.h"

extern CLCOMMON  CLcommon;
extern CLPRTBL   *pCLprocTable;
extern GlobalCt  *pGlobTable;
extern int giOptions[];

static uchar gucCodeType = '\0';

/*******************************************************/
/* cl_func_process                                     */
/* function; Exec Function.                            */
/*******************************************************/
int cl_func_process(proc)
ProcCT *proc;
{
	ScrPrCT *pScCT;
	int rc,iSel;
	char *pSel;
	ONTBL   *pOntbl;

	rc = 0;
/* Check specified function has been registered & execute. */
	if (!strcmp(proc->ProcNM,D_EPNM_INPUT)) {
		if (proc->INPCB.curlen >= proc->INPCB.maxlen) {
			pScCT = cl_search_src_ct();
#ifdef OLD_COAL
			if (pScCT->OnSelect >= 0) {
				pOntbl = pScCT->ONCOND[pScCT->OnSelect];
				if (*pOntbl->PrName[2]) {
					if ((iSel=pOntbl->PrSel[2]) == D_PRSEL_IP) {
						if (rc=cl_execute_proc(pOntbl->PrName[2])) return rc;
					}
					else {
						/* iSel=%d hoȊÓAsł܂B */
						ERROROUT1(FORMAT(391),iSel);
						return rc = ECL_EX_INPUT;
					}
				}
				*(pOntbl->PrName[2]) = '\0';
			}
			else
				cmn_set_stat(RET_PR,&proc->ptype,L_ON);
#else
			if (pScCT->OnSelect >= 0) {
				pOntbl = pScCT->ONCOND[pScCT->OnSelect];
				if (*pOntbl->PrName[2] &&
				    cmn_chk_stat(GR3_PR,&pScCT->ptype) != L_OFF) {
					cmn_set_stat(GR3_PR,&pScCT->ptype,L_OFF);
					if (rc=cl_input_exec_proc(pOntbl->PrSel[2],pOntbl->PrName[2])) return rc;
				}
				else
					cmn_set_stat(RET_PR,&proc->ptype,L_ON);
			}
#endif
		}
		else {
			rc = input();
/*
printf("input return = %d\n",rc);
*/
		}
		if (rc==0 && cmn_chk_stat( RET_PR , &proc->ptype )){
			rc = cl_er_lk_proc_ct();
			if(rc == NormalEnd)
				return(rc);
			else
				return(ECL_SYSTEM_ERROR);
		}
	}
	else if (!strcmp(proc->ProcNM,D_EPNM_INPUTXML)) {
		rc = input_xml(0);
		if (rc==0 && cmn_chk_stat(RET_PR,&proc->ptype)) {
		/*	akxt_set_code_type(gucCodeType);	*/
			rc = cl_er_lk_proc_ct();
			if(rc == NormalEnd) return(rc);
			else return(ECL_SYSTEM_ERROR);
		}
	}
	else if (!strcmp(proc->ProcNM,D_EPNM_SELMAIN)) {
		if (cmn_chk_stat(SEL_ED,&pCLprocTable->SearchSt) != L_OFF) {
			/* Erase ProcCt & restart previous process */
			rc = cl_er_lk_proc_ct();
			if(rc == NormalEnd) {
			/*	rc = cl_execute_script();	*/
				return(rc);
			}
			else
				return(ECL_SYSTEM_ERROR);
		}
		else
			rc = cl_sel_main();
		if (cmn_chk_stat(SEL_ED,&pCLprocTable->SearchSt) != L_OFF ) {
			/* Erase ProcCt & restart previous process */
			cmn_set_stat(SEL_ED,&pCLprocTable->SearchSt,L_OFF);
			if (cl_er_lk_proc_ct()) return(ECL_SYSTEM_ERROR);
			return(rc);
		}
	}
	else
		rc = ECL_SYSTEM_ERROR;
	if (rc) cl_er_lk_proc_ct();
	return(rc);
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_shell(pWork,nparm,pParm)
char *pWork;
int  nparm;
tdtInfoParm *pParm;
{
	int  ret,len;
	char w1[32],*p1;

	ret = 0;
	p1 = w1;
	if ((len = parm_to_char(&pParm[0],&p1,NULL)) < 0) return len;
/*
printf("cl_ex_shell: len=%d p1=[%s]\n",len,p1);
*/
	if (len > 0) {
		fflush(stdout);
		ret = system(p1);
		if (ret == -1) {
			pGlobTable->err_no = errno;
			pGlobTable->exception = cl_mk_exception_code(ETC_EXCEPTION,errno);
			pGlobTable->error = ret;
			ERROROUT3("cl_ex_shell: [%s] errno=%d %s",p1,errno,strerror(errno));
		}
		else ret = ret>>8 & 0xff;
	}
	else {
		ERROROUT(FORMAT(392));		/* cl_ex_shell: 󕶂łB */
	}
	memcpy(pWork,&ret,sizeof(int));

	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_no_free(pWork,nparm,pParm)
char *pWork;
int  nparm;
tdtInfoParm *pParm;
{
	int  ret,opt;

	if (nparm > 0) {
		if (ret=cl_get_parm_bin(&pParm[0],&opt,"cl_ex_no_free:")) return -1;
	}
	else opt = 0;
	ret = Nofree(opt);
	memcpy(pWork,&ret,sizeof(int));
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_eval(pInfoParmW,nparm,pParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *pParm;
{
	int  ret,flag;
	char w1[32],*p1;

	flag = 0;
	if (nparm >= 2) {
		if (ret=cl_get_parm_bin(&pParm[1],&flag,"eval flag:")) return -1;
	}
	p1 = w1;
	if ((ret = parm_to_char(&pParm[0],&p1,NULL)) >= 0) {
		if ((ret=cl_gx_expsn_obj_opt(p1,ret,NULL,NULL,pInfoParmW,0))<0) {
							/* cl_ex_eval: Ă܂Bret=%d */
			if (flag < 2) ERROROUT2(FORMAT(48),"cl_ex_eval",ret);
		}
		else if (ret==100) {
			ERROROUT1(FORMAT(185),"cl_ex_eval");	/* "cl_ex_eval: ܂B */
		}
	}
	if (flag) {
		if (pGlobTable->error = ret) {
			pGlobTable->exception = cl_mk_exception_code(ETC_EXCEPTION,ret);
			ret = cl_null_data(pInfoParmW);
		}
	}
/*
DEBUGOUT_InfoParm(150,"cl_ex_eval: ret=%d",pInfoParmW,ret,0);
*/
	return ret;
}
#if 0
/****************************************/
/*										*/
/****************************************/
static int _head_check(pCh,pData,lLen)
tdtChannel *pCh;
char *pData;
long lLen;
{
	ERROROUT2("Channel head_check: channel=%d len=%d",pCh->index,lLen);
/*
	aka_channel_command(pCh,1,101);
*/
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _exception(iCh,iEvent)
int iCh,iEvent;
{
	ERROROUT3("Channel exception: channel=%d event=%d %s",
	iCh,iEvent,aka_channel_event_msg(iEvent,0));
	return -1;
}
#endif
/****************************************/
/*										*/
/****************************************/
int cl_ex_channel(pWork,nparm,pParm)
char *pWork;
int  nparm;
tdtInfoParm *pParm;
{
	int  ret,i,iVal[2],iRc,iOpt;
#if 0
	char cmd;
	char w0[32],*p0;
	char w1[32],*p1;
	char w2[32],*p2;
	tdtChannelOpen tChannel;

	p0 = w0;
	p1 = w1;
	p2 = w2;
	iVal[0] = iVal[1] = iRc = 0;

	if ((ret = parm_to_char(&pParm[0],&p0,NULL)) < 0) {
		return ret;
	}
	cmd = toupper(*p0);
	if (cmd == 'O') {
		if (nparm < 3) {
			ERROROUT2("cl_ex_channel:%s:parameter(n=%d) is few!!",p0,nparm);
			ret = -1;
			goto Err;
		}
		if ((ret = parm_to_char(&pParm[1],&p1,NULL)) < 0) {
			goto Err;
		}
		if ((ret = parm_to_char(&pParm[2],&p2,NULL)) < 0) {
			goto Err;
		}
		for (i=3;i<=nparm-1;i++) {
			if (ret=cl_get_parm_bin(&pParm[i],&iVal[i-3],"HeadLen/Options:")) {
				if (ret > 0) ret = -1;
				goto Err;
			}
		}
		if (!iVal[0]) {
			iVal[1] |= AKA_CHSO_USE_AKB_HEAD;
		}

		memset(&tChannel,0,sizeof(tdtChannelOpen));
		tChannel.host_name = p1;
		tChannel.service  = p2;
		tChannel.head_len   = iVal[0];
		tChannel.opt      = iVal[1];
		tChannel.head_check  = _head_check;
		tChannel.exception  = _exception;
		if ((iRc = aka_channel_open(&tChannel)) <= 0) {
			pGlobTable->err_no = errno;
			ERROROUT1("cl_ex_channel: aka_channel_open ret=%d",iRc);
			if (!iRc) iRc = -1;
		}
		ret = 0;
	}
	else {
		if (ret=cl_get_parm_bin(&pParm[1],&iVal[0],"Channel No:")) {
			if (ret > 0) ret = -1;
			goto Err;
		}
		if (nparm >= 3) {
			if (ret=cl_get_parm_bin(&pParm[2],&iVal[1],"Option:")) {
				if (ret > 0) ret = -1;
				goto Err;
			}
		}
		if (cmd =='S') {
			ret = aka_channel_shut(iVal[0],iVal[1]);
		}
		else if (cmd =='R') {
			ret = aka_channel_resume(iVal[0],iVal[1]);
		}
		else if (cmd =='C') {
			ret = aka_channel_close(iVal[0]);
		}
		else {
			ERROROUT1("cl_ex_channel: Invalid command=[%s]",p1);
			ret = -1;
		}
		pGlobTable->err_no = errno;
	}
Err:
#else
	ret = iRc = 0;
#endif
	memcpy(pWork,&iRc,sizeof(int));
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_nval(pInfoParmW,nparm,pParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *pParm;
{
	tdtInfoParm *pInfoParm;
	int  ret;

	pInfoParm = &pParm[0];
	if (cl_is_null_parm(pInfoParm)) {
		/* cl_ex_nval: NULLp[^͎wł܂B */
		ERROROUT1(FORMAT(341),"cl_ex_nval");
		return -1;
	}
/*	if (pInfoParm->pi_dlen == 0)	*/
	if (cl_is_null_data(pInfoParm))
		pInfoParm = &pParm[1];
	ret = cl_gx_rep_info_set(pInfoParmW,pInfoParm,0);
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_ndef(pInfoParmW,nparm,pParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *pParm;
{
	int  ret,rc,opt,nf,opt1;
	char w1[32],*p1;

	opt1 = opt = 0;
	p1 = w1;
	if ((ret = parm_to_char(&pParm[0],&p1,NULL)) >= 0) {
		if (nparm >= 3) {
			if ((rc=cl_get_parm_bin(&pParm[2],&opt,"opt:")) < 0) return rc;
/*
printf("cl_ex_nde: opt=%d\n",opt);
*/
			opt1 = opt & 0x01;
		}
		ret = cl_gx_expsn_obj_opt(p1,ret,NULL,NULL,pInfoParmW,D_GX_OPT_NOEROUT_NDEF);
/*
DEBUGOUT_InfoParm(0,"cl_ex_ndef: ret=%d",pInfoParmW,ret,0);
*/
		if (ret==ECL_NDEFVAR_ERROR ||
		    (!ret && (cl_is_undef_parm(pInfoParmW)||cl_is_null_parm(pInfoParmW)))) {
			if (opt1) {
				ret = cl_set_parm_bin(pInfoParmW,1);
			}
			else {
				if (nparm > 1) {
					if (cl_is_null_parm(&pParm[1])) nf = 1;
					else nf = 0;
				}
				else nf = 1;
				if (nf) ret = cl_null_data(pInfoParmW);
				else ret = cl_gx_rep_info_set(pInfoParmW,&pParm[1],-1);
			}
		}
		else if (ret==100) {
			ERROROUT1((185),"cl_ex_ndef");	/* "cl_ex_ndef: ܂B */
		}
		else if (opt1) {
			ret = cl_set_parm_bin(pInfoParmW,0);
		}
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_shut_ctl(pWork,nparm,pParm)
char *pWork;
int  nparm;
tdtInfoParm *pParm;
{
	char val[2];
	int  ret;

	ret = aka_shut_control(AKA_SHUT_GET,val);
	memcpy(pWork,&ret,sizeof(int));
	return 0;
}

/************************************/
/*									*/
/************************************/
static int _push_exit(leaf,proc)
Leaf   *leaf;
ProcCT *proc;
{
	static parmList Retprmlist,*wprmp[2];
	static char	*retprm="TRY_EXIT";
	static Leaf	Retleaf;
	Leaf	*retleaf;
	parmList *retprmlist;

	retleaf = &Retleaf;
	retprmlist = &Retprmlist;
	memset(retleaf,0,sizeof(Leaf));
	retleaf->cmd.cid    = C_LET;
	retleaf->cmd.sub_cid= CS_TRY_EXIT;
	retleaf->cmd.prmnum = 1;
	retleaf->cmd.prmp   = wprmp;
	retleaf->cmd.prmp[0]= retprmlist;
	retprmlist->prmlen  = strlen(retprm);
	retprmlist->prp     = retprm;
	retprmlist->opt     = D_GX_OPT_NO_USE_OBJ;
	cl_ret_leaf_push(proc,retleaf);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_exit(pWork,nparm,pParm)
char *pWork;
int  nparm;
tdtInfoParm *pParm;
{
	int rc,val;
	ProcCT  *proc;
	tdtInfoParm *pInfoParmW;

	if (nparm > 0) {
		if (rc = cl_get_parm_bin(&pParm[0],&val,"Exit: ")) return rc;
		pGlobTable->error = val;
	}
	else val = 0;
/*
printf("cl_ex_exit: val=%08x\n",val);
*/
	if (proc = cl_search_proc_ct()) {
		if (cmn_chk_stat(UFN_PR,&proc->ptype)) {
			if (pInfoParmW=proc->Retval) {
				cl_set_parm_bin(pInfoParmW,val);
DEBUGOUT_InfoParm(110,"cl_ex_exit: proc=%s",pInfoParmW,proc->ProcNM,0);
			}
		}
	}
	memcpy(pWork,&val,sizeof(int));
	if (pGlobTable->try_level) cmn_set_stat(TRY_EXIT,&pCLprocTable->ScrSt,L_ON);
	else cmn_set_stat(SCR_ED,&pCLprocTable->ScrSt,L_ON);
	if (proc && proc->ucExcept > 0) {
		rc = cl_back_with_finally(NULL,proc,_push_exit);
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_exit_finally()
{
	int rc;
	ProcCT  *proc;

	if (pGlobTable->try_level) cmn_set_stat(TRY_EXIT,&pCLprocTable->ScrSt,L_ON);
	else cmn_set_stat(SCR_ED,&pCLprocTable->ScrSt,L_ON);
	if (proc = cl_search_proc_ct()) {
		if (proc->ucExcept > 0) {
			rc = cl_back_with_finally(NULL,proc,_push_exit);
		}
	}
	else rc = -1;
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_conv_parm(pInfoParmW,ope,pInfoParm1,opt,nparm)
tdtInfoParm *pInfoParmW;
char *ope;
tdtInfoParm *pInfoParm1;
int  opt,nparm;
{
	char w1[32],*p1,*p,op,c;
	parmList qprmList;
	int  i,len,ret,*pSize,*index;
	ScrPrCT *scrct;
	ProcCT  *proc;
	tdtInfoParm *pInfoParm,tInfoParm,***pTBL_pas;
	tdtArrayIndex tIndex;
	uchar ucLOCAL=0;

	opt &= (D_GX_OPT_STORE | D_GX_OPT_SET_LOCAL | D_GX_OPT_SET_GLOBAL);
	scrct = cl_search_src_ct();
	if (nparm <= 0) {
		/* Create MappedArray Name */
		memset(&tIndex,0,sizeof(tdtArrayIndex));
		tIndex.uAttr[0] = DEF_ZOK_VARI;
		tIndex.size = sizeof(tdtInfoParm *);
		index = tIndex.index;
		for (i=0;i<4;i++) index[i] = 1;
		c = *ope;
		if      (c == '$') pSize = (int *)scrct->Vary->pTBL_dolu[0];
		else if (c == '#') pSize = (int *)scrct->Vary->pTBL_igeta[0];
		else if (c == '%') {
			if (opt & D_GX_OPT_SET_LOCAL) {
				if (!(proc=cl_search_proc_ct())) return -1;
				if (!(pTBL_pas=proc->pTBL_pasento)) return -1;
				ucLOCAL = D_AUX1_LOCAL_VAR;
			}
			else pTBL_pas =scrct->Vary->pTBL_pasento;
			pSize = (int *)pTBL_pas[0];
		}
		if (c == '$') index[1] = pSize[1]*pSize[5];
		else if (ret=cl_get_parm_bin(cl_var_size_parm(pSize),&index[1],"cl_func_conv_parm:")) return ret;
		memset(&tInfoParm,0,sizeof(tdtInfoParm));
		tInfoParm.pi_id   = 'A';
		tInfoParm.pi_scale = 0;
		tInfoParm.pi_attr = DEF_ZOK_BULK;
		tInfoParm.pi_dlen  = sizeof(tdtArrayIndex);
		if (!(tInfoParm.pi_data = cl_tmp_const_malloc(sizeof(tdtArrayIndex)))) return ECL_MALLOC_ERROR;
		tInfoParm.pi_aux[1] = ucLOCAL;
		memcpy(tInfoParm.pi_data,&tIndex,sizeof(tdtArrayIndex));
		if (!(p=cl_tmp_const_malloc(sizeof(tdtInfoParm)+4))) {
			ERROROUT("Array name area malloc");
			return ECL_MALLOC_ERROR;
		}
		pInfoParm = (tdtInfoParm *)p;
		p += sizeof(tdtInfoParm);
		sprintf(p,"%c()",c);
		tInfoParm.pi_pos = (long)p;
		*pInfoParm = tInfoParm;
		ret = 0;
	}
	else {
		p1 = w1;
		if ((ret=parm_to_char(pInfoParm1,&p1,NULL)) < 0) return ret;
/*
printf("cl_func_conv_parm: ope=[%s] p1=[%s]\n",ope,p1);
*/
		len = strlen(p1);
		if (p = cl_tmp_const_malloc(len+strlen(ope)+1)) {
			strcpy(p,ope);
			strcat(p,p1);
			qprmList.prmlen  = strlen(p);
			qprmList.prp     = p;
			if (opt & D_GX_OPT_STORE) op = 's';
			else op = 'r';
			ret = cl_gx_get_info_parm_opt(scrct,op,&qprmList,&pInfoParm,opt);
			if (ret == ECL_DEFINED_ARRAY) {
				if (!(p=(char *)pInfoParm->pi_pos)) p = "";
				/* cl_func_conv_parm: z[%s]́Aϐɕϊł܂B */
				ERROROUT1(FORMAT(581),p);
			}
		}
		else ret = -1;
	}
	if (!ret) {
		if (opt & D_GX_OPT_STORE) {
			cl_set_parm_long(pInfoParmW,(long)pInfoParm);
			pInfoParmW->pi_id   = 'S';
		}
		else memcpy(pInfoParmW,pInfoParm,sizeof(tdtInfoParm));
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_f(pInfoParmW,nparm,pParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *pParm;
{
	int i,ret;
	char *p;
	tdtInfoParm *pInfoParm;

	pInfoParm = &pParm[0];
	ret = -1;
	memset(pInfoParmW,0,sizeof(tdtInfoParm));
	if (pInfoParm->pi_id==' ' && pInfoParm->pi_attr==DEF_ZOK_CHAR) {
		p = pInfoParm->pi_data;
		if (*p == '{') i = IS;	/* ֐ƂƂɂ */
#if 0
		else i = cl_gx_chk_opt(p);
		if (i==IS || i==STRING || i==TO || i==COMP || cl_gx_is_func_kubun(i) ||
		    (i==MATH && (!stricmp(p,"MOD")||!stricmp(p,"ABS")))) {
#else
		else {
			i = cl_gx_chk_opt(p);
			if (i==STRING || i==TO || i==COMP || cl_gx_is_func_kubun(i) ||
			    (i==MATH && (!stricmp(p,"MOD")||!stricmp(p,"ABS")))) i = 1;
			else i = 0;
		}
		if (!i) {
			if (cl_search_func_leaf_and_inner(cl_search_src_ct(),cl_search_proc_ct(),p,NULL))
				i = 1;	/* ֐ƂƂɂ */
		}
		if (i) {
#endif
			ret = 0;
			*pInfoParmW = *pInfoParm;
			pInfoParmW->pi_id = D_DATA_ID_FUNCTION;
		}
			/* cl_func_f: [%s]֐ł͂܂B */
		else ERROROUT1(FORMAT(393),p);
	}
	else ERROROUT(FORMAT(394));		/* cl_func_f: słB */
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_count(pWork,nparm,ppParm,opt)
char *pWork;
int  nparm;
tdtInfoParm **ppParm;
int opt;	/* 0:used, 1:max */
{
	tdtArrayIndex tIndex;
	tdtInfoParm *pInfoParm,**pvParm,*pDummy,tInfoParm,tInfoParm1,tInfoParm2;
	int ret,n,i,opt1,atr1;
	XHASHB *xhp;
	char c,*name,optc;
	int  *index;
	ScrPrCT *pScCT;

	pInfoParm = ppParm[0];
#if 1
	if (pInfoParm->pi_alen & D_AULN_PARMINFO2) {
#else
	if (opt & D_GX_OPT_PARMINFO2) {
#endif
		if (nparm=pInfoParm[1].pi_pos) {
			ret = pInfoParm[1].pi_hlen;
			memcpy(pWork,&nparm,sizeof(int));
			return ret;
		}
	}
	if ((c=pInfoParm->pi_id)=='R' || c=='A') {
		if (pInfoParm->pi_dlen == sizeof(tdtArrayIndex)) {
			memcpy(&tIndex,pInfoParm->pi_data,sizeof(tdtArrayIndex));
			if (c=='R') {
				if (xhp = tIndex.xhp) {
					if (opt) optc = 'm';
					else optc = 'u';
					ret = akxs_xhash2(xhp,optc,NULL,NULL);
				}
				else {
					index = tIndex.index;
					n = index[1]*index[2]*index[3];
					if (pvParm=tIndex.pVarIndex) {
						if (opt) ret = n;
						else {
							if (tIndex.uAttr[0] == DEF_ZOK_VARI) {
								ret = 0;
								for (i=0;i<n;i++) {
									if (!cl_is_null_parm(pvParm[i])) ret++;
								}
							}
							else ret = n;
						}
					}
					else ret = -1;
				}
			}
			else {	/* MAPPEDARRAY ̂Ƃ̏ */
				if (!(pScCT = (ScrPrCT *)pInfoParm->pi_len)) {
					if (!(pScCT = cl_search_src_ct())) {
						ERROROUT1(FORMAT(27),"cl_func_count");	/* VXeG[ */
						return ECL_SYSTEM_ERROR;
					}
				}
				opt1 = 0;
				if (pInfoParm->pi_aux[1] & D_AUX1_LOCAL_VAR) opt1 |= D_GX_OPT_SET_LOCAL;
				name = (char *)pInfoParm->pi_pos;
				index = tIndex.index;
				if ((c=name[0])=='%' || c=='#') {
					if (!(ret=cl_gx_get_all_var_ent(pScCT,'R',name,&pDummy,0,"",opt1))) {
						n = pDummy->pi_pos;
						n -= index[0]-1;
						if (n < 0) ret = 0;
						else ret = X_MIN(n,index[1]);
					}
				}
				else {	/* $ */
					if (opt) ret = index[1];
					else {
						ret = 0;
						for (i=0;i<index[1];i++) {
							if (!cl_gx_get_all_var_ent(pScCT,'R',name,&pDummy,i+index[0],"",opt1))
								ret++;
						}
					}
				}
			}
		}
		else ret = -1;
	}
	else if (c==' ') {
		if ((pInfoParm->pi_aux[0] & DEF_ZOK_DATA) && (pInfoParm->pi_alen & D_AULN_RANGE_DATA)) {
			cl_gx_copy_info(&tInfoParm1,pInfoParm);
			tInfoParm1.pi_aux[0] = tInfoParm1.pi_alen = 0;
			cl_gx_copy_info(&tInfoParm2,pInfoParm);
			tInfoParm2.pi_aux[0] = tInfoParm2.pi_alen = 0;
			atr1 = tInfoParm1.pi_attr;
			if (atr1 == DEF_ZOK_BINA) tInfoParm2.pi_pos = tInfoParm2.pi_hlen;
			else tInfoParm2.pi_data += tInfoParm2.pi_dlen;
/*
DEBUGOUT_InfoParm(0,"cl_func_count:tInfoParm1: ",&tInfoParm1,0,0);
DEBUGOUT_InfoParm(0,"cl_func_count:tInfoParm2: ",&tInfoParm2,0,0);
*/
			if (atr1 == DEF_ZOK_CHAR) {
/*
printf("cl_func_count: s2=[%s] s1=[%s]\n",tInfoParm2.pi_data,tInfoParm1.pi_data);
*/
				ret = (*(uchar *)(tInfoParm2.pi_data) - *(uchar *)(tInfoParm1.pi_data)) + 1;
			}
			else {
				if ((ret=cl_gx_bexp(&tInfoParm,&tInfoParm2,"-",&tInfoParm1,0,0)) < 0) return ret;
				cl_set_parm_bin(&tInfoParm1,1);
				if ((ret=cl_gx_bexp(&tInfoParm2,&tInfoParm,"+",&tInfoParm1,0,0)) < 0) return ret;
				if (ret=cl_get_parm_bin(&tInfoParm2,&n,"count: ")) return ret;
				ret = n;
			}
			if (ret < 0) ret = 0;
		}
		else if (pInfoParm->pi_dlen) ret = 1;
		else ret = 0;
	}
	else if (c==D_DATA_ID_LIST) {
		ret = akxs_rb_used(pInfoParm->pi_data);
	}
	else {
#if 0
		ret = 1;
#else
		ERROROUT(FORMAT(395));		/* f[^^słB */
		ret = ECL_SCRIPT_ERROR;
#endif
	}
/*
printf("cl_func_count: ret=%d\n",ret);
*/
	if (ret >= 0) {
		memcpy(pWork,&ret,sizeof(int));
		ret = 0;
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int func_env(ppWork,pOperator,nparm,ppParm,ope)
char **ppWork;
char *pOperator;
tdtInfoParm *ppParm[];
int nparm,ope;
{
	static char *cpPath=NULL;
	int ret,rc,len,overwrite;
	char *pWork,*name,*value,*p,*flg,*parm;
	char w1[32],w2[32];
	SSPL_S sspl;

printf("func_env: pOperator=%s nparm=%d ope=%d\n",pOperator,nparm,ope);

	ret = 0;
	pWork = *ppWork;
	name = w1;
	if ((len = parm_to_char(ppParm[0],&name,NULL)) >= 0) {
		switch (ope) {
			case D_FUC_PUTENV:
				if ((rc=akxnskipto(name,len,"=")) < len) {
					if (parm=cl_const_malloc(len+1)) {
						sspl.sp = 0;
						sspl.wd = parm;
						sspl.wdmax = len + 1;
						if ((rc=akxtgetwnspl(name,rc,&sspl,0x02)) > 0) {
							value = name;
							name = sspl.wd;
						}
					}
					else ret = ECL_MALLOC_ERROR;
				}
				else {
					ERROROUT1("func_env: not found '=' in [%s].",name);
					ret = ECL_SCRIPT_ERROR;
				}
				if (ret < 0) goto Err;
			case D_FUC_SETENV:
			case D_FUC_UNSETENV:
				if ((rc=akxs_xhash2(pCLprocTable->pha_env,'r',name,NULL)) < 0) ret = rc;
				else if (!rc) {
					if (p = getenv(name)) flg = "S:";
					else flg = "U:";
					p = stradd(flg,p);
					if ((rc=akxs_xhash2(pCLprocTable->pha_env,'s',name,p)) < 0) ret = rc;
printf("func_env: rc=%d name=[%s] p=[%s]\n",rc,name,p);
				}
				if (ope == D_FUC_SETENV) {
					if (nparm >= 3) {
						if (rc=cl_get_parm_bin(ppParm[2],&overwrite,"func_env.overwrite:")) {
							ret = ECL_SCRIPT_ERROR;
							goto Err;
						}
printf("func_env: overwrite=%d\n",overwrite);
					}
					else overwrite = 1;
					value = w2;
					if ((len = parm_to_char(ppParm[1],&value,NULL)) >= 0) {
						rc = setenv(name,value,overwrite);
					}
					else ret = len;
				}
				else if (ope == D_FUC_UNSETENV) {
					rc = unsetenv(name);
				}
				else {	/*  == D_FUC_PUTENV */
					memcpy(parm,value,len+1);
					rc = putenv(parm);
				}
				break;
			case D_FUC_GETENV:
				*ppWork = getenv(name);
				break;
			default:
				ERROROUT1("func_env: function=[%s] not defined!!",pOperator);
				rc = ret = ECL_SCRIPT_ERROR;
		}
		pGlobTable->err_no = errno;
	}
 Err:
	if (ope != D_FUC_GETENV) memcpy(pWork,&rc,sizeof(int));
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_env_reset(pha)
XHASHB *pha;
{
	int i,max,rc;
	char *name,*value;

	if (!pha) return 0;
	max = akxs_xhash2(pha,'m',NULL,NULL);
/*
printf("cl_env_reset: max = %d\n",max);
*/
	for (i=1;i<=max;i++) {
		pha->xha_xhix = i;
		if (akxs_xhash2(pha,'p',&name,&value)>0) {
			if (*value == 'S') rc = setenv(name,value+2,1);
			else rc = unsetenv(name);
/*
printf("cl_env_reset: i=%d name=[%s] value=[%s]\n",i,name,value);
*/
			pGlobTable->err_no = errno;
		}
	}
	akxs_xhash_free(pha);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_get_time(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm *ppParm[];
{
	int  i,ret;
	struct timeval tval;
	char buf[64];

	if (nparm>0 && ppParm[0]->pi_dlen>0) {
		if ((ret=cl_get_parm_bin(ppParm[0],&i,"option:")) <0) return ret;
	}
	else i = 0;
	cl_set_parm_mpa(pInfoParmW,m_get_i(0));
	aka_get_msec(&tval);
	pGlobTable->err_no = errno;
	if (!i) akxe_timer_sub(&tval,&tval,&pCLprocTable->tScrTimeVal[0]);
	sprintf(buf,"%d.%03d",tval.tv_sec,tval.tv_usec/1000);
	m_set_a((MPA *)pInfoParmW->pi_data,buf);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_ex_round(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm **ppParm;
{
	tdtInfoParm *pInfoParm;
	int  ret;
	int		rc,atr1,iAttr[3],scale,option,i,pre1,sca1;
	int		Value1,Val1[NMPA_INT],iVal,w,iVal1;
	double  dValue1,dVal,dw;
	MPA     *mpa1;

	pInfoParm = ppParm[0];
	if (cl_is_null_parm(pInfoParm)) {
		ERROROUT1(FORMAT(341),"cl_ex_nval");	/* NULLp[^͎wł܂B */
		return -1;
	}
	if ((rc=cl_get_parm_mpa(pInfoParm,Val1,"val:",iAttr)) < 0) return rc;
	else if (rc > 0) return ECL_SCRIPT_ERROR;
	atr1 = pInfoParm->pi_attr;
	pre1 = pInfoParm->pi_hlen;
	sca1 = pInfoParm->pi_pos;

	scale = option = 0;
	if (nparm >= 2) {
		pInfoParm = ppParm[1];
		if ((rc=cl_get_parm_bin(pInfoParm,&scale,"scale:")) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
	}
	/* option=0:ľܓ/1:؎̂/2:؏グ  */
	if (nparm >= 3) {
		pInfoParm = ppParm[2];
		if ((rc=cl_get_parm_bin(pInfoParm,&option,"option:")) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
		option &= 0x03;
	}
/*
printf("cl_ex_round:atr1=%d\n",iAttr[0]);
*/
	mpa1 = (MPA *)Val1;
	switch (iAttr[0]) {
	case DEF_ZOK_BINA:
		Value1 = CL_GET_VAL_BIN(Val1);
		i = scale;
		iVal1 = Value1;
		w = 1;
		while (iVal1 && i<-1) {
			w *= 10;
			iVal1 /= 10;
			i++;
		}
		iVal = iVal1;
		if (iVal && i<0) {
			w *= 10;
			iVal /= 10;
		}
		if (iVal) {
			if (Value1-iVal*w) {
				if (!option) Value1 = ((iVal1+5)/10)*w;
				else if (option & 0x02) Value1 = (iVal+1)*w;
				else Value1 = iVal*w;
			}
		}
		else Value1 = 0;
		cl_set_parm_bin(pInfoParmW,Value1);
		break;
	case DEF_ZOK_FLOA:
		memcpy(&dValue1,Val1,sizeof(double));
		m_d2mpa(dValue1,mpa1);
	case DEF_ZOK_DECI:
		if ((rc=cl_mpa_scale_opt(mpa1,NMPA,scale,option)) < 0) return rc;

printf("cl_ex_round:Attr=%d ParmLen=%d PosData=%d\n",atr1,pre1,sca1);

		if (atr1==DEF_ZOK_DECI && pre1) {
			cl_set_parm_mpa(pInfoParmW,mpa1);
			if ((rc=cl_mpa_scale(mpa1,pre1,sca1))<0) return rc;
			memcpy(pInfoParmW->pi_data,mpa1,sizeof(MPA));
		}
		else {
			m_normalize(mpa1);
			if (atr1 == DEF_ZOK_DECI) cl_set_parm_mpa(pInfoParmW,mpa1);
			else {
				m_mpa2d(mpa1,&dValue1);
				cl_set_parm_double(pInfoParmW,dValue1);
			}
		}
		break;
	default:
		return ECL_SCRIPT_ERROR;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_mem_used(pAns,nparm,ppParm)
char *pAns;
int  nparm;
tdtInfoParm **ppParm;
{
	int rc,i,maxargs,ix,*index,lena[5],m;
	tdtInfoParm *pInfoParm,rInfoParm;
	tdtInfoParm ***pTBL;
	tdtArrayIndex tIndex;

	if (rc=cl_get_ITBL_maxargs(nparm,ppParm,&tIndex,&pTBL,1,5,&maxargs,NULL)) return rc;
	m = cl_mem_used(5,lena);
	index = tIndex.index;
	ix = index[0];
	for (i=0;i<maxargs;i++,ix++) {
		pInfoParm = cl_get_array_and_var_ent(&tIndex,pTBL,ix);
		if (pInfoParm) {
			cl_set_parm_bin(&rInfoParm,lena[i]);
			if (rc=cl_gx_rep_info_set(pInfoParm,&rInfoParm,1)) return rc;
		}
		else return -1;
	}
	memcpy(pAns,&m,sizeof(int));
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_code_type(opt,code_type)
int opt;
uchar code_type;
{
	if (opt) gucCodeType = code_type;
	return gucCodeType;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_getval(pInfoParmW,nparm,ppParm)
tdtInfoParm *pInfoParmW;
int  nparm;
tdtInfoParm **ppParm;
{
	static char *_fn_="cl_func_getval";
	tdtInfoParm *pInfoParm;
	char w1[32],*name;
	int rc,num;

	name = w1;
	if (parm_to_char(ppParm[0],&name,NULL) <= 0) {
		ERROROUT1(FORMAT(591),*_fn_);	/* %s: 擾NULLłB */
		return ECL_SCRIPT_ERROR;
	}
	if (!stricmp(name,"OPTION")) {
		if (nparm <= 1) goto Err;
		if ((rc=cl_get_parm_bin(ppParm[1],&num,"option number:")) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
		if (num<=0 || num>20) {
			ERROROUT2(FORMAT(593),*_fn_,num);	/* %s: IvVԍ(%d)͈͊OłB */
			return ECL_SCRIPT_ERROR;
		}
		cl_set_parm_long(pInfoParmW,giOptions[num-1]);
	}
	else {
		ERROROUT2(FORMAT(592),*_fn_,name);	/* %s: w擾[%s]͖T|[głB */
		return ECL_SCRIPT_ERROR;
	}
	return 0;
 Err:
	ERROROUT1(FORMAT(42),*_fn_);	/* %s: p[^܂B */
	return ECL_SCRIPT_ERROR;
}
