/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.plugin.moenizer;

import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.plugin.moenizer.MoeUI;
import org.omegat.plugin.moenizer.imageloader.IImageLoader;
import org.omegat.plugin.moenizer.imageloader.ImageLoader;
import org.omegat.util.Log;

public class Moenizer
implements IApplicationEventListener,
IProjectEventListener {
    private IImageLoader imageLoader;
    private MoeUI ui;

    public Moenizer() {
        CoreEvents.registerApplicationEventListener((IApplicationEventListener)this);
        CoreEvents.registerProjectChangeListener((IProjectEventListener)this);
        this.ui = null;
        this.imageLoader = ImageLoader.getInstance();
        new SlideShow().execute();
    }

    public void onApplicationStartup() {
        try {
            this.ui = MoeUI.getMoeUI();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CoreEvents.unregisterApplicationEventListener((IApplicationEventListener)Moenizer.this);
                    Moenizer.this.ui.transparent();
                }
            });
        }
        catch (Exception e) {
            Log.log((String)("Error raised at " + this.getClass().getCanonicalName() + ".onApplicationStartup()\n" + e));
        }
    }

    public void onApplicationShutdown() {
    }

    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        switch (eventType) {
            case CREATE: 
            case LOAD: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CoreEvents.unregisterProjectChangeListener((IProjectEventListener)Moenizer.this);
                        Moenizer.this.ui.transparentEditor();
                    }
                });
                break;
            }
        }
    }

    private class SlideShow
    extends SwingWorker<Object, Void> {
        private long interval = -1L;

        private SlideShow() {
        }

        @Override
        protected Object doInBackground() throws Exception {
            while (Moenizer.this.imageLoader.availableNext()) {
                BufferedImage image;
                Moenizer.this.imageLoader.readyForNextImage();
                long l = this.interval = this.interval < 0L ? 0L : Moenizer.this.imageLoader.getNextInterval();
                if (this.interval > 0L) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(this.interval);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if ((image = Moenizer.this.imageLoader.getNextImage()) == null) continue;
                while (Moenizer.this.ui == null) {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                Moenizer.this.ui.setBackground(image);
            }
            return null;
        }
    }
}

