﻿// == LICENSE INFORMATION ==
/*
 * First author tiritomato 2013.
 * This program is distributed under the GNU Lesser General Public License(LGPL ver3).
 * support blog (Japanese only) http://d.hatena.ne.jp/tiri_tomato/
 */
// == LICENSE INFORMATION ==

namespace DotNetEx.String
{
    //! @addtogroup DotNetEx-String名前空間
    //! @{

    //! @brief 複数行文字列を構築するクラスです。Appendでインデント深度が指定できます。
    public class IndentBuilder
    {
        //! @brief インデント１段分に使用する文字列を指定します。
        public System.String IndentUnit
        {
            get { return m_IndentUnit; }
            set { m_IndentUnit = value == null ? System.String.Empty : value; }
        }
        //! @brief コンストラクタ
        //! @details @param IndentUnit インデント１段分に使用する文字列を指定します。
        public IndentBuilder(System.String IndentUnit)
        {
			m_Builder = new System.Text.StringBuilder();
			this.IndentUnit = IndentUnit;
		}
        //! @brief 文字列を追加します。追加後の自動改行はしません。
        public void Append(System.String str) { Append(str, 0, null); }
        //! @brief 文字列を追加します。追加後の自動改行はしません。標準のインデント文字列を利用してインデント段数を指定して追加します。
        public void Append(System.String str, int indentDepth) { Append(str, indentDepth, null); }
        //! @brief 文字列を追加します。追加後の自動改行はしません。任意のインデント文字列（nullを指定すると標準のインデント文字列）を利用してインデント段数を指定して追加します。
        public void Append(System.String str, int indentDepth, System.String indentUnit)
        {
            if (str == null) return;
            if (indentUnit == null) indentUnit = IndentUnit;
            System.String indent = IndentUnit.Repeat(System.Math.Max(indentDepth, 0));
            m_Builder.Append(indent + str.Replace(System.Environment.NewLine, System.Environment.NewLine + indent));
        }
        //! @brief 文字列を追加します。追加後に自動改行します。
        public void AppendLine(System.String str) { AppendLine(str, 0, null); }
        //! @brief 文字列を追加します。追加後に自動改行します。標準のインデント文字列を利用してインデント段数を指定して追加します。
        public void AppendLine(System.String str, int indentDepth) { AppendLine(str, indentDepth, null); }
        //! @brief 文字列を追加します。追加後に自動改行します。任意のインデント文字列（nullを指定すると標準のインデント文字列）を利用してインデント段数を指定して追加します。
        public void AppendLine(System.String str, int indentDepth, System.String indentUnit)
        {
            Append(str, indentDepth, indentUnit);
            m_Builder.AppendLine();
        }
        //! @brief 内部の文字列データをひとつの文字列に結合します。
        public override System.String ToString() { return m_Builder.ToString(); }
		private System.String m_IndentUnit;
		private System.Text.StringBuilder m_Builder;
    }
    
    //! @}
}
