/*
 * Decompiled with CFR 0.152.
 */
package saccubus.net;

import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import javax.swing.JLabel;
import saccubus.ConvertingSetting;
import saccubus.net.BrowserInfo;
import saccubus.net.NicoClient;
import saccubus.net.NicoMap;
import saccubus.net.Path;
import saccubus.util.Stopwatch;

public class Loader {
    private ConvertingSetting setting;
    private final JLabel status;
    private final Stopwatch stopwatch;
    private String mailAddress;
    private String password;
    private String proxy;
    private int proxyPort;
    private String userSession;
    private BrowserInfo.BrowserCookieKind browserKind;

    public Loader(ConvertingSetting setting, JLabel status, JLabel watch) {
        this.setting = setting;
        this.status = status;
        this.stopwatch = new Stopwatch(watch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendtext(String text) {
        JLabel jLabel = this.status;
        synchronized (jLabel) {
            this.status.setText(text);
        }
    }

    public boolean load(String url, Path file) {
        if (!this.check(this.setting)) {
            return false;
        }
        NicoClient client = this.getNicoClient();
        if (client == null) {
            return false;
        }
        return this.loadToFile(client, url, file);
    }

    private boolean check(ConvertingSetting setting) {
        BrowserInfo browser = new BrowserInfo();
        this.userSession = browser.getUserSession(setting);
        this.browserKind = browser.getValidBrowser();
        if (this.browserKind == BrowserInfo.BrowserCookieKind.NONE) {
            this.mailAddress = setting.getMailAddress();
            this.password = setting.getPassword();
            if (this.mailAddress == null || this.mailAddress.isEmpty() || this.password == null || this.password.isEmpty()) {
                this.sendtext("\u30e1\u30fc\u30eb\u30a2\u30c9\u30ec\u30b9\u304b\u30d1\u30b9\u30ef\u30fc\u30c9\u304c\u7a7a\u767d\u3067\u3059\u3002");
                return false;
            }
        } else if (this.userSession.isEmpty()) {
            this.sendtext("\u30d6\u30e9\u30a6\u30b6" + this.browserKind.getName() + "\u306e\u30bb\u30c3\u30b7\u30e7\u30f3\u53d6\u5f97\u306b\u5931\u6557");
            return false;
        }
        if (setting.useProxy()) {
            this.proxy = setting.getProxy();
            this.proxyPort = setting.getProxyPort();
            if (this.proxy == null || this.proxy.isEmpty() || this.proxyPort < 0 || this.proxyPort > 65535) {
                this.sendtext("\u30d7\u30ed\u30ad\u30b7\u306e\u8a2d\u5b9a\u304c\u4e0d\u6b63\u3067\u3059\u3002");
                return false;
            }
        } else {
            this.proxy = null;
            this.proxyPort = -1;
        }
        return true;
    }

    private NicoClient getNicoClient() {
        this.sendtext("\u30ed\u30b0\u30a4\u30f3\u4e2d");
        NicoClient client = null;
        client = this.browserKind != BrowserInfo.BrowserCookieKind.NONE ? new NicoClient(this.browserKind, this.userSession, this.proxy, this.proxyPort, this.stopwatch) : new NicoClient(this.mailAddress, this.password, this.proxy, this.proxyPort, this.stopwatch);
        if (!client.isLoggedIn()) {
            this.sendtext("\u30ed\u30b0\u30a4\u30f3\u5931\u6557 " + this.browserKind.getName() + " " + client.getExtraError());
            System.out.println("\nLogin failed.");
            return null;
        }
        this.sendtext("\u30ed\u30b0\u30a4\u30f3\u6210\u529f " + this.browserKind.getName());
        return client;
    }

    private boolean loadToFile(NicoClient client, String url, Path file) {
        HttpURLConnection con;
        block7: {
            System.out.print("Loading...");
            con = client.urlConnectGET(url);
            if (con != null && con.getResponseCode() == 200) break block7;
            System.out.println("ng.\nCan't get URL Object:" + url);
            return false;
        }
        try {
            String ret;
            String encoding;
            if (file.canRead() && file.delete()) {
                System.out.print("previous file " + file.getRelativePath() + " deleted...");
            }
            if ((encoding = con.getContentEncoding()) == null) {
                encoding = "UTF-8";
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream(), encoding));
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding));
            if (client.Debug) {
                System.out.println();
                NicoMap nicomap = new NicoMap();
                nicomap.putConnection(con);
                nicomap.printAll(System.out);
            }
            while ((ret = br.readLine()) != null) {
                pw.println(ret);
            }
            System.out.println("ok.");
            br.close();
            pw.flush();
            pw.close();
            con.disconnect();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

