/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.internal.json;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.internal.http.HttpResponse;
import twitter4j.internal.json.DataObjectFactoryUtil;
import twitter4j.internal.json.StatusJSONImpl;
import twitter4j.internal.json.z_T4JInternalParseUtil;
import twitter4j.internal.org.json.JSONArray;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class QueryResultJSONImpl
implements QueryResult,
Serializable {
    private static final long serialVersionUID = -6781654399437121238L;
    private long sinceId;
    private long maxId;
    private String refreshUrl;
    private int count;
    private double completedIn;
    private String query;
    private List<Status> tweets;
    private String nextResults;
    static Method queryFactoryMethod;

    QueryResultJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        JSONObject json = res.asJSONObject();
        try {
            JSONObject searchMetaData = json.getJSONObject("search_metadata");
            this.completedIn = z_T4JInternalParseUtil.getDouble("completed_in", searchMetaData);
            this.count = z_T4JInternalParseUtil.getInt("count", searchMetaData);
            this.maxId = z_T4JInternalParseUtil.getLong("max_id", searchMetaData);
            this.nextResults = searchMetaData.has("next_results") ? searchMetaData.getString("next_results") : null;
            this.query = z_T4JInternalParseUtil.getURLDecodedString("query", searchMetaData);
            this.refreshUrl = z_T4JInternalParseUtil.getUnescapedString("refresh_url", searchMetaData);
            this.sinceId = z_T4JInternalParseUtil.getLong("since_id", searchMetaData);
            JSONArray array = json.getJSONArray("statuses");
            this.tweets = new ArrayList<Status>(array.length());
            if (conf.isJSONStoreEnabled()) {
                DataObjectFactoryUtil.clearThreadLocalMap();
            }
            for (int i = 0; i < array.length(); ++i) {
                JSONObject tweet = array.getJSONObject(i);
                this.tweets.add(new StatusJSONImpl(tweet, conf));
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + json.toString(), jsone);
        }
    }

    QueryResultJSONImpl(Query query) {
        this.sinceId = query.getSinceId();
        this.count = query.getCount();
        this.tweets = new ArrayList<Status>(0);
    }

    @Override
    public long getSinceId() {
        return this.sinceId;
    }

    @Override
    public long getMaxId() {
        return this.maxId;
    }

    @Override
    public String getRefreshUrl() {
        return this.getRefreshURL();
    }

    @Override
    public String getRefreshURL() {
        return this.refreshUrl;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public double getCompletedIn() {
        return this.completedIn;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public List<Status> getTweets() {
        return this.tweets;
    }

    @Override
    public Query nextQuery() {
        if (this.nextResults == null) {
            return null;
        }
        try {
            return (Query)queryFactoryMethod.invoke(null, (Object[])new String[]{this.nextResults});
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextResults != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryResult that = (QueryResult)o;
        if (Double.compare(that.getCompletedIn(), this.completedIn) != 0) {
            return false;
        }
        if (this.maxId != that.getMaxId()) {
            return false;
        }
        if (this.count != that.getCount()) {
            return false;
        }
        if (this.sinceId != that.getSinceId()) {
            return false;
        }
        if (!this.query.equals(that.getQuery())) {
            return false;
        }
        if (this.refreshUrl != null ? !this.refreshUrl.equals(that.getRefreshUrl()) : that.getRefreshUrl() != null) {
            return false;
        }
        return !(this.tweets != null ? !this.tweets.equals(that.getTweets()) : that.getTweets() != null);
    }

    public int hashCode() {
        int result = (int)(this.sinceId ^ this.sinceId >>> 32);
        result = 31 * result + (int)(this.maxId ^ this.maxId >>> 32);
        result = 31 * result + (this.refreshUrl != null ? this.refreshUrl.hashCode() : 0);
        result = 31 * result + this.count;
        long temp = this.completedIn != 0.0 ? Double.doubleToLongBits(this.completedIn) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.query.hashCode();
        result = 31 * result + (this.tweets != null ? this.tweets.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "QueryResultJSONImpl{sinceId=" + this.sinceId + ", maxId=" + this.maxId + ", refreshUrl='" + this.refreshUrl + '\'' + ", count=" + this.count + ", completedIn=" + this.completedIn + ", query='" + this.query + '\'' + ", tweets=" + this.tweets + '}';
    }

    static {
        Method[] methods;
        for (Method method : methods = Query.class.getDeclaredMethods()) {
            if (!method.getName().equals("createWithNextPageQuery")) continue;
            queryFactoryMethod = method;
            queryFactoryMethod.setAccessible(true);
            break;
        }
        if (queryFactoryMethod == null) {
            throw new ExceptionInInitializerError(new NoSuchMethodException("twitter4j.Query.createWithNextPageQuery(java.lang.String)"));
        }
    }
}

