/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.lib;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionComparator {
    private static final String OP_CHARS = "~\\-_\\.+";
    public static final String VERSION_PATTERN_STRING = "\\G(?:([0-9]+)|([a-zA-Z]+)|([~\\-_\\.+])(?![~\\-_\\.+]|\\z))|\\G\\z";
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\G(?:([0-9]+)|([a-zA-Z]+)|([~\\-_\\.+])(?![~\\-_\\.+]|\\z))|\\G\\z");

    public static int compareVersion(String a, String b) {
        if (a.equals(b)) {
            return 0;
        }
        Matcher srcMatcher = VERSION_PATTERN.matcher(a.replace("-SNAPSHOT", "~snapshot"));
        Matcher tgtMatcher = VERSION_PATTERN.matcher(b.replace("-SNAPSHOT", "~snapshot"));
        boolean gotLastOp = false;
        block5: while (!gotLastOp) {
            String tgtGroup;
            String srcGroup;
            if (srcMatcher.find()) {
                srcGroup = srcMatcher.group();
                if (srcGroup.isEmpty()) {
                    srcGroup = "!";
                    gotLastOp = true;
                }
            } else {
                throw new IllegalArgumentException("Illegal version string: " + a);
            }
            if (tgtMatcher.find()) {
                tgtGroup = tgtMatcher.group();
                if (tgtGroup.isEmpty()) {
                    tgtGroup = "!";
                    gotLastOp = true;
                }
            } else {
                throw new IllegalArgumentException("Illegal version string: " + b);
            }
            VersionComponentType srcType = VersionComparator.getVersionComponentType(srcGroup.charAt(0));
            VersionComponentType tgtType = VersionComparator.getVersionComponentType(tgtGroup.charAt(0));
            switch (srcType) {
                case NUMERIC: {
                    int compare;
                    if (tgtType == VersionComponentType.NUMERIC) {
                        int tgtVersionNumeric;
                        int srcVersionNumeric = Integer.parseInt(srcGroup);
                        compare = srcVersionNumeric - (tgtVersionNumeric = Integer.parseInt(tgtGroup));
                        if (compare == 0) continue block5;
                        return compare;
                    }
                    return 1;
                }
                case ALPHABETS: {
                    if (tgtType == VersionComponentType.NUMERIC) {
                        return -1;
                    }
                    if (tgtType == VersionComponentType.ALPHABETS) {
                        int compare = srcGroup.compareTo(tgtGroup);
                        if (compare == 0) continue block5;
                        return compare;
                    }
                    return 1;
                }
                case OP: {
                    int tgtPriorityOfOperator;
                    if (tgtType != VersionComponentType.OP) {
                        return -1;
                    }
                    int srcPriorityOfOperator = VersionComparator.getPriorityOfOperator(srcGroup);
                    int compare = srcPriorityOfOperator - (tgtPriorityOfOperator = VersionComparator.getPriorityOfOperator(tgtGroup));
                    if (compare == 0) continue block5;
                    return compare;
                }
                default: {
                    throw new AssertionError((Object)"Not implemented");
                }
            }
        }
        throw new AssertionError();
    }

    private static int getPriorityOfOperator(String opChar) {
        if (opChar.length() != 1) {
            throw new AssertionError((Object)"opChar must be one-length-string");
        }
        char c = opChar.charAt(0);
        switch (c) {
            case '~': {
                return -3;
            }
            case '-': {
                return -2;
            }
            case '_': {
                return -1;
            }
            case '!': {
                return 0;
            }
            case '.': {
                return 1;
            }
            case '+': {
                return 2;
            }
        }
        throw new AssertionError((Object)"opChar must be one of [~-_!.+]");
    }

    private static VersionComponentType getVersionComponentType(char srcFirstChar) {
        if (srcFirstChar >= '0' && srcFirstChar <= '9') {
            return VersionComponentType.NUMERIC;
        }
        if (srcFirstChar >= 'a' && srcFirstChar <= 'z' || srcFirstChar >= 'A' && srcFirstChar <= 'Z') {
            return VersionComponentType.ALPHABETS;
        }
        return VersionComponentType.OP;
    }

    protected static enum VersionComponentType {
        ALPHABETS,
        NUMERIC,
        OP;

    }
}

