/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextUtil
extends ContextAwareBase {
    public ContextUtil(Context context) {
        this.setContext(context);
    }

    public static String getLocalHostName() throws UnknownHostException {
        InetAddress localhost = InetAddress.getLocalHost();
        return localhost.getHostName();
    }

    public void addHostNameAsProperty() {
        try {
            String localhostName = ContextUtil.getLocalHostName();
            this.context.putProperty("HOSTNAME", localhostName);
        }
        catch (UnknownHostException e) {
            this.addError("Failed to get local hostname", e);
        }
        catch (SecurityException e) {
            this.addError("Failed to get local hostname", e);
        }
    }

    public void addProperties(Properties props) {
        if (props == null) {
            return;
        }
        for (String string : props.keySet()) {
            this.context.putProperty(string, props.getProperty(string));
        }
    }

    public void addGroovyPackages(List<String> frameworkPackages) {
        this.addFrameworkPackage(frameworkPackages, "org.codehaus.groovy.runtime");
    }

    public void addFrameworkPackage(List<String> frameworkPackages, String packageName) {
        if (!frameworkPackages.contains(packageName)) {
            frameworkPackages.add(packageName);
        }
    }
}

