/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.internal;

import com.twitter.Regex;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.syuriken.snsw.twclient.TweetLengthCalculator;
import jp.syuriken.snsw.twclient.internal.TweetLengthUpdater;

public class DefaultTweetLengthCalculator
implements TweetLengthCalculator {
    private final TweetLengthUpdater updater;
    public static final Pattern urlPattern = Regex.VALID_URL;

    public static int getTweetLength(String original) {
        int length = original.length();
        Matcher matcher = urlPattern.matcher(original);
        while (matcher.find()) {
            int start = matcher.start(3);
            int end = matcher.end(3);
            int fat = end - start - 20;
            length -= fat;
        }
        return length;
    }

    public DefaultTweetLengthCalculator(TweetLengthUpdater updater) {
        this.updater = updater;
    }

    @Override
    public void calcTweetLength(String original) {
        int length = DefaultTweetLengthCalculator.getTweetLength(original);
        Color color = length > 140 ? Color.RED : (length > 120 ? Color.ORANGE : Color.BLUE);
        this.updater.updatePostLength(String.valueOf(length), color, null);
    }

    @Override
    public String getShortenedText(String original) {
        return original;
    }
}

