/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.handler;

import com.twitter.Regex;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.TreeSet;
import java.util.regex.Matcher;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLEditorKit;
import jp.syuriken.snsw.twclient.ActionHandler;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientFrameApi;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.DefaultClientTab;
import jp.syuriken.snsw.twclient.StatusData;
import jp.syuriken.snsw.twclient.StatusPanel;
import jp.syuriken.snsw.twclient.TabRenderer;
import jp.syuriken.snsw.twclient.filter.IllegalSyntaxException;
import jp.syuriken.snsw.twclient.internal.HTMLFactoryDelegator;
import jp.syuriken.snsw.twclient.internal.TwitterRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.TwitterException;
import twitter4j.User;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

public class UserInfoViewActionHandler
implements ActionHandler {
    private static Logger logger = LoggerFactory.getLogger(UserInfoViewActionHandler.class);

    @Override
    public JMenuItem createJMenuItem(String commandName) {
        JMenuItem aboutMenuItem = new JMenuItem("\u30e6\u30fc\u30b6\u30fc\u306b\u3064\u3044\u3066(A)...", 65);
        return aboutMenuItem;
    }

    @Override
    public void handleAction(String actionName, StatusData statusData, ClientFrameApi api) {
        User user = null;
        if (actionName.contains("!")) {
            user = new UserFetcher(api, actionName).getUser();
        } else if (statusData != null && statusData.tag instanceof Status) {
            Status status = (Status)statusData.tag;
            if (status.isRetweet()) {
                status = status.getRetweetedStatus();
            }
            user = status.getUser();
        } else {
            throw new IllegalArgumentException("[userinfo AH] must call as userinfo!<screenName> or must statusData.tag is Status");
        }
        ClientConfiguration configuration = api.getClientConfiguration();
        UserInfoFrameTab tab = new UserInfoFrameTab(configuration, user);
        long userId = user.getId();
        configuration.addJob(new UserTimelineFetcher(tab, userId, api));
        configuration.addFrameTab(tab);
        configuration.focusFrameTab(tab);
    }

    @Override
    public void popupMenuWillBecomeVisible(JMenuItem menuItem, StatusData statusData, ClientFrameApi api) {
        if (!statusData.isSystemNotify() && statusData.tag instanceof Status) {
            Status status = (Status)statusData.tag;
            if (status.isRetweet()) {
                status = status.getRetweetedStatus();
            }
            menuItem.setText(MessageFormat.format("@{0} ({1}) \u306b\u3064\u3044\u3066(A)", status.getUser().getScreenName(), status.getUser().getName()));
            menuItem.setEnabled(true);
        } else {
            menuItem.setEnabled(false);
        }
    }

    private static final class UserTimelineFetcher
    extends TwitterRunnable {
        private final UserInfoFrameTab tab;
        private final long userId;
        private final ClientFrameApi api;

        private UserTimelineFetcher(UserInfoFrameTab tab, long userId, ClientFrameApi api) {
            this.tab = tab;
            this.userId = userId;
            this.api = api;
        }

        @Override
        protected void access() throws TwitterException {
            ResponseList timeline = this.api.getTwitterForRead().getUserTimeline(this.userId);
            for (Status status : timeline) {
                this.tab.getRenderer().onStatus(status);
            }
            for (Status status : this.getConfiguration().getCacheManager().getStatusSet()) {
                if (status.getUser().getId() != this.userId) continue;
                this.tab.getRenderer().onStatus(status);
            }
        }

        @Override
        protected ClientConfiguration getConfiguration() {
            return this.api.getClientConfiguration();
        }

        @Override
        protected void handleException(TwitterException ex) {
            this.tab.getRenderer().onException((Exception)((Object)ex));
        }
    }

    public static class UserInfoFrameTab
    extends DefaultClientTab {
        private static final String TAB_ID = "userinfo";
        private final Font operationFont;
        protected User user;
        protected TabRenderer renderer;
        private JScrollPane componentBio;
        private JLabel componentLocation;
        private JPanel componentOperationsPanel;
        private JLabel componentUserIcon;
        private JLabel componentUserName;
        private JLabel componentUserURL;
        private JPanel componentUserInfoPanel;
        private JPanel tabComponent;
        private boolean focusGained;
        private boolean isDirty;
        private StringBuilder stringBuilder;
        JCheckBox muteCheckBox;
        private JLabel componentTwitterLogo;

        public UserInfoFrameTab(ClientConfiguration clientConfiguration, JSONObject jsonObject) throws JSONException, IllegalSyntaxException {
            super(clientConfiguration, jsonObject);
            this.operationFont = this.frameApi.getUiFont().deriveFont(this.frameApi.getUiFont().getSize() - 1);
            this.renderer = new UserInfoTweetsRenderer();
            this.stringBuilder = new StringBuilder();
            final long userId = jsonObject.getJSONObject("extended").getLong("userId");
            new TwitterRunnable(){

                @Override
                protected void access() {
                    UserInfoFrameTab.this.user = UserInfoFrameTab.this.getClientConfiguration().getCacheManager().getUser(userId);
                }

                @Override
                protected ClientConfiguration getConfiguration() {
                    return UserInfoFrameTab.this.getClientConfiguration();
                }
            }.run();
            this.configuration.addJob(new TwitterRunnable(){

                @Override
                protected void access() throws TwitterException {
                    ResponseList timeline = UserInfoFrameTab.this.getClientConfiguration().getFrameApi().getTwitterForRead().getUserTimeline(userId);
                    for (Status status : timeline) {
                        UserInfoFrameTab.this.getRenderer().onStatus(status);
                    }
                }

                @Override
                protected ClientConfiguration getConfiguration() {
                    return UserInfoFrameTab.this.getClientConfiguration();
                }

                @Override
                protected void handleException(TwitterException ex) {
                    this.getConfiguration().getRootFilterService().onException((Exception)((Object)ex));
                }
            });
        }

        public UserInfoFrameTab(ClientConfiguration clientConfiguration, String jsonString) throws JSONException, IllegalSyntaxException {
            this(clientConfiguration, new JSONObject(jsonString));
        }

        public UserInfoFrameTab(ClientConfiguration clientConfiguration, User user) {
            super(clientConfiguration);
            this.operationFont = this.frameApi.getUiFont().deriveFont(this.frameApi.getUiFont().getSize() - 1);
            this.renderer = new UserInfoTweetsRenderer();
            this.stringBuilder = new StringBuilder();
            this.user = user;
        }

        @Override
        public StatusPanel addStatus(StatusData statusData) {
            if (!this.focusGained && !this.isDirty) {
                this.isDirty = true;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UserInfoFrameTab.this.configuration.refreshTab(UserInfoFrameTab.this);
                    }
                });
            }
            return super.addStatus(statusData);
        }

        @Override
        public void focusGained() {
            super.focusGained();
            this.focusGained = true;
            this.isDirty = false;
            this.configuration.refreshTab(this);
        }

        @Override
        public void focusLost() {
            this.focusGained = false;
        }

        @Override
        public TabRenderer getActualRenderer() {
            return this.renderer;
        }

        ClientConfiguration getClientConfiguration() {
            return this.configuration;
        }

        private Component getComponentBio() {
            if (this.componentBio == null) {
                this.componentBio = new JScrollPane();
                this.componentBio.setOpaque(false);
                JEditorPane componentBioEditorPane = new JEditorPane();
                this.componentBio.getViewport().setOpaque(false);
                this.componentBio.getViewport().setView(componentBioEditorPane);
                componentBioEditorPane.setEditorKit(new HTMLEditorKitExtension());
                componentBioEditorPane.setContentType("text/html");
                componentBioEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                componentBioEditorPane.setEditable(false);
                componentBioEditorPane.setFont(this.frameApi.getUiFont());
                componentBioEditorPane.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent e) {
                        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            String url = e.getURL().toString();
                            if (url.startsWith("http://command/")) {
                                String command = url.substring("http://command/".length());
                                UserInfoFrameTab.this.handleAction(command);
                            } else {
                                try {
                                    UserInfoFrameTab.this.getConfiguration().getUtility().openBrowser(url);
                                }
                                catch (Exception e1) {
                                    UserInfoFrameTab.this.getRenderer().onException(e1);
                                }
                            }
                        }
                    }
                });
                Color bkgrnd = this.getComponentLocation().getBackground();
                componentBioEditorPane.setBackground(bkgrnd);
                componentBioEditorPane.setOpaque(false);
                String bio = this.user.getDescription();
                StringBuilder builder = this.stringBuilder;
                builder.setLength(0);
                builder.append("<html>");
                int index = 0;
                while (index < bio.length()) {
                    int end = bio.indexOf(10, index);
                    if (end == -1) {
                        end = bio.length();
                    }
                    builder.append(bio, index, end).append("<br>");
                    index = end + 1;
                }
                bio = builder.toString();
                StringBuffer buffer = new StringBuffer(bio.length());
                Matcher matcher = Regex.VALID_URL.matcher(bio);
                while (matcher.find()) {
                    matcher.appendReplacement(buffer, "$2<a href='$3'>$3</a>");
                }
                matcher.appendTail(buffer);
                bio = buffer.toString();
                buffer.setLength(0);
                matcher = Regex.AUTO_LINK_HASHTAGS.matcher(bio);
                while (matcher.find()) {
                    matcher.appendReplacement(buffer, "$1<a href='http://command/hashtag!$3'>$2$3</a>");
                }
                matcher.appendTail(buffer);
                bio = buffer.toString();
                buffer.setLength(0);
                matcher = Regex.AUTO_LINK_USERNAMES_OR_LISTS.matcher(bio);
                while (matcher.find()) {
                    String list = matcher.group(4);
                    if (list == null) {
                        matcher.appendReplacement(buffer, "$1<a href='http://command/userinfo!$3'>$2$3</a>");
                        continue;
                    }
                    matcher.appendReplacement(buffer, "$1<a href='http://command/list!$3$4'>$2$3$4</a>");
                }
                matcher.appendTail(buffer);
                componentBioEditorPane.setText(buffer.toString());
            }
            return this.componentBio;
        }

        private Component getComponentLocation() {
            if (this.componentLocation == null) {
                this.componentLocation = new JLabel();
                String location = this.user.getLocation();
                if (location != null) {
                    this.stringBuilder.setLength(0);
                    this.stringBuilder.append("<html><i>Location: </i>").append(location);
                    this.componentLocation.setText(this.stringBuilder.toString());
                }
            }
            return this.componentLocation;
        }

        private JCheckBox getComponentMuteCheckBox() {
            if (this.muteCheckBox == null) {
                String idsString = this.configuration.getConfigProperties().getProperty("core.filter.user.ids");
                String[] ids = idsString.split(" ");
                String userIdString = String.valueOf(this.user.getId());
                boolean filtered = false;
                for (String id : ids) {
                    if (!id.equals(userIdString)) continue;
                    filtered = true;
                    break;
                }
                this.muteCheckBox = new JCheckBox("\u30df\u30e5\u30fc\u30c8", filtered);
                if (this.frameApi.getLoginUser().getId() == this.user.getId()) {
                    this.muteCheckBox.setEnabled(false);
                    this.muteCheckBox.setToolTipText("\u305d\u3001\u305d\u308c\u306f\u3042\u306a\u305f\u306a\u3093\u3060\u304b\u3089\u306d\uff01");
                }
                this.muteCheckBox.setFont(this.operationFont);
                this.muteCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ClientProperties configProperties = UserInfoFrameTab.this.getConfiguration().getConfigProperties();
                        String idsString = configProperties.getProperty("core.filter.user.ids");
                        idsString = UserInfoFrameTab.this.muteCheckBox.isSelected() ? (idsString == null || idsString.trim().isEmpty() ? String.valueOf(UserInfoFrameTab.this.user.getId()) : idsString + " " + UserInfoFrameTab.this.user.getId()) : (idsString == null ? "" : idsString.replace(String.valueOf(UserInfoFrameTab.this.user.getId()), ""));
                        configProperties.setProperty("core.filter.user.ids", idsString);
                    }
                });
            }
            return this.muteCheckBox;
        }

        private Component getComponentOperationsPanel() {
            if (this.componentOperationsPanel == null) {
                this.componentOperationsPanel = new JPanel();
                this.componentOperationsPanel.setLayout(new BoxLayout(this.componentOperationsPanel, 1));
                try {
                    JLabel closeIcon = new JLabel(new ImageIcon(ImageIO.read(UserInfoViewActionHandler.class.getResource("../close16.png"))));
                    closeIcon.setText("\u9589\u3058\u308b");
                    closeIcon.setFont(this.operationFont);
                    closeIcon.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            UserInfoFrameTab.this.getConfiguration().removeFrameTab(UserInfoFrameTab.this);
                        }
                    });
                    this.componentOperationsPanel.add(closeIcon);
                }
                catch (IOException e) {
                    logger.warn("#getComponentOperationsPanel: Failed load resource");
                }
                this.componentOperationsPanel.add(this.getComponentMuteCheckBox());
            }
            return this.componentOperationsPanel;
        }

        private Component getComponentTweetsScrollPane() {
            return this.getScrollPane();
        }

        private Component getComponentTwitterLogo() {
            if (this.componentTwitterLogo == null) {
                Image scaledInstance = IMG_TWITTER_LOGO.getImage().getScaledInstance(16, 16, 4);
                this.componentTwitterLogo = new JLabel(new ImageIcon(scaledInstance));
                this.componentTwitterLogo.setMaximumSize(new Dimension(16, 16));
            }
            return this.componentTwitterLogo;
        }

        private Component getComponentUserIcon() {
            if (this.componentUserIcon == null) {
                this.componentUserIcon = new JLabel();
                this.frameApi.getImageCacher().setImageIcon(this.componentUserIcon, this.user);
            }
            return this.componentUserIcon;
        }

        private JPanel getComponentUserInfo() {
            if (this.componentUserInfoPanel == null) {
                this.componentUserInfoPanel = new JPanel();
                GroupLayout layout = new GroupLayout(this.componentUserInfoPanel);
                this.componentUserInfoPanel.setLayout(layout);
                layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.getComponentUserIcon(), 48, 48, 48).addContainerGap(4, 4).addComponent(this.getComponentOperationsPanel())).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup().addComponent(this.getComponentTwitterLogo(), GroupLayout.Alignment.CENTER, 16, 16, 16).addComponent(this.getComponentUserName()).addComponent(this.getComponentLocation())).addGap(4, 4, 4).addComponent(this.getComponentUserURL()).addGap(4, 4, 4).addComponent(this.getComponentBio())));
                layout.setHorizontalGroup(layout.createSequentialGroup().addGap(4, 4, 4).addGroup(layout.createParallelGroup().addComponent(this.getComponentUserIcon(), GroupLayout.Alignment.CENTER, 48, 48, 48).addComponent(this.getComponentOperationsPanel())).addGap(4, 4, 4).addGroup(layout.createParallelGroup().addGroup(layout.createSequentialGroup().addComponent(this.getComponentTwitterLogo(), 16, 16, 16).addComponent(this.getComponentUserName(), 64, -1, -2).addGap(16, 128, 128).addComponent(this.getComponentLocation(), 64, -1, -1)).addComponent(this.getComponentUserURL()).addComponent(this.getComponentBio(), 64, -2, Short.MAX_VALUE)));
            }
            return this.componentUserInfoPanel;
        }

        private Component getComponentUserName() {
            if (this.componentUserName == null) {
                this.componentUserName = new JLabel();
                this.componentUserName.setText(MessageFormat.format("@{0} ({1})", this.user.getScreenName(), this.user.getName()));
            }
            return this.componentUserName;
        }

        private Component getComponentUserURL() {
            if (this.componentUserURL == null) {
                this.componentUserURL = new JLabel();
                if (this.user.getURL() != null) {
                    this.stringBuilder.setLength(0);
                    this.stringBuilder.append("<html>URL:&nbsp;<a style='color:blue;text-decoration: underline;'>");
                    this.stringBuilder.append(this.user.getURL()).append("</a>");
                    this.componentUserURL.setText(this.stringBuilder.toString());
                }
                this.componentUserURL.setCursor(Cursor.getPredefinedCursor(12));
                this.componentUserURL.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (UserInfoFrameTab.this.user.getURL() != null) {
                            UserInfoFrameTab.this.handleAction("url!" + UserInfoFrameTab.this.user.getURL());
                        }
                    }
                });
            }
            return this.componentUserURL;
        }

        ClientConfiguration getConfiguration() {
            return this.configuration;
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        protected Object getSerializedExtendedData() throws JSONException {
            return new JSONObject().put("userId", this.user.getId());
        }

        @Override
        public JComponent getTabComponent() {
            this.tabComponent = new JPanel();
            GroupLayout layout = new GroupLayout(this.tabComponent);
            this.tabComponent.setLayout(layout);
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getComponentUserInfo(), 128, -2, Short.MAX_VALUE).addComponent(this.getComponentTweetsScrollPane()));
            layout.setHorizontalGroup(layout.createParallelGroup().addComponent(this.getComponentUserInfo(), 96, -2, -2).addComponent(this.getComponentTweetsScrollPane()));
            return this.tabComponent;
        }

        @Override
        public String getTabId() {
            return TAB_ID;
        }

        @Override
        public String getTitle() {
            this.stringBuilder.setLength(0);
            this.stringBuilder.append('@').append(this.user.getScreenName());
            if (this.isDirty) {
                this.stringBuilder.append('*');
            }
            return this.stringBuilder.toString();
        }

        @Override
        public String getToolTip() {
            return this.user.getName() + " \u306e\u30e6\u30fc\u30b6\u30fc\u60c5\u5831";
        }

        @Override
        public void initTimeline() {
        }

        public class UserInfoTweetsRenderer
        extends DefaultClientTab.DefaultRenderer {
            private final TreeSet<Long> treeSet = new TreeSet();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStatus(Status originalStatus) {
                if (originalStatus.getUser().getId() == UserInfoFrameTab.this.user.getId()) {
                    TreeSet<Long> treeSet = this.treeSet;
                    synchronized (treeSet) {
                        if (this.treeSet.contains(originalStatus.getId())) {
                            return;
                        }
                        this.treeSet.add(originalStatus.getId());
                    }
                    UserInfoFrameTab.this.addStatus(originalStatus);
                }
            }
        }
    }

    static final class UserFetcher
    extends TwitterRunnable {
        private final ClientConfiguration configuration;
        private final String userScreenName;
        private User user = null;

        protected UserFetcher(ClientFrameApi api, String actionName) {
            super(false);
            this.configuration = api.getClientConfiguration();
            this.userScreenName = actionName.substring(actionName.indexOf(33) + 1);
        }

        @Override
        protected void access() throws TwitterException {
            this.user = this.configuration.getTwitterForRead().showUser(this.userScreenName);
        }

        @Override
        protected ClientConfiguration getConfiguration() {
            return this.configuration;
        }

        protected User getUser() {
            this.run();
            return this.user;
        }
    }

    private static final class HTMLEditorKitExtension
    extends HTMLEditorKit {
        private static final long serialVersionUID = 7554202708087468592L;
        private transient HTMLEditorKit.HTMLFactory viewFactory = new HTMLFactoryDelegator();

        private HTMLEditorKitExtension() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.viewFactory;
        }
    }
}

