/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.handler;

import javax.swing.JMenuItem;
import jp.syuriken.snsw.twclient.ActionHandler;
import jp.syuriken.snsw.twclient.ClientFrameApi;
import jp.syuriken.snsw.twclient.ParallelRunnable;
import jp.syuriken.snsw.twclient.StatusData;
import twitter4j.Status;
import twitter4j.TwitterException;

public class RetweetActionHandler
implements ActionHandler {
    @Override
    public JMenuItem createJMenuItem(String commandName) {
        JMenuItem retweetMenuItem = new JMenuItem("\u30ea\u30c4\u30a4\u30fc\u30c8(T)", 84);
        return retweetMenuItem;
    }

    @Override
    public void handleAction(String actionName, StatusData statusData, final ClientFrameApi api) {
        if (statusData.tag instanceof Status) {
            final Status retweetStatus = (Status)statusData.tag;
            api.getClientConfiguration().addJob(new ParallelRunnable(){

                @Override
                public void run() {
                    try {
                        api.getTwitterForWrite().retweetStatus(retweetStatus.getId());
                    }
                    catch (TwitterException e) {
                        api.handleException(e);
                    }
                }
            });
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(JMenuItem menuItem, StatusData statusData, ClientFrameApi api) {
        if (statusData.isSystemNotify() || !(statusData.tag instanceof Status)) {
            menuItem.setVisible(false);
            menuItem.setEnabled(false);
        }
        if (statusData.tag instanceof Status) {
            Status status = (Status)statusData.tag;
            menuItem.setEnabled(!status.getUser().isProtected());
            menuItem.setVisible(status.getUser().getId() != api.getLoginUser().getId());
        }
    }
}

