/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.handler;

import com.twitter.Regex;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JMenuItem;
import jp.syuriken.snsw.twclient.ActionHandler;
import jp.syuriken.snsw.twclient.ClientFrameApi;
import jp.syuriken.snsw.twclient.StatusData;
import jp.syuriken.snsw.twclient.TweetLengthCalculator;
import jp.syuriken.snsw.twclient.internal.DefaultTweetLengthCalculator;
import jp.syuriken.snsw.twclient.internal.TweetLengthUpdater;
import twitter4j.Status;

public class QuoteTweetActionHandler
implements ActionHandler {
    @Override
    public JMenuItem createJMenuItem(String commandName) {
        JMenuItem quoteMenuItem = new JMenuItem("\u5f15\u7528(Q)", 81);
        return quoteMenuItem;
    }

    @Override
    public void handleAction(String actionName, StatusData statusData, ClientFrameApi api) {
        if (statusData.tag instanceof Status) {
            Status status = (Status)statusData.tag;
            api.setInReplyToStatus(status);
            api.setPostText(String.format(" QT @%s: %s", status.getUser().getScreenName(), status.getText()), 0, 0);
            api.focusPostBox();
            api.setTweetLengthCalculator(new QuoteTweetLengthCalculator(api));
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(JMenuItem menuItem, StatusData statusData, ClientFrameApi api) {
        if (!statusData.isSystemNotify() && statusData.tag instanceof Status) {
            menuItem.setEnabled(true);
        } else {
            menuItem.setEnabled(false);
        }
    }

    public static class QuoteTweetLengthCalculator
    implements TweetLengthCalculator {
        private final TweetLengthUpdater updater;
        private static Pattern qtPattern = Pattern.compile("[QR]T\\s?\\@[a-zA-Z01-9_]{1,20}\\:?+");
        private static Pattern tokenPattern = Pattern.compile("(?:" + Regex.VALID_URL + "|" + Regex.AUTO_LINK_HASHTAGS + "|" + Regex.AUTO_LINK_USERNAMES_OR_LISTS + ")", 2);
        private static Pattern urlPattern = Regex.VALID_URL;

        public QuoteTweetLengthCalculator(TweetLengthUpdater api) {
            this.updater = api;
        }

        @Override
        public void calcTweetLength(String original) {
            int length = original.length();
            boolean shortened = false;
            Matcher qtMatcher = qtPattern.matcher(original);
            if (qtMatcher.find()) {
                int qtIndex = qtMatcher.end();
                Matcher matcher = urlPattern.matcher(original);
                int fat = 0;
                int fatBeforeQT = 0;
                while (matcher.find()) {
                    int start = matcher.start(3);
                    int end = matcher.end(3);
                    fat += end - start - 20;
                    if (end >= qtIndex) continue;
                    fatBeforeQT = fat;
                }
                if (length - fat > 140) {
                    shortened = true;
                    length = qtMatcher.end() - fatBeforeQT;
                } else {
                    length -= fat;
                }
            } else {
                length = DefaultTweetLengthCalculator.getTweetLength(original);
            }
            Color color = length > 140 ? Color.RED : (length > 120 ? Color.ORANGE : Color.BLUE);
            if (shortened) {
                this.updater.updatePostLength(length + "+", color, "\u77ed\u7e2e\u3055\u308c\u307e\u3059(\u5b9f\u969b\u306e\u6295\u7a3f\u306f" + this.getShortenedText(original).length() + "\u6587\u5b57\u3067\u3059)");
            } else {
                this.updater.updatePostLength(String.valueOf(length), color, null);
            }
        }

        @Override
        public String getShortenedText(String original) {
            int qtEnd;
            int offset;
            int lastFat;
            Matcher qtMatcher = qtPattern.matcher(original);
            if (original.length() <= 140 || !qtMatcher.find()) {
                return original;
            }
            int lastTokenStart = qtMatcher.start();
            int fat = lastFat = 0;
            Matcher urlMatcher = urlPattern.matcher(original);
            while (urlMatcher.find()) {
                int start = urlMatcher.start(3);
                int end = urlMatcher.end(3);
                if (start - lastFat > lastTokenStart || end - fat > lastTokenStart) break;
                fat += end - start - 20;
            }
            if ((offset = (qtEnd = qtMatcher.end())) - fat > 140) {
                return original;
            }
            Matcher tokenMatcher = tokenPattern.matcher(original);
            while (tokenMatcher.find(offset - 1)) {
                lastTokenStart = tokenMatcher.start() + 1;
                offset = tokenMatcher.end();
                if (lastTokenStart - fat > 140) {
                    return original.substring(0, 140 + fat);
                }
                if (urlPattern.matcher(original.substring(lastTokenStart, offset)).find()) {
                    fat += offset - lastTokenStart - 20;
                }
                if (offset - fat <= 140) continue;
                return original.substring(0, lastTokenStart);
            }
            return original.substring(0, 140 + fat);
        }
    }
}

