/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.filter.func;

import java.lang.reflect.Constructor;
import jp.syuriken.snsw.twclient.filter.FilterDispatcherBase;
import jp.syuriken.snsw.twclient.filter.FilterFunction;
import jp.syuriken.snsw.twclient.filter.IllegalSyntaxException;
import twitter4j.DirectMessage;
import twitter4j.Status;

public class IfFilterFunction
implements FilterFunction {
    private static Constructor<IfFilterFunction> constructor;
    private final FilterDispatcherBase trueCond;
    private final FilterDispatcherBase falseCond;
    private FilterDispatcherBase expr;

    public static Constructor<? extends FilterFunction> getFactory() {
        return constructor;
    }

    public IfFilterFunction(String name, FilterDispatcherBase[] child) throws IllegalSyntaxException {
        int len = child.length;
        if (len < 2 || len > 3) {
            throw new IllegalSyntaxException("func<if> \u306e\u5f15\u6570\u306f2\u3064\u307e\u305f\u306f3\u3064\u3067\u306a\u3051\u308c\u3070\u306a\u308a\u307e\u305b\u3093");
        }
        this.expr = child[0];
        this.trueCond = child[1];
        this.falseCond = len == 3 ? child[2] : null;
    }

    @Override
    public boolean filter(DirectMessage directMessage) {
        if (this.expr.filter(directMessage)) {
            return this.trueCond.filter(directMessage);
        }
        return this.falseCond == null ? false : this.falseCond.filter(directMessage);
    }

    @Override
    public boolean filter(Status status) {
        if (this.expr.filter(status)) {
            return this.trueCond.filter(status);
        }
        return this.falseCond == null ? false : this.falseCond.filter(status);
    }

    static {
        try {
            constructor = IfFilterFunction.class.getConstructor(String.class, FilterDispatcherBase[].class);
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }
}

