/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.filter;

import java.text.MessageFormat;
import java.util.TreeSet;
import jp.syuriken.snsw.twclient.CacheManager;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ImageCacher;
import jp.syuriken.snsw.twclient.TwitterStatus;
import jp.syuriken.snsw.twclient.TwitterUser;
import jp.syuriken.snsw.twclient.filter.MessageFilter;
import jp.syuriken.snsw.twclient.internal.InitialMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.DirectMessage;
import twitter4j.StallWarning;
import twitter4j.Status;
import twitter4j.StatusDeletionNotice;
import twitter4j.User;
import twitter4j.UserList;

public class RootFilter
implements MessageFilter {
    private final ClientConfiguration configuration;
    private TreeSet<Long> statusSet;
    private ImageCacher imageCacher;
    private Logger logger = LoggerFactory.getLogger(RootFilter.class);
    private CacheManager cacheManager;

    public RootFilter(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.imageCacher = configuration.getImageCacher();
        this.cacheManager = configuration.getCacheManager();
        this.statusSet = new TreeSet();
    }

    private User getUser(User originalUser) {
        TwitterUser user;
        if (originalUser instanceof TwitterUser) {
            return originalUser;
        }
        User cachedUser = this.cacheManager.getCachedUser(originalUser.getId());
        if (cachedUser == null && (cachedUser = this.cacheManager.cacheUserIfAbsent(user = new TwitterUser(this.configuration, originalUser))) == null) {
            cachedUser = user;
        }
        return cachedUser;
    }

    @Override
    public boolean onChangeAccount(boolean forWrite) {
        this.configuration.getFetchScheduler().onChangeAccount(forWrite);
        return false;
    }

    @Override
    public boolean onClientMessage(String name, Object arg) {
        return false;
    }

    @Override
    public boolean onDeletionNotice(long directMessageId, long userId) {
        return false;
    }

    @Override
    public StatusDeletionNotice onDeletionNotice(StatusDeletionNotice statusDeletionNotice) {
        this.cacheManager.removeCachedStatus(statusDeletionNotice.getStatusId());
        return statusDeletionNotice;
    }

    @Override
    public DirectMessage onDirectMessage(DirectMessage message) {
        if (!(message instanceof InitialMessage)) {
            User sender = message.getSender();
            this.configuration.getFrameApi().getUtility().sendNotify(MessageFormat.format("{0} ({1})", sender.getScreenName(), sender.getName()), "DM\u3092\u53d7\u4fe1\u3057\u307e\u3057\u305f\uff1a" + message.getText(), this.imageCacher.getImageFile(sender));
        }
        return message;
    }

    @Override
    public boolean onException(Exception ex) {
        this.logger.warn("handling onException", (Throwable)ex);
        return false;
    }

    @Override
    public boolean onFavorite(User source, User target, Status favoritedStatus) {
        return false;
    }

    @Override
    public boolean onFollow(User source, User followedUser) {
        return false;
    }

    @Override
    public long[] onFriendList(long[] userIds) {
        for (long userId : userIds) {
            this.cacheManager.queueFetchingUser(userId);
        }
        return userIds;
    }

    @Override
    public boolean onRetweet(User source, User target, Status retweetedStatus) {
        return false;
    }

    @Override
    public boolean onScrubGeo(long userId, long upToStatusId) {
        return false;
    }

    @Override
    public boolean onStallWarning(StallWarning warning) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status onStatus(Status originalStatus) {
        Status status;
        TreeSet<Long> treeSet = this.statusSet;
        synchronized (treeSet) {
            if (this.statusSet.contains(originalStatus.getId())) {
                return null;
            }
            status = originalStatus.isRetweet() ? originalStatus.getRetweetedStatus() : originalStatus;
            this.statusSet.add(originalStatus.getId());
        }
        if (!(status instanceof TwitterStatus && ((TwitterStatus)status).isLoadedInitialization() || !this.configuration.isMentioned(status.getUserMentionEntities()))) {
            this.configuration.getUtility().sendNotify(originalStatus.getUser().getName(), originalStatus.getText(), this.imageCacher.getImageFile(originalStatus.getUser()));
        }
        return originalStatus;
    }

    @Override
    public boolean onStreamCleanUp() {
        return false;
    }

    @Override
    public boolean onStreamConnect() {
        return false;
    }

    @Override
    public boolean onStreamDisconnect() {
        return false;
    }

    @Override
    public boolean onTrackLimitationNotice(int numberOfLimitedStatuses) {
        return false;
    }

    @Override
    public boolean onUnblock(User source, User unblockedUser) {
        return false;
    }

    @Override
    public boolean onUnfavorite(User source, User target, Status unfavoritedStatus) {
        return false;
    }

    @Override
    public boolean onUserListCreation(User listOwner, UserList list) {
        return false;
    }

    @Override
    public boolean onUserListDeletion(User listOwner, UserList list) {
        return false;
    }

    @Override
    public boolean onUserListMemberAddition(User addedMember, User listOwner, UserList list) {
        return false;
    }

    @Override
    public boolean onUserListMemberDeletion(User deletedMember, User listOwner, UserList list) {
        return false;
    }

    @Override
    public boolean onUserListSubscription(User subscriber, User listOwner, UserList list) {
        return false;
    }

    @Override
    public boolean onUserListUnsubscription(User subscriber, User listOwner, UserList list) {
        return false;
    }

    @Override
    public boolean onUserListUpdate(User listOwner, UserList list) {
        return false;
    }

    @Override
    public boolean onUserProfileUpdate(User updatedUser) {
        User cachedUser = this.cacheManager.getCachedUser(updatedUser.getId());
        if (cachedUser == null) {
            this.cacheManager.cacheUserIfAbsent(this.getUser(updatedUser));
        } else if (cachedUser instanceof TwitterUser) {
            ((TwitterUser)cachedUser).updateUser(updatedUser);
        }
        return false;
    }
}

