/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient.filter;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.filter.FilterCompiler;
import jp.syuriken.snsw.twclient.filter.tokenizer.FilterParserVisitor;
import jp.syuriken.snsw.twclient.filter.tokenizer.Node;
import jp.syuriken.snsw.twclient.filter.tokenizer.ParseException;
import jp.syuriken.snsw.twclient.filter.tokenizer.QueryTokenFunction;
import jp.syuriken.snsw.twclient.filter.tokenizer.QueryTokenProperty;
import jp.syuriken.snsw.twclient.filter.tokenizer.QueryTokenPropertyOperator;
import jp.syuriken.snsw.twclient.filter.tokenizer.QueryTokenPropertyValue;
import jp.syuriken.snsw.twclient.filter.tokenizer.QueryTokenQuery;
import jp.syuriken.snsw.twclient.filter.tokenizer.QueryTokenStart;
import jp.syuriken.snsw.twclient.filter.tokenizer.SimpleNode;

public class FilterEditFrame
extends JFrame
implements WindowListener {
    private String propertyKey;
    private ClientProperties properties;
    private JTextArea filterEditTextArea;
    private JRadioButton excludeOptionButton;
    private JRadioButton extractOptionButton;

    public FilterEditFrame(ClientConfiguration configuration, String displayString, String propertyKey) {
        this.propertyKey = propertyKey;
        this.setDefaultCloseOperation(0);
        this.properties = configuration.getConfigProperties();
        this.initComponents(displayString);
    }

    private JRadioButton getComponentExcludeOption() {
        if (this.excludeOptionButton == null) {
            this.excludeOptionButton = new JRadioButton("\u9664\u5916");
        }
        return this.excludeOptionButton;
    }

    private JRadioButton getComponentExtractOption() {
        if (this.extractOptionButton == null) {
            this.extractOptionButton = new JRadioButton("\u62bd\u51fa");
        }
        return this.extractOptionButton;
    }

    private JTextArea getComponentFilterEditTextArea() {
        if (this.filterEditTextArea == null) {
            this.filterEditTextArea = new JTextArea();
        }
        return this.filterEditTextArea;
    }

    private void initComponents(String displayString) {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.getComponentExcludeOption());
        buttonGroup.add(this.getComponentExtractOption());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.getComponentExcludeOption()).addGap(0, 16, Short.MAX_VALUE).addComponent(this.getComponentExtractOption())).addComponent(this.getComponentFilterEditTextArea(), GroupLayout.Alignment.LEADING));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.getComponentExcludeOption(), GroupLayout.Alignment.LEADING, -2, -2, -2).addComponent(this.getComponentExtractOption(), GroupLayout.Alignment.TRAILING, -2, -2, -2)).addComponent(this.getComponentFilterEditTextArea(), 16, -1, Short.MAX_VALUE));
        this.addWindowListener(this);
        this.setTitle("\u30d5\u30a3\u30eb\u30bf\u306e\u7de8\u96c6 (" + displayString + ": " + this.propertyKey + ")");
        String filterQuery = this.properties.getProperty(this.propertyKey);
        if (filterQuery != null) {
            StringBuilder stringBuilder = new StringBuilder(filterQuery.length());
            try {
                QueryTokenStart tokenStart = FilterCompiler.tokenize(filterQuery);
                FilterQueryFormatter queryFormatter = new FilterQueryFormatter();
                tokenStart.jjtAccept((FilterParserVisitor)queryFormatter, (Object)stringBuilder);
                if (queryFormatter.isExtractFilter()) {
                    this.getComponentExtractOption().setSelected(true);
                } else {
                    this.getComponentExcludeOption().setSelected(true);
                }
            }
            catch (ParseException e) {
                stringBuilder.append(filterQuery).append("\n\n/* \u30af\u30a8\u30ea\u306e\u30d1\u30fc\u30b9\u4e2d\u306b\u30a8\u30e9\u30fc: ").append(e.getLocalizedMessage()).append("\n*/");
            }
            this.getComponentFilterEditTextArea().setText(stringBuilder.toString());
        }
        this.pack();
        this.setSize(400, 400);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.setExtendedState(0);
        try {
            QueryTokenStart tokenStart = FilterCompiler.tokenize(this.getComponentFilterEditTextArea().getText());
            StringBuilder stringBuilder = new StringBuilder();
            tokenStart.jjtAccept((FilterParserVisitor)new FilterQueryNormalizer(), (Object)stringBuilder);
            if (this.getComponentExtractOption().isSelected()) {
                stringBuilder.insert(0, "extract(");
                stringBuilder.append(')');
            }
            this.properties.setProperty(this.propertyKey, stringBuilder.toString());
            this.dispose();
        }
        catch (ParseException ex) {
            JOptionPane.showMessageDialog(this, "\u6b63\u3057\u304f\u306a\u3044\u6587\u6cd5\u306e\u30af\u30a8\u30ea\u3067\u3059\u3002\n" + ex.getLocalizedMessage());
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    protected static class FilterQueryNormalizer
    implements FilterParserVisitor {
        protected FilterQueryNormalizer() {
        }

        public Object visit(QueryTokenFunction node, Object data) {
            StringBuilder stringBuilder = (StringBuilder)data;
            stringBuilder.append(node.jjtGetValue()).append('(');
            int count = node.jjtGetNumChildren();
            if (count >= 0) {
                for (int i = 0; i < count; ++i) {
                    node.jjtGetChild(i).jjtAccept((FilterParserVisitor)this, data);
                    stringBuilder.append(',');
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            stringBuilder.append(')');
            return null;
        }

        public Object visit(QueryTokenProperty node, Object data) {
            ((StringBuilder)data).append(node.jjtGetValue());
            return node.childrenAccept((FilterParserVisitor)this, data);
        }

        public Object visit(QueryTokenPropertyOperator node, Object data) {
            return ((StringBuilder)data).append(node.jjtGetValue());
        }

        public Object visit(QueryTokenPropertyValue node, Object data) {
            return ((StringBuilder)data).append(node.jjtGetValue());
        }

        public Object visit(QueryTokenQuery node, Object data) {
            return node.childrenAccept((FilterParserVisitor)this, data);
        }

        public Object visit(QueryTokenStart node, Object data) {
            return node.childrenAccept((FilterParserVisitor)this, data);
        }

        public Object visit(SimpleNode node, Object data) {
            return null;
        }
    }

    protected static class FilterQueryFormatter
    implements FilterParserVisitor {
        protected transient int queryDepth;
        protected boolean isExtract;

        protected FilterQueryFormatter() {
        }

        public boolean isExtractFilter() {
            return this.isExtract;
        }

        public Object visit(QueryTokenFunction node, Object data) {
            StringBuilder stringBuilder = (StringBuilder)data;
            ++this.queryDepth;
            stringBuilder.append(node.jjtGetValue()).append("(\n");
            int childrenCount = node.jjtGetNumChildren();
            for (int i = 0; i < childrenCount; ++i) {
                for (int d = 0; d < this.queryDepth; ++d) {
                    stringBuilder.append("  ");
                }
                node.jjtGetChild(i).jjtAccept((FilterParserVisitor)this, data);
                stringBuilder.append(",\n");
            }
            int len = stringBuilder.length();
            stringBuilder.deleteCharAt(len - 2);
            --this.queryDepth;
            for (int i = 0; i < this.queryDepth; ++i) {
                stringBuilder.append("  ");
            }
            return stringBuilder.append(")");
        }

        public Object visit(QueryTokenProperty node, Object data) {
            ((StringBuilder)data).append(node.jjtGetValue());
            return node.childrenAccept((FilterParserVisitor)this, data);
        }

        public Object visit(QueryTokenPropertyOperator node, Object data) {
            return ((StringBuilder)data).append(' ').append(node.jjtGetValue());
        }

        public Object visit(QueryTokenPropertyValue node, Object data) {
            return ((StringBuilder)data).append(' ').append(node.jjtGetValue());
        }

        public Object visit(QueryTokenQuery node, Object data) {
            Node childNode;
            if (node.jjtGetNumChildren() >= 1 && (childNode = node.jjtGetChild(0)) instanceof QueryTokenFunction && "extract".equals(((QueryTokenFunction)childNode).jjtGetValue())) {
                this.isExtract = true;
                int argCount = childNode.jjtGetNumChildren();
                if (argCount == 0) {
                    return data;
                }
                ((QueryTokenFunction)childNode).childrenAccept((FilterParserVisitor)this, data);
            }
            return node.childrenAccept((FilterParserVisitor)this, data);
        }

        public Object visit(QueryTokenStart node, Object data) {
            return node.childrenAccept((FilterParserVisitor)this, data);
        }

        public Object visit(SimpleNode node, Object data) {
            return null;
        }
    }
}

