/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VersionInfo {
    private static final Logger logger = LoggerFactory.getLogger(VersionInfo.class);
    public static final Properties VERSION_INFO_RESOURCE;
    public static final String UNKNOWN_STRING = "<unknown>";

    public static String getArtifactId() {
        return VersionInfo.getString("pom.artifactId");
    }

    public static String getArtifactName() {
        return VersionInfo.getString("pom.name");
    }

    public static String getCommittedRevision() {
        return VersionInfo.getString("git.build-commit-abbrev");
    }

    public static String getDescribedVersion() {
        return VersionInfo.getString("git.build-version");
    }

    private static String getString(String key) {
        return VERSION_INFO_RESOURCE.getProperty(key, UNKNOWN_STRING);
    }

    public static String getSupportUrl() {
        return VersionInfo.getString("pom.url");
    }

    public static String getUniqueVersion() {
        String version = VersionInfo.getVersion();
        String revision = VersionInfo.getCommittedRevision();
        if (version.equals(UNKNOWN_STRING)) {
            return revision;
        }
        if (version.endsWith("-SNAPSHOT")) {
            return VersionInfo.getDescribedVersion();
        }
        return version;
    }

    public static String getVersion() {
        return VERSION_INFO_RESOURCE.getProperty("pom.version");
    }

    private VersionInfo() {
    }

    static {
        InputStream stream = VersionInfo.class.getClassLoader().getResourceAsStream("jp/syuriken/snsw/twclient/twclient-core-version.properties");
        VERSION_INFO_RESOURCE = new Properties();
        try {
            VERSION_INFO_RESOURCE.load(stream);
        }
        catch (IOException e) {
            logger.error("\u30d0\u30fc\u30b8\u30e7\u30f3\u60c5\u5831\u304c\u53d6\u5f97\u3067\u304d\u307e\u305b\u3093", (Throwable)e);
        }
    }
}

