/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.util.TimerTask;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.FilterService;
import jp.syuriken.snsw.twclient.ParallelRunnable;
import jp.syuriken.snsw.twclient.TwitterStatus;
import jp.syuriken.snsw.twclient.internal.InitialMessage;
import jp.syuriken.snsw.twclient.internal.TwitterRunnable;
import twitter4j.ConnectionLifeCycleListener;
import twitter4j.DirectMessage;
import twitter4j.Paging;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterStream;
import twitter4j.TwitterStreamFactory;
import twitter4j.UserStreamListener;

public class TwitterDataFetchScheduler {
    Twitter twitterForRead;
    final FilterService rootFilterService;
    final ClientConfiguration configuration;
    TwitterStream stream;
    ClientProperties configProperties;

    TwitterDataFetchScheduler(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.configProperties = configuration.getConfigProperties();
        this.twitterForRead = configuration.getTwitterForRead();
        this.rootFilterService = configuration.getRootFilterService();
        this.scheduleFirstTimeline();
        this.scheduleFirstMentions();
        this.scheduleFirstDirectMessage();
        this.scheduleGettingTimeline();
        this.onChangeAccount(true);
        this.onChangeAccount(false);
    }

    public void cleanUp() {
        this.stream.shutdown();
    }

    public void onChangeAccount(boolean forWrite) {
        if (forWrite) {
            this.reloginForWrite(this.configuration.getAccountIdForWrite());
        } else {
            this.reloginForRead(this.configuration.getAccountIdForRead());
        }
    }

    private void reloginForRead(String accountId) {
        this.twitterForRead = this.configuration.getTwitterForRead();
        if (this.stream != null) {
            final TwitterStream oldStream = this.stream;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    oldStream.cleanUp();
                }
            }, "stream disconnector").start();
        }
        this.stream = new TwitterStreamFactory(this.configuration.getTwitterConfiguration(accountId)).getInstance();
        this.stream.addConnectionLifeCycleListener((ConnectionLifeCycleListener)this.rootFilterService);
        this.stream.addListener((UserStreamListener)this.rootFilterService);
        this.stream.user();
    }

    private void reloginForWrite(String accountId) {
    }

    private void scheduleFirstDirectMessage() {
        this.configuration.addJob(new FirstDirectMessageFetcher());
    }

    private void scheduleFirstMentions() {
        this.configuration.addJob(new FirstMentionFetcher());
    }

    private void scheduleFirstTimeline() {
        this.configuration.addJob(new FirstTimelineFetcher());
    }

    private void scheduleGettingTimeline() {
        this.configuration.getTimer().schedule(new TimerTask(){

            @Override
            public void run() {
                TwitterDataFetchScheduler.this.configuration.addJob(new HomeTimelineFetcher());
            }
        }, this.configProperties.getInteger("twitter.interval.timeline"), (long)this.configProperties.getInteger("twitter.interval.timeline"));
    }

    private final class HomeTimelineFetcher
    extends TwitterRunnable
    implements ParallelRunnable {
        private HomeTimelineFetcher() {
        }

        @Override
        protected void access() throws TwitterException {
            Paging paging = new Paging().count(TwitterDataFetchScheduler.this.configProperties.getInteger("twitter.page.timeline"));
            ResponseList timeline = TwitterDataFetchScheduler.this.twitterForRead.getHomeTimeline(paging);
            for (Status status : timeline) {
                TwitterDataFetchScheduler.this.rootFilterService.onStatus(status);
            }
        }

        @Override
        protected ClientConfiguration getConfiguration() {
            return TwitterDataFetchScheduler.this.configuration;
        }
    }

    private final class FirstTimelineFetcher
    extends TwitterRunnable {
        private FirstTimelineFetcher() {
        }

        @Override
        protected void access() throws TwitterException {
            Paging paging = new Paging().count(TwitterDataFetchScheduler.this.configProperties.getInteger("twitter.page.initial_timeline"));
            ResponseList homeTimeline = TwitterDataFetchScheduler.this.twitterForRead.getHomeTimeline(paging);
            for (Status status : homeTimeline) {
                TwitterStatus twitterStatus = new TwitterStatus(TwitterDataFetchScheduler.this.configuration, status);
                twitterStatus.setLoadedInitialization(true);
                TwitterDataFetchScheduler.this.rootFilterService.onStatus(twitterStatus);
            }
        }

        @Override
        protected ClientConfiguration getConfiguration() {
            return TwitterDataFetchScheduler.this.configuration;
        }
    }

    private final class FirstMentionFetcher
    extends TwitterRunnable
    implements ParallelRunnable {
        private FirstMentionFetcher() {
        }

        @Override
        public void access() throws TwitterException {
            Paging paging = new Paging().count(TwitterDataFetchScheduler.this.configProperties.getInteger("twitter.page.initial_mention"));
            ResponseList mentions = TwitterDataFetchScheduler.this.twitterForRead.getMentionsTimeline(paging);
            for (Status status : mentions) {
                TwitterStatus twitterStatus = new TwitterStatus(TwitterDataFetchScheduler.this.configuration, status);
                twitterStatus.setLoadedInitialization(true);
                TwitterDataFetchScheduler.this.rootFilterService.onStatus(twitterStatus);
            }
        }

        @Override
        protected ClientConfiguration getConfiguration() {
            return TwitterDataFetchScheduler.this.configuration;
        }
    }

    private final class FirstDirectMessageFetcher
    extends TwitterRunnable
    implements ParallelRunnable {
        private FirstDirectMessageFetcher() {
        }

        @Override
        protected void access() throws TwitterException {
            Paging paging = new Paging().count(TwitterDataFetchScheduler.this.configProperties.getInteger("twitter.page.initial_dm"));
            ResponseList directMessages = TwitterDataFetchScheduler.this.twitterForRead.getDirectMessages(paging);
            for (DirectMessage directMessage : directMessages) {
                TwitterDataFetchScheduler.this.rootFilterService.onDirectMessage(new InitialMessage(directMessage));
            }
        }

        @Override
        protected ClientConfiguration getConfiguration() {
            return TwitterDataFetchScheduler.this.configuration;
        }
    }
}

