/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jp.syuriken.snsw.twclient.AnimationCanceledImageObserver;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.JobQueue;
import jp.syuriken.snsw.twclient.ParallelRunnable;
import jp.syuriken.snsw.twclient.Utility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import twitter4j.User;

public class ImageCacher {
    private static final int BUFSIZE = 65536;
    private final ClientConfiguration configuration;
    public final File CACHE_DIR;
    public final File USER_ICON_CACHE_DIR;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    ConcurrentHashMap<String, ImageEntry> cacheManager = new ConcurrentHashMap();
    private long cacheExpire;
    private int flushThreshold;
    private int flushResetInterval;

    public ImageCacher(ClientConfiguration configuration) {
        this.configuration = configuration;
        this.cacheExpire = configuration.getConfigProperties().getLong("core.cache.icon.survive_time");
        this.flushThreshold = configuration.getConfigProperties().getInteger("core.cache.icon.flush_threshold");
        this.flushResetInterval = configuration.getConfigProperties().getInteger("core.cache.icon.flush_reset_interval");
        switch (Utility.getOstype()) {
            case WINDOWS: {
                this.CACHE_DIR = new File(System.getProperty("java.io.tmpdir") + "/elnetw/cache");
                break;
            }
            default: {
                this.CACHE_DIR = new File(System.getProperty("user.home") + "/.cache/elnetw");
            }
        }
        this.USER_ICON_CACHE_DIR = new File(this.CACHE_DIR, "user");
        this.loadUserIconFromCaches(this.USER_ICON_CACHE_DIR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fetchImage(ImageEntry entry) {
        URL url = entry.url;
        if (this.cacheManager.containsKey(entry.imageKey)) {
            return;
        }
        ImageEntry imageEntry = entry;
        synchronized (imageEntry) {
            try {
                Image image;
                int loadlen;
                InputStream stream = url.openStream();
                byte[] buf = new byte[65536];
                byte[] imagedata = new byte[]{};
                int imagelen = 0;
                while ((loadlen = stream.read(buf)) != -1) {
                    byte[] oldimage = imagedata;
                    imagedata = new byte[imagelen + loadlen];
                    System.arraycopy(oldimage, 0, imagedata, 0, imagelen);
                    System.arraycopy(buf, 0, imagedata, imagelen, loadlen);
                    imagelen += loadlen;
                }
                entry.rawimage = imagedata;
                entry.image = image = Toolkit.getDefaultToolkit().createImage(imagedata);
                this.cacheManager.put(entry.imageKey, entry);
            }
            catch (IOException e) {
                this.logger.warn(MessageFormat.format("Error while fetching: {0}", url), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean flushImage(ImageEntry entry) {
        ImageEntry imageEntry = entry;
        synchronized (imageEntry) {
            if (!entry.isWritten) {
                if (entry.cacheFile == null) {
                    return false;
                }
                FileOutputStream outputStream = null;
                try {
                    File file = entry.cacheFile;
                    File dirName = file.getParentFile();
                    if (!dirName.exists() && !dirName.mkdirs()) {
                        this.logger.warn("{} is not exist and can't mkdir", (Object)Utility.protectPrivacy(dirName.getPath()));
                    }
                    outputStream = new FileOutputStream(file);
                    outputStream.write(entry.rawimage);
                    entry.isWritten = true;
                    this.logger.debug("Flushed: {}", (Object)Utility.protectPrivacy(entry.cacheFile.getPath()));
                }
                catch (IOException e) {
                    StringBuilder stringBuilder = new StringBuilder("Failed flushing cache: ");
                    stringBuilder.append(Utility.protectPrivacy(entry.cacheFile.getPath()));
                    this.logger.warn(stringBuilder.toString(), (Throwable)e);
                    boolean bl = false;
                    return bl;
                }
                finally {
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException e3) {
                        StringBuilder stringBuilder = new StringBuilder("Failed close file: ");
                        stringBuilder.append(Utility.protectPrivacy(entry.cacheFile.getPath()));
                        this.logger.warn(stringBuilder.toString(), (Throwable)e3);
                    }
                }
            }
            return true;
        }
    }

    public File getImageFile(URL url) {
        return null;
    }

    public File getImageFile(User user) {
        String imageKey = this.getImageKey(user);
        ImageEntry entry = this.cacheManager.get(imageKey);
        if (entry == null) {
            try {
                entry = new ImageEntry(new URL(user.getProfileImageURL()), imageKey);
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            entry.cacheFile = this.getImageFilename(user);
            this.fetchImage(entry);
        }
        if (!entry.isWritten) {
            this.flushImage(entry);
        }
        return entry.cacheFile;
    }

    protected File getImageFilename(User user) {
        String fileName = this.getProfileImageName(user);
        long id = user.getId();
        String subdir = Integer.toHexString((int)(id & 0xFFL));
        return new File(this.USER_ICON_CACHE_DIR, MessageFormat.format("{0}/{1}-{2}", subdir, Long.toString(id), fileName));
    }

    protected Icon getImageIcon(Image image) {
        ImageIcon imageIcon = new ImageIcon(image);
        imageIcon.setImageObserver(AnimationCanceledImageObserver.SINGLETON);
        return imageIcon;
    }

    protected String getImageKey(String userId, String profileImageName) {
        return "user://" + userId + "/" + profileImageName;
    }

    protected String getImageKey(User user) {
        return this.getImageKey(String.valueOf(user.getId()), this.getProfileImageName(user));
    }

    protected String getProfileImageName(User user) {
        String url = user.getProfileImageURL();
        String fileName = url.substring(url.lastIndexOf(47) + 1);
        return fileName;
    }

    private void incrementAppearCount(ImageEntry entry) {
        int appearCount;
        if (entry.isWritten) {
            return;
        }
        if (entry.countEndTime < System.currentTimeMillis()) {
            entry.countEndTime = System.currentTimeMillis() + (long)this.flushResetInterval;
            entry.appearCount = 0;
        }
        if ((appearCount = ++entry.appearCount) > this.flushThreshold) {
            this.configuration.addJob(JobQueue.Priority.LOW, new ImageFlusher(entry));
        }
    }

    private void loadUserIconFromCaches(File directory) {
        File[] listFiles = directory.listFiles();
        if (listFiles == null) {
            return;
        }
        for (File file : listFiles) {
            ImageEntry imageEntry;
            String name;
            int separatorPosition;
            long lastModified;
            if (file.isDirectory()) {
                this.loadUserIconFromCaches(file);
            }
            if ((lastModified = file.lastModified()) == 0L) continue;
            if (lastModified + this.cacheExpire < System.currentTimeMillis()) {
                if (file.delete()) {
                    this.logger.debug("clean expired cache: {} (lastModified:{})", (Object)Utility.protectPrivacy(file.getPath()), (Object)lastModified);
                    continue;
                }
                this.logger.warn("Failed cleaning cache: {}", (Object)Utility.protectPrivacy(file.getPath()));
            }
            if ((separatorPosition = (name = file.getName()).indexOf(45)) == -1) continue;
            String userId = name.substring(0, separatorPosition);
            String fileName = name.substring(separatorPosition + 1, name.length());
            this.logger.debug("loadCache: file={}", (Object)name);
            try {
                imageEntry = new ImageEntry(file.toURI().toURL(), this.getImageKey(userId, fileName));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            this.configuration.addJob(new ImageFetcher(imageEntry, null));
        }
    }

    public boolean setImageIcon(JLabel label, URL url) {
        String urlString = url.toString();
        ImageEntry entry = this.cacheManager.get(urlString);
        if (entry == null) {
            this.configuration.addJob(new ImageFetcher(new ImageEntry(url, urlString), label));
            return false;
        }
        label.setIcon(this.getImageIcon(entry.image));
        this.incrementAppearCount(entry);
        return true;
    }

    public boolean setImageIcon(JLabel label, User user) {
        String imageKey = this.getImageKey(user);
        String url = user.getProfileImageURL();
        ImageEntry entry = this.cacheManager.get(imageKey);
        if (entry == null) {
            try {
                entry = new ImageEntry(new URL(url), imageKey);
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            entry.cacheFile = this.getImageFilename(user);
            this.configuration.addJob(new ImageFetcher(entry, label));
            return false;
        }
        label.setIcon(this.getImageIcon(entry.image));
        this.incrementAppearCount(entry);
        return true;
    }

    protected class ImageFlusher
    implements ParallelRunnable {
        private ImageEntry entry;

        public ImageFlusher(ImageEntry entry) {
            this.entry = entry;
        }

        @Override
        public void run() {
            ImageCacher.this.flushImage(this.entry);
        }
    }

    protected class ImageFetcher
    implements ParallelRunnable {
        public final ImageEntry entry;
        public final JLabel label;

        public ImageFetcher(ImageEntry entry, JLabel label) {
            this.entry = entry;
            this.label = label;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ImageEntry entry = this.entry;
            if (ImageCacher.this.cacheManager.containsKey(entry.imageKey)) {
                ImageEntry imageEntry = entry;
                synchronized (imageEntry) {
                    this.label.setIcon(ImageCacher.this.getImageIcon(ImageCacher.this.cacheManager.get((Object)entry.imageKey).image));
                    ImageCacher.this.incrementAppearCount(entry);
                }
                return;
            }
            ImageCacher.this.fetchImage(entry);
            if (this.label != null) {
                this.label.setIcon(ImageCacher.this.getImageIcon(entry.image));
                ImageCacher.this.incrementAppearCount(entry);
            }
        }
    }

    protected static class ImageEntry {
        public final URL url;
        public final String imageKey;
        public Image image;
        public File cacheFile;
        public byte[] rawimage;
        protected volatile boolean isWritten = false;
        public volatile int appearCount;
        public volatile long countEndTime;

        public ImageEntry(URL url) {
            this.url = url;
            this.imageKey = url.toString();
        }

        public ImageEntry(URL url, String imageKey) {
            this.url = url;
            this.imageKey = imageKey;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("ImageEntry{imageKey=").append(this.imageKey).append(",url=").append(this.url.toString()).append(",cacheFile=").append(this.cacheFile == null ? "null" : this.cacheFile.getPath()).append(",rawimage=byte[").append(this.rawimage == null ? "null" : Integer.valueOf(this.rawimage.length)).append("],isWritten=").append(this.isWritten).append(",appearCount=").append(this.appearCount).append("}");
            return stringBuilder.toString();
        }
    }
}

