/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import com.twitter.Regex;
import java.awt.Color;
import java.awt.event.FocusEvent;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import javax.swing.Icon;
import javax.swing.JLabel;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import jp.syuriken.snsw.twclient.DefaultClientTab;
import jp.syuriken.snsw.twclient.StatusData;
import jp.syuriken.snsw.twclient.StatusPanel;
import jp.syuriken.snsw.twclient.TwitterClientFrame;
import jp.syuriken.snsw.twclient.Utility;
import jp.syuriken.snsw.twclient.filter.IllegalSyntaxException;
import twitter4j.DirectMessage;
import twitter4j.Status;
import twitter4j.User;
import twitter4j.internal.org.json.JSONException;
import twitter4j.internal.org.json.JSONObject;

public class DirectMessageViewTab
extends DefaultClientTab {
    private static final String TAB_ID = "directmessage";
    private DefaultClientTab.DefaultRenderer renderer = new DefaultClientTab.DefaultRenderer(){

        @Override
        public void onDirectMessage(DirectMessage directMessage) {
            JLabel statusText;
            String screenName;
            StatusData statusData = new StatusData(directMessage, directMessage.getCreatedAt());
            if (DirectMessageViewTab.this.configProperties.getBoolean("core.id_strict_match")) {
                if (directMessage.getSenderId() == DirectMessageViewTab.this.frameApi.getLoginUser().getId()) {
                    statusData.foregroundColor = Color.BLUE;
                }
            } else if (directMessage.getSenderScreenName().startsWith(DirectMessageViewTab.this.frameApi.getLoginUser().getScreenName())) {
                statusData.foregroundColor = Color.BLUE;
            }
            User user = directMessage.getSender();
            JLabel icon = new JLabel();
            DirectMessageViewTab.this.imageCacher.setImageIcon(icon, user);
            icon.setHorizontalAlignment(0);
            statusData.image = icon;
            statusData.user = screenName = user.getScreenName();
            if (screenName.length() > 11) {
                screenName = screenName.substring(0, 9) + "..";
            }
            JLabel sentBy = new JLabel(screenName);
            sentBy.setFont(TwitterClientFrame.DEFAULT_FONT);
            statusData.sentBy = sentBy;
            statusData.data = statusText = new JLabel("(to @" + directMessage.getRecipientScreenName() + ") " + directMessage.getText());
            statusData.popupMenu = DirectMessageViewTab.this.tweetPopupMenu;
            DirectMessageViewTab.this.addStatus(statusData);
        }

        @Override
        public void onStatus(Status originalStatus) {
        }
    };
    private boolean focusGained;
    private boolean isDirty;

    private static void nl2br(StringBuffer stringBuffer) {
        int position;
        int start;
        int offset = start = stringBuffer.length();
        while ((position = stringBuffer.indexOf("\n", offset)) >= 0) {
            stringBuffer.replace(position, position + 1, "<br>");
            offset = position + 1;
        }
        offset = start;
        while ((position = stringBuffer.indexOf(" ", offset)) >= 0) {
            stringBuffer.replace(position, position + 1, "&nbsp;");
            offset = position + 1;
        }
        offset = start;
        while ((position = stringBuffer.indexOf("&amp;", offset)) >= 0) {
            stringBuffer.replace(position, position + 5, "&amp;amp;");
            offset = position + 9;
        }
    }

    public DirectMessageViewTab(ClientConfiguration configuration) throws IllegalSyntaxException {
        super(configuration);
    }

    public DirectMessageViewTab(ClientConfiguration configuration, String data) throws JSONException, IllegalSyntaxException {
        super(configuration, data);
    }

    @Override
    public StatusPanel addStatus(StatusData statusData) {
        if (!this.focusGained && !this.isDirty) {
            this.isDirty = true;
            this.configuration.refreshTab(this);
        }
        return super.addStatus(statusData);
    }

    @Override
    public void focusGained() {
        this.focusGained = true;
        this.isDirty = false;
        this.configuration.refreshTab(this);
    }

    @Override
    protected void focusGainOfLinePanel(FocusEvent e) throws IllegalArgumentException, NumberFormatException {
        if (this.selectingPost != null) {
            this.selectingPost.setBackground(this.selectingPost.getStatusData().backgroundColor);
        }
        this.selectingPost = (StatusPanel)e.getComponent();
        this.selectingPost.setBackground(Utility.blendColor(this.selectingPost.getStatusData().backgroundColor, this.configProperties.getColor("gui.color.list.focus")));
        StatusData statusData = this.selectingPost.getStatusData();
        if (statusData.tag instanceof DirectMessage) {
            DirectMessage directMessage = (DirectMessage)statusData.tag;
            String text = directMessage.getText();
            StringBuffer oldBuffer = new StringBuffer();
            StringBuffer newBuffer = new StringBuffer(text.length());
            Matcher urlMatcher = Regex.VALID_URL.matcher(text);
            while (urlMatcher.find()) {
                urlMatcher.appendReplacement(newBuffer, "$2<a href='$3'>$3</a>");
            }
            urlMatcher.appendTail(newBuffer);
            StringBuffer tempBuffer = oldBuffer;
            oldBuffer = newBuffer;
            newBuffer = tempBuffer;
            newBuffer.setLength(0);
            Matcher hashtagMatcher = Regex.AUTO_LINK_HASHTAGS.matcher(oldBuffer);
            while (hashtagMatcher.find()) {
                hashtagMatcher.appendReplacement(newBuffer, "$1<a href='http://command/hashtag!$3'>$2$3</a>");
            }
            hashtagMatcher.appendTail(newBuffer);
            tempBuffer = oldBuffer;
            oldBuffer = newBuffer;
            newBuffer = tempBuffer;
            newBuffer.setLength(0);
            Matcher userMatcher = Regex.AUTO_LINK_USERNAMES_OR_LISTS.matcher(oldBuffer);
            while (userMatcher.find()) {
                String list = userMatcher.group(4);
                if (list == null) {
                    userMatcher.appendReplacement(newBuffer, "$1<a href='http://command/userinfo!$3'>$2$3</a>");
                    continue;
                }
                userMatcher.appendReplacement(newBuffer, "$1<a href='http://command/list!$3$4'>$2$3$4</a>");
            }
            userMatcher.appendTail(newBuffer);
            DirectMessageViewTab.nl2br(newBuffer);
            String tweetText = newBuffer.toString();
            String createdBy = MessageFormat.format("@{0} ({1}) -> @{2} ({3})", directMessage.getSender().getScreenName(), directMessage.getSender().getName(), directMessage.getRecipient().getScreenName(), directMessage.getRecipient().getName());
            String createdAt = Utility.getDateString(directMessage.getCreatedAt(), true);
            this.frameApi.clearTweetView();
            this.frameApi.setTweetViewText(tweetText, null, 0);
            this.frameApi.setTweetViewCreatedAt(createdAt, null, 0);
            this.frameApi.setTweetViewCreatedBy(((JLabel)statusData.image).getIcon(), createdBy, null, 0);
        }
    }

    @Override
    public void focusLost() {
        this.focusGained = false;
    }

    @Override
    public DefaultClientTab.DefaultRenderer getActualRenderer() {
        return this.renderer;
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    protected Object getSerializedExtendedData() {
        return JSONObject.NULL;
    }

    @Override
    public String getTabId() {
        return TAB_ID;
    }

    @Override
    public String getTitle() {
        return this.isDirty ? "DM*" : "DM";
    }

    @Override
    public String getToolTip() {
        return "DirectMessages";
    }
}

