/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import jp.syuriken.snsw.twclient.ClientConfiguration;
import net.iharder.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientProperties
extends Properties {
    private static final long serialVersionUID = 7476401456972225006L;
    private static final Logger logger = LoggerFactory.getLogger(ClientProperties.class);
    private static final int KEY_BIT = 128;
    private static final String ENCRYPT_HEADER = "$priv$0$";
    private static final String ENCRYPT_FOOTER = "$";
    protected transient ArrayList<PropertyChangeListener> listeners = new ArrayList();
    protected File storeFile;
    private transient Hashtable<String, Object> cacheTable = new Hashtable();

    private static byte[] decrypt(byte[] src, Key decryptKey) throws InvalidKeyException {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            int ivLength = (src[0] & 0xFF) + (src[1] << 8 & 0xFF00);
            byte[] iv = Arrays.copyOfRange(src, 2, 2 + ivLength);
            byte[] dat = Arrays.copyOfRange(src, 2 + ivLength, src.length);
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("AES");
            algorithmParameters.init(iv);
            cipher.init(2, decryptKey, algorithmParameters);
            return cipher.doFinal(dat);
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException("passphrase seems to be illegal", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] encrypt(byte[] src, Key encryptKey) throws InvalidKeyException {
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, encryptKey);
            byte[] iv = cipher.getParameters().getEncoded();
            byte[] enc = cipher.doFinal(src);
            byte[] ret = new byte[2 + iv.length + enc.length];
            ret[0] = (byte)(iv.length & 0xFF);
            ret[1] = (byte)(iv.length >> 8 & 0xFF);
            System.arraycopy(iv, 0, ret, 2, iv.length);
            System.arraycopy(enc, 0, ret, 2 + iv.length, enc.length);
            return ret;
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Key makeKey(String passphrase) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        messageDigest.update(passphrase.getBytes(ClientConfiguration.UTF8_CHARSET));
        byte[] digest = messageDigest.digest();
        byte[] keyBytes = Arrays.copyOf(digest, 16);
        return new SecretKeySpec(keyBytes, "AES");
    }

    public ClientProperties() {
        this((Properties)null);
    }

    public ClientProperties(Properties defaults) {
        super(defaults);
    }

    public synchronized void addPropertyChangedListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener\u306fnull\u3067\u3042\u3063\u3066\u306f\u3044\u3051\u307e\u305b\u3093\u3002");
        }
        this.listeners.add(listener);
    }

    protected synchronized void cacheValue(String key, Object value) {
        this.cacheTable.put(key, value);
    }

    protected synchronized Object clearCachedValue(String key) {
        return this.cacheTable.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean equals(Object o) {
        ClientProperties c;
        if (!(o instanceof ClientProperties)) {
            if (o instanceof Properties && this.listeners == null && this.storeFile == null) {
                return super.equals(o);
            }
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientProperties clientProperties = c = (ClientProperties)o;
        synchronized (clientProperties) {
            if (!this.listeners.equals(c.listeners)) {
                return false;
            }
            if (!this.storeFile.equals(c.storeFile)) {
                return false;
            }
        }
        return true;
    }

    public synchronized void firePropetyChanged(String key, String oldValue, String newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, key, oldValue, newValue);
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(evt);
        }
    }

    public synchronized String[] getArray(String key) {
        String accountListString = this.getProperty(key, "").trim();
        if (accountListString.isEmpty()) {
            return new String[0];
        }
        return accountListString.split(" ");
    }

    public synchronized boolean getBoolean(String key) {
        Boolean boolean1 = this.getCachedValue(key, Boolean.class);
        if (boolean1 != null) {
            return boolean1;
        }
        String value = this.getProperty(key);
        boolean1 = Boolean.parseBoolean(value);
        this.cacheValue(key, boolean1);
        return boolean1;
    }

    protected synchronized <T> T getCachedValue(String key, Class<T> expectedClass) {
        Object cachedValue = this.cacheTable.get(key);
        if (cachedValue == null || !expectedClass.isInstance(cachedValue)) {
            return null;
        }
        return (T)cachedValue;
    }

    public synchronized Color getColor(String key) throws IllegalArgumentException, NumberFormatException {
        Color color = this.getCachedValue(key, Color.class);
        if (color != null) {
            return color;
        }
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        String[] rgba = value.split(",");
        if (rgba.length == 4) {
            color = new Color(Integer.parseInt(rgba[0]), Integer.parseInt(rgba[1]), Integer.parseInt(rgba[2]), Integer.parseInt(rgba[3]));
        } else if (rgba.length == 3) {
            color = new Color(Integer.parseInt(rgba[0]), Integer.parseInt(rgba[1]), Integer.parseInt(rgba[2]));
        } else {
            throw new IllegalArgumentException(MessageFormat.format("{0}\u306fColor\u306b\u4f7f\u7528\u3067\u304d\u308b\u5024\u3067\u306f\u3042\u308a\u307e\u305b\u3093: {1}", key, value));
        }
        this.cacheValue(key, color);
        return color;
    }

    public synchronized Dimension getDimension(String key) throws IllegalArgumentException {
        Dimension dimension = this.getCachedValue(key, Dimension.class);
        if (dimension != null) {
            return dimension;
        }
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        String[] rgba = value.split(",");
        if (rgba.length != 2) {
            throw new IllegalArgumentException(MessageFormat.format("{0}\u306fDimension\u306b\u4f7f\u7528\u3067\u304d\u308b\u5024\u3067\u306f\u3042\u308a\u307e\u305b\u3093: {1}", key, value));
        }
        dimension = new Dimension(Integer.parseInt(rgba[0]), Integer.parseInt(rgba[1]));
        this.cacheValue(key, dimension);
        return dimension;
    }

    public synchronized double getDouble(String key) {
        Double double1 = this.getCachedValue(key, Double.class);
        if (double1 != null) {
            return double1;
        }
        String value = this.getProperty(key);
        double1 = Double.valueOf(value);
        this.cacheValue(key, double1);
        return double1;
    }

    public synchronized float getFloat(String key) {
        Float float1 = this.getCachedValue(key, Float.class);
        if (float1 != null) {
            return float1.floatValue();
        }
        String value = this.getProperty(key);
        float1 = Float.valueOf(value);
        this.cacheValue(key, float1);
        return float1.floatValue();
    }

    public synchronized int getInteger(String key) {
        Integer integer = this.getCachedValue(key, Integer.class);
        if (integer != null) {
            return integer;
        }
        String value = this.getProperty(key);
        integer = Integer.valueOf(value);
        this.cacheValue(key, integer);
        return integer;
    }

    public synchronized long getLong(String key) {
        Long long1 = this.getCachedValue(key, Long.class);
        if (long1 != null) {
            return long1;
        }
        String value = this.getProperty(key);
        long1 = Long.valueOf(value);
        this.cacheValue(key, long1);
        return long1;
    }

    public synchronized String getPrivateString(String key, String defaultValue, String passphrase) throws InvalidKeyException, RuntimeException {
        String value = this.getPrivateString(key, passphrase);
        return value == null ? defaultValue : value;
    }

    public synchronized String getPrivateString(String key, String defaultValue, Key decryptKey) throws InvalidKeyException {
        String value = this.getPrivateString(key, decryptKey);
        return value == null ? defaultValue : value;
    }

    public synchronized String getPrivateString(String key, Key decryptKey) throws InvalidKeyException {
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        if (value.startsWith(ENCRYPT_HEADER) && value.endsWith(ENCRYPT_FOOTER)) {
            value = value.substring(ENCRYPT_HEADER.length(), value.length() - ENCRYPT_FOOTER.length());
            try {
                byte[] decrypted = ClientProperties.decrypt(Base64.decode((String)value), decryptKey);
                return new String(decrypted, ClientConfiguration.UTF8_CHARSET);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return value;
    }

    public synchronized String getPrivateString(String key, String passphrase) throws InvalidKeyException {
        String value = this.getProperty(key);
        if (value == null) {
            return null;
        }
        if (value.startsWith(ENCRYPT_HEADER) && value.endsWith(ENCRYPT_FOOTER)) {
            value = value.substring(ENCRYPT_HEADER.length(), value.length() - ENCRYPT_FOOTER.length());
            Key decryptKey = ClientProperties.makeKey(passphrase);
            try {
                byte[] decrypted = ClientProperties.decrypt(Base64.decode((String)value), decryptKey);
                return new String(decrypted, ClientConfiguration.UTF8_CHARSET);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return value;
    }

    @Override
    public synchronized int hashCode() {
        int hashCode = super.hashCode();
        hashCode += 19 * this.listeners.hashCode();
        return hashCode += 19 * this.storeFile.hashCode();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.listeners = new ArrayList();
        this.cacheTable = new Hashtable();
    }

    @Override
    public synchronized Object remove(Object key) {
        this.firePropetyChanged((String)key, this.getProperty((String)key), null);
        return super.remove(key);
    }

    public synchronized boolean removePropertyChangedListener(PropertyChangeListener listener) {
        return this.listeners.remove(listener);
    }

    public synchronized void setBoolean(String key, boolean value) {
        this.clearCachedValue(key);
        this.setProperty(key, String.valueOf(value));
    }

    public synchronized void setColor(String key, Color color) {
        this.clearCachedValue(key);
        this.setProperty(key, MessageFormat.format("{0},{1},{2},{3}", color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
    }

    public synchronized void setDimension(String key, Dimension dimension) {
        this.clearCachedValue(key);
        this.setProperty(key, dimension.width + "," + dimension.height);
    }

    public synchronized void setDouble(String key, double value) {
        this.clearCachedValue(key);
        this.setProperty(key, String.valueOf(value));
    }

    public synchronized void setFloat(String key, float value) {
        this.clearCachedValue(key);
        this.setProperty(key, String.valueOf(value));
    }

    public synchronized void setInteger(String key, int value) {
        this.clearCachedValue(key);
        this.setProperty(key, String.valueOf(value));
    }

    public synchronized void setLong(String key, long value) {
        this.clearCachedValue(key);
        this.setProperty(key, String.valueOf(value));
    }

    public synchronized void setPrivateString(String key, String value, String passphrase) throws InvalidKeyException {
        this.setPrivateString(key, value, ClientProperties.makeKey(passphrase));
    }

    public synchronized void setPrivateString(String key, String value, Key encryptKey) throws InvalidKeyException {
        byte[] bytes = value.getBytes(ClientConfiguration.UTF8_CHARSET);
        String encoded = Base64.encodeBytes((byte[])ClientProperties.encrypt(bytes, encryptKey));
        this.setProperty(key, ENCRYPT_HEADER + encoded + ENCRYPT_FOOTER);
    }

    @Override
    public synchronized Object setProperty(String key, String newValue) {
        String oldValue = this.getProperty(key);
        this.firePropetyChanged(key, oldValue, newValue);
        return super.setProperty(key, newValue);
    }

    public synchronized void setStoreFile(File storeFile) {
        this.storeFile = storeFile;
    }

    public void store() {
        this.store("Auto generated by jp.syuriken.snsw.twclient.ClientProperties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void store(String comments) {
        FileOutputStream stream = null;
        OutputStreamWriter writer = null;
        try {
            stream = new FileOutputStream(this.storeFile);
            writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            this.store(writer, comments);
        }
        catch (IOException e) {
            logger.warn("Properties\u30d5\u30a1\u30a4\u30eb\u306e\u4fdd\u5b58\u4e2d\u306b\u30a8\u30e9\u30fc", (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                    writer.close();
                }
                catch (IOException e) {
                    logger.warn("Properties\u30d5\u30a1\u30a4\u30eb\u306e\u30af\u30ed\u30fc\u30ba\u4e2d\u306b\u30a8\u30e9\u30fc", (Throwable)e);
                }
            } else if (stream != null) {
                try {
                    stream.flush();
                    stream.close();
                }
                catch (IOException e) {
                    logger.warn("Properties\u30d5\u30a1\u30a4\u30eb\u306e\u30af\u30ed\u30fc\u30ba\u4e2d\u306b\u30a8\u30e9\u30fc", (Throwable)e);
                }
            }
        }
    }
}

