/*
 * Decompiled with CFR 0.152.
 */
package jp.syuriken.snsw.twclient;

import java.awt.EventQueue;
import java.awt.TrayIcon;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Timer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jp.syuriken.snsw.twclient.ActionHandler;
import jp.syuriken.snsw.twclient.CacheManager;
import jp.syuriken.snsw.twclient.ClientFrameApi;
import jp.syuriken.snsw.twclient.ClientProperties;
import jp.syuriken.snsw.twclient.ClientTab;
import jp.syuriken.snsw.twclient.FilterService;
import jp.syuriken.snsw.twclient.ImageCacher;
import jp.syuriken.snsw.twclient.JobQueue;
import jp.syuriken.snsw.twclient.OAuthFrame;
import jp.syuriken.snsw.twclient.TwitterClientFrame;
import jp.syuriken.snsw.twclient.TwitterDataFetchScheduler;
import jp.syuriken.snsw.twclient.Utility;
import jp.syuriken.snsw.twclient.VersionInfo;
import jp.syuriken.snsw.twclient.config.ConfigFrameBuilder;
import jp.syuriken.snsw.twclient.filter.MessageFilter;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.UserMentionEntity;
import twitter4j.auth.AccessToken;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;

public class ClientConfiguration {
    public static final String PROPERTY_LIST_SCROLL = "gui.list.scroll";
    public static final String PROPERTY_COLOR_FOCUS_LIST = "gui.color.list.focus";
    public static final String PROPERTY_ID_STRICT_MATCH = "core.id_strict_match";
    public static final String PROPERTY_INFO_SURVIVE_TIME = "core.info.survive_time";
    public static final String PROPERTY_INTERVAL_POSTLIST_UPDATE = "gui.interval.list_update";
    public static final String PROPERTY_PAGING_INITIAL_DIRECTMESSAGE = "twitter.page.initial_dm";
    public static final String PROPERTY_ACCOUNT_LIST = "twitter.oauth.access_token.list";
    public static final String PROPERTY_PAGING_INITIAL_MENTION = "twitter.page.initial_mention";
    public static final String PROPERTY_INTERVAL_TIMELINE = "twitter.interval.timeline";
    public static final String PROPERTY_PAGING_TIMELINE = "twitter.page.timeline";
    public static final String PROPERTY_PAGING_INITIAL_TIMELINE = "twitter.page.initial_timeline";
    public static final String NEW_LINE = System.getProperty("line.separator");
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    public static final String APPLICATION_NAME = "elnetw";
    private static final String HOME_BASE_DIR = System.getProperty("user.home") + "/.elnetw";
    private static HashMap<String, Constructor<? extends ClientTab>> clientTabConstructorsMap = new HashMap();
    private final List<ClientTab> tabsList = new ArrayList<ClientTab>();
    private final Utility utility = new Utility(this);
    private final ReentrantReadWriteLock tabsListLock = new ReentrantReadWriteLock();
    private final transient JobQueue jobQueue = new JobQueue();
    private transient Hashtable<String, ActionHandler> actionHandlerTable = new Hashtable();
    ClientProperties configProperties;
    ClientProperties configDefaultProperties;
    ConcurrentHashMap<String, Twitter> cachedTwitterInstances = new ConcurrentHashMap();
    private TrayIcon trayIcon;
    private boolean isShutdownPhase = false;
    private TwitterClientFrame frameApi;
    private boolean isInitializing = true;
    private ConfigFrameBuilder configBuilder;
    private volatile FilterService rootFilterService;
    private volatile ImageCacher imageCacher;
    private volatile String accountIdForRead;
    private volatile String accountIdForWrite;
    private TwitterDataFetchScheduler fetchScheduler;
    private boolean portabledConfiguration;
    private volatile CacheManager cacheManager;
    private List<String> args;
    private transient Timer timer;
    private ClassLoader extraClassLoader;

    public static Constructor<? extends ClientTab> getClientTabConstructor(String id) {
        return clientTabConstructorsMap.get(id);
    }

    public static Constructor<? extends ClientTab> putClientTabConstructor(String id, Class<? extends ClientTab> class1) {
        try {
            return ClientConfiguration.putClientTabConstructor(id, class1.getConstructor(ClientConfiguration.class, String.class));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("\u6307\u5b9a\u3055\u308c\u305f\u30af\u30e9\u30b9\u306f\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf(ClientConfiguration, String)\u3092\u6301\u3061\u307e\u305b\u3093", e);
        }
    }

    public static Constructor<? extends ClientTab> putClientTabConstructor(String id, Constructor<? extends ClientTab> constructor) {
        Class<?>[] parameterTypes = constructor.getParameterTypes();
        if (parameterTypes.length == 2 && parameterTypes[0].isAssignableFrom(ClientConfiguration.class) && parameterTypes[1].isAssignableFrom(String.class)) {
            return clientTabConstructorsMap.put(id, constructor);
        }
        throw new IllegalArgumentException("ClientConfiguration#addClientTabConstructor: \u6e21\u3055\u308c\u305f\u30b3\u30f3\u30b9\u30c8\u30e9\u30af\u30bf\u306f\u6b63\u3057\u3044\u578b\u306e\u5f15\u6570\u3092\u6301\u3061\u307e\u305b\u3093");
    }

    protected ClientConfiguration() {
    }

    public ActionHandler addActionHandler(String name, ActionHandler handler) {
        return this.actionHandlerTable.put(name, handler);
    }

    public void addFilter(MessageFilter rootFilter) {
        this.getRootFilterService().addFilter(rootFilter);
    }

    public boolean addFrameTab(ClientTab tab) throws IllegalStateException {
        boolean result;
        this.ensureRunningInDispatcherThread();
        if (tab == null) {
            return false;
        }
        try {
            this.tabsListLock.writeLock().lock();
            result = this.tabsList.add(tab);
            this.frameApi.addTab(tab);
        }
        catch (RuntimeException e) {
            this.tabsList.remove(tab);
            throw e;
        }
        finally {
            this.tabsListLock.writeLock().unlock();
        }
        return result;
    }

    public void addJob(JobQueue.Priority priority, Runnable job) {
        this.jobQueue.addJob(priority, job);
    }

    public void addJob(Runnable job) {
        this.jobQueue.addJob(job);
    }

    private boolean checkValidAccountId(String accountId) {
        for (String account : this.getAccountList()) {
            if (!account.equals(accountId)) continue;
            return true;
        }
        return false;
    }

    private void ensureRunningInDispatcherThread() throws IllegalStateException {
        if (!this.isInitializing && !EventQueue.isDispatchThread()) {
            throw new IllegalStateException("Please run in EventDispatcherThread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void focusFrameTab(ClientTab tab) throws IllegalStateException {
        this.ensureRunningInDispatcherThread();
        try {
            this.tabsListLock.readLock().lock();
            int indexOf = this.tabsList.indexOf(tab);
            if (indexOf != -1) {
                this.frameApi.focusFrameTab(tab, indexOf);
            }
        }
        finally {
            this.tabsListLock.readLock().unlock();
        }
    }

    public String getAccountIdForRead() {
        return this.accountIdForRead;
    }

    public String getAccountIdForWrite() {
        return this.accountIdForWrite;
    }

    public String[] getAccountList() {
        return this.configProperties.getArray(PROPERTY_ACCOUNT_LIST);
    }

    public ActionHandler getActionHandler(String name) {
        int indexOf = name.indexOf(33);
        String commandName = indexOf < 0 ? name : name.substring(0, indexOf);
        ActionHandler actionHandler = this.actionHandlerTable.get(commandName);
        return actionHandler;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public ConfigFrameBuilder getConfigBuilder() {
        return this.configBuilder;
    }

    public ClientProperties getConfigDefaultProperties() {
        return this.configDefaultProperties;
    }

    public ClientProperties getConfigProperties() {
        return this.configProperties;
    }

    public String getConfigRootDir() {
        return this.portabledConfiguration ? "." : HOME_BASE_DIR;
    }

    private String[] getConsumerPair() {
        String[] consumerPair;
        try {
            consumerPair = this.configProperties.getPrivateString("twitter.oauth.consumer_pair", "X4b:mZ\"p4").split(":");
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        return consumerPair;
    }

    public String getDefaultAccountId() {
        String accountId = this.configProperties.getProperty("twitter.oauth.access_token.default");
        if (accountId == null || accountId.isEmpty()) {
            String[] accountList = this.getAccountList();
            accountId = accountList.length > 0 ? accountList[0] : null;
        }
        return accountId;
    }

    public ClassLoader getExtraClassLoader() {
        return this.extraClassLoader;
    }

    public TwitterDataFetchScheduler getFetchScheduler() {
        return this.fetchScheduler;
    }

    public ClientFrameApi getFrameApi() {
        return this.frameApi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientTab getFrameTab(int index) {
        ClientTab result = null;
        try {
            this.tabsListLock.readLock().lock();
            result = this.tabsList.get(index);
        }
        finally {
            this.tabsListLock.readLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFrameTabCount() {
        int size;
        try {
            this.tabsListLock.readLock().lock();
            size = this.tabsList.size();
        }
        finally {
            this.tabsListLock.readLock().unlock();
        }
        return size;
    }

    List<ClientTab> getFrameTabs() {
        return this.tabsList;
    }

    ReentrantReadWriteLock getFrameTabsLock() {
        return this.tabsListLock;
    }

    public ImageCacher getImageCacher() {
        return this.imageCacher;
    }

    public JobQueue getJobQueue() {
        return this.jobQueue;
    }

    public List<String> getOpts() {
        return Collections.unmodifiableList(this.args);
    }

    public FilterService getRootFilterService() {
        return this.rootFilterService;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public TrayIcon getTrayIcon() {
        return this.trayIcon;
    }

    public Twitter getTwitter(String accountId) {
        Twitter twitter2;
        Twitter twitter = this.cachedTwitterInstances.get(accountId);
        if (twitter == null && (twitter2 = this.cachedTwitterInstances.putIfAbsent(accountId, twitter = new TwitterFactory(this.getTwitterConfiguration(accountId)).getInstance())) != null) {
            return twitter2;
        }
        return twitter;
    }

    public Configuration getTwitterConfiguration() {
        return this.getTwitterConfiguration(this.getDefaultAccountId());
    }

    public Configuration getTwitterConfiguration(String accountId) {
        String[] accessToken;
        try {
            String accessTokenString = this.configProperties.getPrivateString("twitter.oauth.access_token." + accountId, "X4b:mZ\"p4");
            accessToken = accessTokenString.split(":");
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        return this.getTwitterConfigurationBuilder().setOAuthAccessToken(accessToken[0]).setOAuthAccessTokenSecret(accessToken[1]).setOAuthConsumerKey(accessToken[2]).setOAuthConsumerSecret(accessToken[3]).build();
    }

    public ConfigurationBuilder getTwitterConfigurationBuilder() {
        String[] consumerPair = this.getConsumerPair();
        String consumerKey = consumerPair[0];
        String consumerSecret = consumerPair[1];
        return new ConfigurationBuilder().setOAuthConsumerKey(consumerKey).setOAuthConsumerSecret(consumerSecret).setUserStreamRepliesAllEnabled(this.configProperties.getBoolean("twitter.stream.replies_all")).setJSONStoreEnabled(true).setClientVersion(VersionInfo.getUniqueVersion()).setClientURL(VersionInfo.getSupportUrl());
    }

    public Twitter getTwitterForRead() {
        return this.getTwitter(this.getAccountIdForRead());
    }

    public Twitter getTwitterForWrite() {
        return this.getTwitter(this.getAccountIdForWrite());
    }

    public Utility getUtility() {
        return this.utility;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFocusTab(ClientTab tab) throws IllegalStateException {
        boolean result;
        this.ensureRunningInDispatcherThread();
        try {
            this.tabsListLock.readLock().lock();
            int indexOf = this.tabsList.indexOf(tab);
            result = this.frameApi.isFocusTab(indexOf);
        }
        finally {
            this.tabsListLock.readLock().unlock();
        }
        return result;
    }

    public boolean isInitializing() {
        return this.isInitializing;
    }

    public boolean isMentioned(UserMentionEntity[] userMentionEntities) {
        if (userMentionEntities == null) {
            return false;
        }
        for (UserMentionEntity userMentionEntity : userMentionEntities) {
            if (!(this.configProperties.getBoolean(PROPERTY_ID_STRICT_MATCH) ? userMentionEntity.getId() == this.frameApi.getLoginUser().getId() : userMentionEntity.getScreenName().startsWith(this.frameApi.getLoginUser().getScreenName()))) continue;
            return true;
        }
        return false;
    }

    public boolean isMyAccount(long id) {
        return this.isMyAccount(String.valueOf(id));
    }

    public boolean isMyAccount(String accountId) {
        String[] accountList;
        for (String account : accountList = this.getAccountList()) {
            if (!accountId.equals(account)) continue;
            return true;
        }
        return false;
    }

    public boolean isShutdownPhase() {
        return this.isShutdownPhase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTab(ClientTab tab) throws IllegalStateException {
        this.ensureRunningInDispatcherThread();
        try {
            this.tabsListLock.readLock().lock();
            int indexOf = this.tabsList.indexOf(tab);
            if (indexOf >= 0) {
                this.frameApi.refreshTab(indexOf, tab);
            }
        }
        finally {
            this.tabsListLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeFrameTab(ClientTab tab) throws IllegalStateException {
        int indexOf;
        this.ensureRunningInDispatcherThread();
        try {
            this.tabsListLock.writeLock().lock();
            indexOf = this.tabsList.indexOf(tab);
            if (indexOf != -1) {
                this.tabsList.remove(indexOf);
                this.frameApi.removeFrameTab(indexOf, tab);
            }
        }
        finally {
            this.tabsListLock.writeLock().unlock();
        }
        return indexOf != -1;
    }

    public String setAccountIdForRead(String accountId) {
        if (!this.checkValidAccountId(accountId)) {
            throw new IllegalArgumentException("accountId is not in user's accounts: " + accountId);
        }
        String old = this.accountIdForRead;
        if (old == null || !old.equals(accountId)) {
            this.accountIdForRead = accountId;
            if (this.rootFilterService != null) {
                this.rootFilterService.onChangeAccount(false);
            }
        }
        return old;
    }

    public String setAccountIdForWrite(String accountId) {
        if (!this.checkValidAccountId(accountId)) {
            throw new IllegalArgumentException("accountId is not in user's accounts: " + accountId);
        }
        String old = this.accountIdForWrite;
        if (old == null || !old.equals(accountId)) {
            this.accountIdForWrite = accountId;
            if (this.rootFilterService != null) {
                this.rootFilterService.onChangeAccount(true);
            }
        }
        return old;
    }

    void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    void setConfigBuilder(ConfigFrameBuilder configBuilder) {
        this.configBuilder = configBuilder;
    }

    public void setConfigDefaultProperties(ClientProperties configDefaultProperties) {
        this.configDefaultProperties = configDefaultProperties;
    }

    public void setConfigProperties(ClientProperties configProperties) {
        this.configProperties = configProperties;
    }

    void setExtraClassLoader(ClassLoader extraClassLoader) {
        this.extraClassLoader = extraClassLoader;
    }

    void setFetchScheduler(TwitterDataFetchScheduler fetchScheduler) {
        this.fetchScheduler = fetchScheduler;
    }

    void setFrameApi(TwitterClientFrame frameApi) {
        this.frameApi = frameApi;
    }

    void setImageCacher(ImageCacher imageCacher) {
        this.imageCacher = imageCacher;
    }

    void setInitializing(boolean isInitializing) {
        this.isInitializing = isInitializing;
    }

    void setOpts(String[] args) {
        this.args = Arrays.asList(args);
    }

    void setPortabledConfiguration(boolean portable) {
        this.portabledConfiguration = portable;
    }

    void setRootFilterService(FilterService service) {
        this.rootFilterService = service;
    }

    public void setShutdownPhase(boolean isShutdownPhase) {
        this.isShutdownPhase = isShutdownPhase;
    }

    void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void setTrayIcon(TrayIcon trayIcon) {
        this.trayIcon = trayIcon;
    }

    public void storeAccessToken(AccessToken accessToken) {
        String[] consumerKeys = this.getConsumerPair();
        StringBuilder stringBuilder = new StringBuilder().append(accessToken.getToken()).append(':').append(accessToken.getTokenSecret()).append(':').append(consumerKeys[0]).append(':').append(consumerKeys[1]);
        try {
            this.configProperties.setPrivateString("twitter.oauth.access_token." + accessToken.getUserId(), stringBuilder.toString(), "X4b:mZ\"p4");
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception tryGetOAuthToken() {
        String userId;
        Twitter twitter;
        try {
            twitter = new OAuthFrame(this).show();
        }
        catch (TwitterException e) {
            return e;
        }
        try {
            userId = String.valueOf(twitter.getId());
        }
        catch (TwitterException e1) {
            return e1;
        }
        ClientProperties clientProperties = this.configProperties;
        synchronized (clientProperties) {
            String[] accountList = this.getAccountList();
            boolean updateAccountList = true;
            for (String accountId : accountList) {
                if (!accountId.equals(userId)) continue;
                updateAccountList = false;
                break;
            }
            if (updateAccountList) {
                this.configProperties.setProperty(PROPERTY_ACCOUNT_LIST, MessageFormat.format("{0} {1}", this.configProperties.getProperty(PROPERTY_ACCOUNT_LIST), userId));
            }
            try {
                this.storeAccessToken(twitter.getOAuthAccessToken());
            }
            catch (TwitterException e) {
                return e;
            }
            this.configProperties.store();
        }
        return null;
    }
}

