/*
 * IPRPC - Inter Process Remote Procedure Call
 *
* Copyright (C) 2012-2013 by Hiroyuki KAJIURA. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 *     1:Redistributions of source code must retain the above copyright notice, 
 *       this list of conditions and the following disclaimer.
 *     2:Redistributions in binary form must reproduce the above copyright notice, 
 *       this list of conditions and the following disclaimer in the documentation 
 *       and/or other materials provided with the distribution.
 *     3:Neither the name of copyright owner nor the names of its contributors 
 *       may be used to endorse or promote products derived from this software 
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef IPCSTUB_H_
#define IPCSTUB_H_

#ifdef	IPC_STUB_MAIN
#define	extern
#endif	/* IPC_STUB_MAIN */

#include	"ipcConf.h"
#include	"ipcType.h"

typedef enum {
	IPC_FUNC_TYPE_UNKOWN = 0,
	IPC_BLOCKING_FUNCTION,
	IPC_NONBLOCKING_FUNCTION,
	IPC_FUNC_TYPE_MAX
} IpcFunctionType_t;

#ifdef	USE_MULTICAST_RPC
typedef struct {
	uint32_t resPid;
	uint32_t errCode;
	void *retParam;
	uint32_t retParamSize;
} IpcMulticastRetData_t;
#endif	/* USE_MULTICAST_RPC */

typedef void (*IPC_CallbackFunc_t)(uint32_t seqNum,void *outData,uint32_t outSize,uint32_t errCode);

extern RpcResult_t IPC_InitStub(RpcBool_t masterProcess);
extern RpcResult_t IPC_CallStubSync(uint32_t funcID, void *inData, uint32_t inSize, void **outData, uint32_t *outSize, uint32_t timeOut, uint32_t *errCode);
extern RpcResult_t IPC_CallStubAsync(uint32_t funcID, void *inData, uint32_t inSize, uint32_t timeOut,IPC_CallbackFunc_t callback , uint32_t *seqNum,uint32_t *errCode);
extern RpcResult_t IPC_StubSyncCancel(RpcTaskID_t taskId,uint32_t *errCode);
extern RpcResult_t IPC_StbuAsyncCancel(uint32_t seqNum,uint32_t *errCode);

#ifdef	USE_MULTICAST_RPC
typedef void (*IPC_MultticastCallbackFunc_t)(uint32_t seqNum,uint32_t numOfRet,IpcMulticastRetData_t *retData,uint32_t errCode);

extern RpcResult_t IPC_CallStubSyncMulticast(uint32_t mltcstFuncId,void *inParams,uint32_t inParamsSize,uint32_t *numOfRet,IpcMulticastRetData_t **retData,uint32_t timeOut,uint32_t *errCode);
extern RpcResult_t IPC_CallStubAsyncMulticast(uint32_t mltcstFuncId,void *inParams,uint32_t inParamsSize,uint32_t timeOut,IPC_MultticastCallbackFunc_t mltcstCallback, uint32_t *seqNum, uint32_t *errCode);
extern void IPC_FreeMulticastOutParams(IpcMulticastRetData_t *retData);

#endif	/* USE_MULTICAST_RPC */

#endif /* IPCSTUB_H_ */
