/*
 * IPRPC - Inter Process Remote Procedure Call
 *
* Copyright (C) 2012-2013 by Hiroyuki KAJIURA. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 *
 *     1:Redistributions of source code must retain the above copyright notice, 
 *       this list of conditions and the following disclaimer.
 *     2:Redistributions in binary form must reproduce the above copyright notice, 
 *       this list of conditions and the following disclaimer in the documentation 
 *       and/or other materials provided with the distribution.
 *     3:Neither the name of copyright owner nor the names of its contributors 
 *       may be used to endorse or promote products derived from this software 
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, 
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, 
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED 
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifndef IPCLOG_H_
#define IPCLOG_H_

#include	<stdio.h>
#include	<stdarg.h>
#include	"ipcType.h"

#ifdef	IPC_LOG_MAIN
#define	extern
#endif	/* IPC_LOG_MAIN */

typedef enum {
	RPC_LOG_MODULE_UNKNOWN = 0,
	RPC_LOG_MODULE_MAIN,
	RPC_LOG_MODULE_SYSCALL,
	RPC_LOG_MODULE_MSG_QUE,
	RPC_LOG_MODULE_SHM,
	RPC_LOG_MODULE_SHM_DB,
	RPC_LOG_MODULE_LIB,
	RPC_LOG_MODULE_MARSHAL,
	RPC_LOG_MODULE_STUB,
	RPC_LOG_MODULE_SKELTON,
	RPC_LOG_MODULE_RENDEZV,
	RPC_LOG_MODULE_MLTCST,
//	RPC_LOG_MODULE_PRCSS_CNTL,
	RPC_LOG_MODULE_INIT,
	IPC_LOG_MODULE_MAX,
#ifdef	USE_IDC
#include	"idcLogId.h"
#endif	/* USE_IDC */
	RPC_LOG_MODULE_MAX
} RpcLogModule_t;

typedef enum {
	RPC_LOG_LEVEL_UNKNOWN = 0,
	RPC_LOG_LEVEL_INFO,
	RPC_LOG_LEVEL_DEBUG3,
	RPC_LOG_LEVEL_DEBUG2,	
	RPC_LOG_LEVEL_DEBUG1,
	RPC_LOG_LEVEL_WARNING,
	RPC_LOG_LEVEL_DEFAULT,	/* NOT USE THIS LEVEL IN LogPrint */
	RPC_LOG_LEVEL_ERROR,
	RPC_LOG_LEVEL_FATAL,
	RPC_LOG_LEVEL_URGENT,
	RPC_LOG_LEVEL_MAX
} RpcLogLevel_t;

extern RpcResult_t RPC_LogInit(void);
extern RpcResult_t RPC_LogSetLevel(RpcLogModule_t module, RpcLogLevel_t level);
extern RpcResult_t RPC_LogSetAll(RpcLogLevel_t level);
extern RpcResult_t RPC_LogPrint(RpcLogModule_t module, RpcLogLevel_t level, char *format, ...);
extern RpcResult_t RPC_LogPrintNomark(RpcLogModule_t module, RpcLogLevel_t level, char *fmt, ...);
extern RpcResult_t RPC_LogPrintInfo(void);
extern char *RPC_LogConvertResultCode(RpcResult_t ret);
extern char *RPC_LogConvertErrCode(uint32_t errCode);

extern void RPC_MemDump(uint8_t *data,uint32_t leng,uint8_t *label);

#endif /* IPCLOG_H_ */
