/*
 * Decompiled with CFR 0.152.
 */
package nekora.cwn.paper;

import java.util.logging.Logger;
import nekora.cwn.paper.UNIT;

class ParcePixel {
    int form_dpi;
    int dpi;
    UNIT unit;
    Logger logger;

    ParcePixel(UNIT u, int d, int data_dpi, Logger logger) {
        this.unit = u;
        this.form_dpi = d;
        this.dpi = data_dpi;
        this.logger = logger;
    }

    int parce(String val) throws Exception {
        double d = Double.parseDouble(val);
        int ret = -1;
        switch (this.unit) {
            case pixel: {
                if (this.form_dpi <= 0) {
                    throw new Exception("dpi\u304c0\u4ee5\u4e0b");
                }
                if (this.form_dpi == this.dpi) {
                    ret = (int)d;
                    break;
                }
                ret = (int)((double)(this.form_dpi / this.dpi) * d);
                break;
            }
            case mm: {
                ret = (int)this.mm_to_pixel(d, this.form_dpi);
                break;
            }
            case inch: {
                ret = (int)this.inch_to_pixel(d, this.form_dpi);
                break;
            }
            default: {
                String msg = "UNIT\u306e\u5024\u304cpixel, mm, inch\u4ee5\u5916\u3002\u901a\u5e38\u6709\u308a\u3048\u306a\u3044";
                this.logger.warning(msg);
                throw new Exception(msg);
            }
        }
        return ret;
    }

    private double mm_to_pixel(double n, int dpi) {
        return n * 0.03937 * (double)dpi;
    }

    private double inch_to_pixel(double n, int dpi) {
        return n * (double)dpi;
    }
}

