/*
 * Decompiled with CFR 0.152.
 */
package nekora.cwn.mix;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import magick.ImageInfo;
import magick.MagickException;
import magick.MagickImage;
import nekora.cwn.mix.MixOut;
import nekora.cwn.paper.InputPaper;

public class MixOut1to1
extends MixOut {
    public MixOut1to1(InputPaper ip, Point baseSize, int borderPixel, Logger logger) {
        super(ip, baseSize, borderPixel, logger);
        this.ip.computeC(this.baseSize.x, this.baseSize.y);
    }

    @Override
    public String make(String outputFileName, String leftFileName, String rightFileName) {
        String ret;
        block22: {
            String outputFileNameR;
            String outputFileNameL;
            String baseSizeText = String.valueOf(this.baseSize.x) + "x" + this.baseSize.y;
            ret = String.valueOf(leftFileName) + " + " + rightFileName + " \u21d2 " + outputFileName + " (" + baseSizeText + ")";
            this.logger.info("start=" + ret);
            File outputFile = new File(outputFileName);
            File outputDir = outputFile.getParentFile();
            String outext = outputFileName.substring(outputFileName.lastIndexOf("."));
            String leftName = new File(leftFileName).getName();
            String rightName = new File(rightFileName).getName();
            try {
                outputFileNameL = String.valueOf(outputDir.getCanonicalPath()) + File.separator + leftName.substring(0, leftName.lastIndexOf(".")) + outext;
                outputFileNameR = String.valueOf(outputDir.getCanonicalPath()) + File.separator + rightName.substring(0, rightName.lastIndexOf(".")) + outext;
                this.logger.info("Left=" + outputFileNameL + " R=" + outputFileNameR);
            }
            catch (IOException e) {
                String msg = "\u51fa\u529b\u30d5\u30a1\u30a4\u30eb\u8a2d\u5b9a\u5931\u6557\u3000" + ret + " err=" + e.getLocalizedMessage();
                this.logger.log(Level.WARNING, msg, e);
                return msg;
            }
            int outW = this.baseSize.y;
            int outH = this.baseSize.x;
            MagickImage leftImage = null;
            MagickImage rightImage = null;
            MagickImage cropImage = null;
            try {
                try {
                    int h;
                    int y;
                    int w;
                    int x;
                    ImageInfo leftInfo = new ImageInfo(leftFileName);
                    leftImage = new MagickImage(leftInfo);
                    int iw = (int)leftImage.getDimension().getWidth();
                    int ih = (int)leftImage.getDimension().getHeight();
                    this.logger.info("\u5de6\u753b\u50cf size=" + iw + ", " + ih);
                    boolean sameX = false;
                    boolean sameY = false;
                    if (outW - iw < 10) {
                        x = 0;
                        w = outW;
                        sameX = true;
                    } else {
                        x = this.ip.getCropC().x;
                        w = outW;
                    }
                    if (outH - ih < 10) {
                        y = 0;
                        h = outH;
                        sameY = true;
                    } else {
                        y = (ih - outH) / 2;
                        h = outH;
                    }
                    if (this.borderPixel > 0) {
                        x += this.borderPixel;
                        y += this.borderPixel;
                        w -= this.borderPixel * 2;
                        h -= this.borderPixel * 2;
                    }
                    Rectangle cropALL = new Rectangle(x, y, w, h);
                    this.logger.info("cropALL=" + cropALL);
                    if (sameX && sameY || iw >= outW) {
                        // empty if block
                    }
                    cropImage = leftImage.cropImage(cropALL);
                    this.logger.info("\u5de6\u753b\u50cf\u6e96\u5099\u5b8c\u4e86");
                    cropImage.setCompression(8);
                    cropImage.setFileName(outputFileNameL);
                    cropImage.writeImage(new ImageInfo());
                    cropImage.destroyImages();
                    this.logger.info("\u5de6\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u5b8c\u4e86:" + outputFileNameL);
                    ImageInfo rightInfo = new ImageInfo(rightFileName);
                    rightImage = new MagickImage(rightInfo);
                    this.logger.info("\u53f3\u753b\u50cf size=" + rightInfo.getSize());
                    cropImage = rightImage.cropImage(cropALL);
                    this.logger.info("\u53f3\u753b\u50cf\u6e96\u5099\u5b8c\u4e86");
                    cropImage.setCompression(8);
                    cropImage.setFileName(outputFileNameR);
                    cropImage.writeImage(new ImageInfo());
                    this.logger.info("\u5de6\u30d5\u30a1\u30a4\u30eb\u51fa\u529b\u5b8c\u4e86:" + outputFileNameR);
                }
                catch (MagickException e) {
                    String msg = e.getLocalizedMessage();
                    this.logger.log(Level.WARNING, msg, e);
                    e.printStackTrace();
                    if (cropImage != null) {
                        cropImage.destroyImages();
                        cropImage = null;
                    }
                    if (rightImage != null) {
                        rightImage.destroyImages();
                        rightImage = null;
                    }
                    if (leftImage != null) {
                        leftImage.destroyImages();
                        leftImage = null;
                    }
                    break block22;
                }
            }
            catch (Throwable throwable) {
                if (cropImage != null) {
                    cropImage.destroyImages();
                    cropImage = null;
                }
                if (rightImage != null) {
                    rightImage.destroyImages();
                    rightImage = null;
                }
                if (leftImage != null) {
                    leftImage.destroyImages();
                    leftImage = null;
                }
                throw throwable;
            }
            if (cropImage != null) {
                cropImage.destroyImages();
                cropImage = null;
            }
            if (rightImage != null) {
                rightImage.destroyImages();
                rightImage = null;
            }
            if (leftImage != null) {
                leftImage.destroyImages();
                leftImage = null;
            }
        }
        this.logger.info("Done=" + ret);
        return ret;
    }
}

