#!/bin/busybox sh
#
# Copyright (C) 2013 fakesh. http://sourceforge.jp/users/fakesh/
# MIT/X Consortium License
#

vers=2

case "$mkBackupLOG" in
*.txt) ;;
*)
  mkBackupLOG="/mnt/onboard/backup$(date +%y%m%d%H%M).log.txt"
  export mkBackupLOG
  exec "$0" "$@" 2>&1 | tee "$mkBackupLOG"
  exit
;;
esac

vol=mmcblk1

me="$(readlink -f "$0")"
wrappingMD_sh="${me%/*}/wrapping-mount-dosfsck.sh"

imgsz=''
eval $(fbset | awk '$1=="geometry"{ printf "w=%d;h=%d;bpp=%d;", $2, $3, $6;}')
if [ "$bpp" = 16 ] ; then
  imgsz="${w}x${h}"
  bs=$((w*h*bpp/8)); cnt=1
  while [ $bs -ge 65536 ] ; do
    [ $((bs%1)) -eq 1 ] && break  # hardly breaks
    bs=$((bs/2)); cnt=$((cnt*2))
  done
  dda="bs=$bs count=$cnt"
fi

imgBase=''
dispImg () {
  local i
  [ -z "$imgBase" ] && return
  case "$1" in
  black) dd if=/dev/zero $dda ;;
  white) dd if=/dev/zero $dda | tr \\0 \\377 ;;
  *.gz) [ -f "$1" ] && zcat "$1" ;;
  *) i="$imgBase$1.raw.gz" ; [ -f "$i" ] && zcat "$i" ;;
  esac 2>/dev/null | /usr/local/Kobo/pickel showpic 1
  return 0
}

wdir=$(mktemp -d /tmp/dev_XXXXXX)
cd "$wdir"

onbImgDir="${FKSH_ONB:=/mnt/onboard/.fakesh}/images"
case "$me" in
*-oneShot.sh)
  myName=easyKoboBackup
  imgBase="${me%/*}/$imgsz"
  if [ -f "$imgBase".raw.gz -a -n "$imgsz" ] ; then
    killall update-animator.sh
    onbImgDirKBK="$onbImgDir/koboBackup"
    if [ -d "$onbImgDir" -a ! -d "$onbImgDirKBK" ] ; then
      mkdir "$onbImgDirKBK"
      cp -p "${imgBase%/*}"/*.raw.gz "$onbImgDirKBK"
    fi
  fi
;;
*)
  myName=koboBackup.sh
  imgBase="$onbImgDir/koboBackup/$imgsz"
  if [ -f "$imgBase".raw.gz -a -n "$imgsz" ] ; then
    dd if=/dev/fb0 of=lastImg $dda
    gzip -9 lastImg &
  fi
;;
esac >/dev/null 2>&1
printf 'This is %s, Version %s\n\n' $myName $vers
dispImg black
dispImg white
dispImg ''

date '+---- %T ----'
printf \\n

sedfdisk='/^$/d;
/^Command/d;
1,/^Disk /{/^Disk/p;d};
/^Disk /d;
/cylinders$/d;
/^Units/{x;p;x;}'

echo 'Current INNER disk geometory:'
printf 'u\np\nu\np\nq\n' | fdisk /dev/mmcblk0 | sed "$sedfdisk"
printf \\n
echo 'Current INNER block device attributes:'
blkid | sort
printf \\n

verFile=/mnt/onboard/.kobo/version
if [ -f $verFile ] ; then
  echo 'Current firmware version, hardware:'
  read fw < $verFile
  hw=${fw##*,}; fw="${fw#*,}"; fw="${fw#*,}"
  echo  "${fw%%,*}, $hw"
  printf \\n
fi

wnkCyc=$(mktemp /tmp/whinkerCyc_XXXXXX)
ledR=/sys/class/leds/pmic_ledsr/brightness
ledG=/sys/class/leds/pmic_ledsg/brightness
ledB=/sys/class/leds/pmic_ledsb/brightness
[ -f "$ledR" ] || ledR=/dev/null
[ -f "$ledG" ] || ledG=/dev/null
[ -f "$ledB" ] || ledB=/dev/null
while : ; do
  if [ ! -f $wnkCyc ] ; then
    echo 0 > "$ledR"
    echo 0 > "$ledG"
    echo 0 > "$ledB"
    exit 0
  fi
  wwait=250  # msec
  while read mcs r g b dum ; do
    # args check
    [ 0 -lt "$mcs" -a "$mcs" -le 2000 ] || continue
    [ 0 -le "$r" -a "$r" -le 255 ] || continue
    [ 0 -le "$g" -a "$g" -le 255 ] || continue
    [ 0 -le "$b" -a "$b" -le 255 ] || continue
    echo $r > "$ledR"
    echo $g > "$ledG"
    echo $b > "$ledB"
    usleep $((mcs*1000))
    wwait=""
  done < $wnkCyc
  [ -n "$wwait" ] && usleep $((wwait*1000))
done < /dev/null > /dev/null 2>&1 &

pipetrash=`mktemp /tmp/pipe-trash_XXXXXX`
magicMSG="_#the#end#of#messages#$$#_"
pipeCleaner () {
  touch $pipetrash
  while : ; do
    while read -r l ; do
      echo "$(date +%T) $l" >> $pipetrash
      [ "$magicMSG" = "$l" ] || continue
      [ -n "$1" ] && kill -CONT $1
      exit 0
    done < /tmp/nickel-hardware-status
  done &
  return 0
}

nickelCtrl () {
  local pid l
  pid=$(pidof nickel)
  #  pipe=/tmp/nickel-hardware-status
  case "$1" in
  STOP)
    if [ -z "$pid" ] ; then
      pipeCleaner
      return 1
    fi
    if awk '$1!="State:"{next;}
            $2=="T"{exit 0;}
            {exit 1;}' /proc/$pid/status ; then
      echo 'ERROR: nickel is alive and STOPed. WHY?'
      rm -f $wnkCyc
      exit 2
    fi
    kill -STOP $pid
    pipeCleaner $pid
    return 0
  ;;
  CONT)
    printf '\n%s\n' "$magicMSG" > /tmp/nickel-hardware-status
    [ -n "$pid" ]
    return
  ;;
  esac
}

# check /dev/mmcblk0p2 (recoveryfs) is not mounted
if grep -q '^/dev/mmcblk0p2' </proc/mounts >/dev/null 2>&1 ; then
  echo 'ERROR: recoveryfs is mounted. Invoke umount /dev/mmcblk0p2'
  dispImg black
  dispImg white
  dispImg lastImg.gz
  cd /; rm -rf "$wdir"
  exit 1
fi

# wait inserting microSD
wSec=30
n=0
while [ $n -lt $wSec ] ; do
  if grep -q "$vol\$" /proc/partitions >/dev/null 2>&1 ; then
    if [ $n -eq 0 ] ; then
      rm -f $wnkCyc
      echo "Dont insert microSD, first. Eject microSD."
      dispImg black
      dispImg white
      dispImg lastImg.gz
      cd /; rm -rf "$wdir"
      exit 3
    else
      printf 'Found'
      break
    fi
  elif [ $n -eq 0 ] ; then
    printf '30 99 0 0\n30 99 99 0\n30 0 99 0\n400 0 0 0\n' > $wnkCyc
    echo 'Send signal STOP to nickel, udevd, etc.'
    nickelCtrl STOP || echo 'But nickel is already DEAD... OK, NO PROBLEM'
    for p in $(pidof udevd fickel hindenburg) ; do kill -STOP $p ; done
    dispImg ins
    echo "Insert microSD in $wSec secs."
    sleep 1
  else
    sleep 1
  fi
  n=$((n+1))
  printf .
done
printf \\n
usleep 2500000 # for insert time lag 2.5sec
printf \\n
date '+---- %T ----'
printf \\n
pzz="$(awk -v "d=$vol" '
  $4==d{printf "%d", int($3/512)}
  ' /proc/partitions)"
pz=$(( (pzz/2)*2 - 1 ))
pzz=$((pzz+1))

paramfile=/mnt/onboard/koboBackup.param
paramfileLOG=${mkBackupLOG%.log*}.param
# exitWithMsg msg exitStatus
exitWithMsg () {
  if [ -f ${paramfile}CUR ] ; then
    rm -rf $paramfileLOG
    mv ${paramfile}CUR $paramfileLOG  # no new i-node
  fi
  printf '%s\n\n%s\n\n' "$1" "$(date '+---- %T ----')"
  yel=99
  [ "$2" -eq 0 ] && yel=0
  printf '10 %d 99 0\n690 0 0 0\n' $yel > $wnkCyc
  if grep -q "$vol\$" /proc/partitions >/dev/null 2>&1 ; then
    dispImg eje
    printf 'Please eject microSD media'
    while : ; do
      printf .
      sleep 1
      grep -q "$vol\$" /proc/partitions >/dev/null 2>&1 || break
    done
    printf '\nEjected\n\n%s\n\n' "$(date '+---- %T ----')"
  fi
  printf '500 99 99 99\n400 0 0 0\n' > $wnkCyc
  dispImg ''
  echo 'Send signal CONT to udevd, etc...'
  for p in $(pidof hindenburg fickel udevd) ; do kill -CONT $p ; done
  echo 'Wait more 12 secs for cleaning pipe.'
  sleep 12 # udev is insistent
  dispImg black
  dispImg white
  dispImg lastImg.gz
  nickelCtrl CONT && echo 'Sent signal CONT to nickel.'
  usleep 250000  # 250msec
#  wait  # for pipeCleaner, but dangerous -- comment out
  printf \\n
  echo '  -  -  -  droped messages to nickel  -  -  -'
  cat $pipetrash
  rm -f $pipetrash
  printf \\n
  date '+---- %T ----'
  printf '\nExit.\n'
  rm -f $wnkCyc
  cd /
  rm -rf "$wdir"
  {
    ## log cleaner
    sedcmd="$(printf 's/........\b\b\b\b\b\b\b\b//g;';
            printf 's/....\b\b\b\b//g;s/..\b\b//g;s/.\b//g')"
    sed -i "$sedcmd" "$mkBackupLOG"
  } </dev/null >/dev/null 2>&1
  exit $2
}

if [ -z "$pz" ] ; then
  exitWithMsg '+++ NO microSD media.' 0
fi

printf '20 99 0 0\n930 0 0 99\n' > $wnkCyc
dispImg ''
# unit = 512KiB 32x32x512B
p1s=$(fdisk -lu /dev/mmcblk0 |
  awk '/^\//&&$1=="/dev\/mmcblk0p1"{print $2;}')
p1lim=$(( (p1s+32*32-1)/(32*32) + 1 ))
p1ceil1=$p1lim
p1ceil2=$(( p1ceil1 + 1 - p1ceil1%2 ))
[ $p1lim -gt 20 ] && p1lim=20  # danger but flexible
## default patitioning
p3type=c
p6=''
spclfld='spcl:auto'  # sectors per cluster for mkdosfs
if [ $pz -lt 1600 ] ; then
  exitWithMsg '***ERROR too small microSD media.' 5
elif [ $pz -lt 5000 ] ; then
  # 1GB or 2GB : 240.5M 200M - 100M
  p1=$p1ceil1
  p2=501
  p3=901
  p5=$((pz-200))
  p9=$pz
elif [ $pz -lt 12000 ] ; then
  # 4GB : 290M 250M - 200M
  p1=$p1ceil2
  p2=601
  p3=1101
  p5=$((pz-400))
  p9=$pz
  spclfld=spcl:32
elif [ $pz -lt 24000 ] ; then
  # 8GB : 490M 300M - 400M 400M
  p1=$p1ceil2
  p2=1001
  p3=1601
  p5=$((pz-1600))
  p6=$((pz-800))
  p9=$pz
  spclfld=spcl:64
else
  # > 8GB : 990M 400M - 500M 1200M
  p1=$p1ceil2
  p2=2001
  p3=2801
  p5=$((pz-3400))
  p6=$((pz-2400))
  p9=$pz
  spclfld=spcl:64
fi
pt="$p1 $p2 $p3 $p5 $p6 $p9 $spclfld"

## manual partitioning
rm -rf ${paramfile}CUR
if [ -f $paramfile ] ; then
  dos2unix $paramfile
  read paramIn < $paramfile
  case "$paramIn" in
  [1-9]*)
    pt="$paramIn"
    printf 'Found custom parameter file "%s":\n%s\n\n' \
     ${paramfile##*/} "$pt"
  ;;
  *) paramIn="" ;; # get default param and exit 0
  esac
  mv -f $paramfile ${paramfile}CUR
fi

echo 'Partitioning of OUTER disk will be:'
pp=''
n=0
for p in $pt ; do
  case "$p" in
  spcl:*) spcl=${p#spcl:}; continue ;;
  [!1-9]*) continue ;;
  esac
  if [ -z "$pp" ] ; then
    pp=$p
    pt_reform=$p
    [ $p -lt $p1lim ] && exitWithMsg "Must be $p1lim <= $p" 6
    continue
  fi
  n=$((n+1))
  if [ $p -gt $pz ] ; then
    [ $p -gt $pzz ] && p=$pzz
    pz=$p
  fi
  [ $pp -lt $p ] || exitWithMsg "Must be $pp < $p for $lvl" 7
  case $n in
  1) # 192MiB
    lvl="rootfs"
    [ $((p-pp)) -lt 384 ] && \
      exitWithMsg "Must be $pp + 384 <= $p for $lvl" 8
  ;; 
  2) # 144MiB
    lvl="recoveryfs"
    [ $((p-pp)) -lt 288 ] && \
      exitWithMsg "Must be $pp + 288 <= $p for $lvl" 9
  ;; 
  3) # 256MiB
    lvl="KOBOeReader"
    [ $((p-pp)) -lt 512 ] && \
      exitWithMsg "Must be $pp + 512 <= $p for $lvl" 10
  ;;
  4) # 32MiB
    n=5
    lvl="koboswap"
    [ $((p-pp)) -lt 63 ] && \
      exitWithMsg "Must be $pp + 63 <= $p for $lvl" 11
  ;;
  6) lvl="kobohome" ;;
  7) lvl="koboextra" ;;
  *) lvl="" ;;
  esac
  echo $n $pp $p | awk -v "lvl=$lvl" '
    {printf "%d: %7.1fMiB %s\n", $1, ($3 - $2)/2.0, lvl}'
  pp=$p
  pt_reform="$pt_reform $p"
done
mtoptp3=''
case "$spcl" in
1|2|4|8|16|32|64|128)
  echo "KOBOeReader: $spcl sectors/cluster"
  pt_reform="$pt_reform spcl:$spcl"
;;
0 | ext4)
  echo 'KOBOeReader: ext4 # Best choice !!'
  spcl=0
  p3type=83
  mtoptp3='-t ext4 -o norelatime,noatime,nodiratime'
  pt_reform="$pt_reform spcl:ext4"
;;
*)
  echo "KOBOeReader: auto sectors/cluster"
  spcl=''
  pt_reform="$pt_reform spcl:auto"
;;
esac
pt="$pt_reform"
if [ $n -lt 3 ] ; then
  exitWithMsg '***ERROR too few partitions.' 12
fi
ptn=$n
printf '\nOK '
if [ $ptn -le 3 ] ; then
  printf '%d partitions will be prepared.\n' $ptn
else
  printf '%d+1 partitions will be prepared.\n' $((ptn-1))
fi
if [ -f ${paramfile}CUR ] ; then
  if [ -z "$paramIn" ] ; then
    mv -f ${paramfile}CUR $paramfile
    echo "$pt" > $paramfile
    cat <<- EOPTNMSGdr
	You can customize the partitioning by editing
	the file "${paramfile##*/}".
	contents: $pt
	EOPTNMSGdr
  else
    rm -rf $paramfileLOG
    mv ${paramfile}CUR $paramfileLOG  # no new i-node
    echo "$pt" > $paramfileLOG
    cat <<- EOPTNMSGre
	You can recustomize the partitioning by editing
	the file "${paramfileLOG##*/}" and rename it to "${paramfile##*/}".
	contents: $pt
	EOPTNMSGre
  fi
else
  cat <<- EOPTNMSG
	You can customize the partitioning by
	PROMPT# echo "$pt" >$paramfile
	and edit the file "${paramfile##*/}"
	EOPTNMSG
fi
printf \\n
cat << 'EoNOTEspcl'
           cluster size (partition size)
spcl:auto   auto by /sbin/mkfs.vfat
spcl:8      4KiB (256MiB--1TiB)
spcl:16     8KiB (512MiB--2TiB)
spcl:32    16KiB (1GiB--4TiB)
spcl:64    32KiB (2GiB--8TiB)
spcl:128   64KiB (4GiB--16TiB)
spcl:ext4   ext4
EoNOTEspcl

mkDevices () {
  rm -f $vol "$vol"p[1-9]*
  while read major minor blocks nam ; do
    case "$nam" in $vol*)
      rm -f "$nam"
      mknod -m 600 "$nam" b $major $minor
    ;; esac
  done < /proc/partitions
}
mkDevices

fdiskBatch () {
  printf \\n
  pp=''
  n=0
  for p in $pt '' ; do
    case "$p" in [!1-9]*) continue ;; esac
    if [ -z "$pp" ] ; then
      printf '\no\n'
      pp=$p
      continue
    fi
    if [ -z "$p" ] ; then
      printf 'u\np\nu\np\n%s\n' $1
      break
    fi
    n=$((n+1))
    [ $p -gt $pz ] && p=$pz
    case $n in
    1|2|3)
      printf 'n\np\n%d\n%d\n%d\n' $n $pp $((p-1))
      [ $n -eq 3 ] && printf 't\n3\n%s\n' $p3type # FAT32(LBA)
    ;;
    4)
      printf 'n\ne\n%d\n%d\n' $pp $((pz-1))
      n=5
      printf 'n\n%d\n%d\nt\n5\n82\n' $pp $((p-1))
    ;;
    *)
      printf 'n\n%d\n%d\n' $pp $((p-1))
    ;;
    esac
    pp=$p
  done | fdisk -H 32 -S 32 $vol | sed "$sedfdisk"
}

printf  '\n ==== fdisk SIMULATION ====\n'
fdiskBatch q

[ -f $paramfile ] && exitWithMsg '
 == Finish DRY RUNNING ==
' 0

if [ YES != "$1" ] ; then
  printf '\nOK? [N/YES(type YES)] '
  read YN
  case $YN in
  YES) echo "$YN" ;;
  *) exitWithMsg 'Canceled.' 0 ;;
  esac
fi

printf \\n
date '+---- %T ----'
printf \\n
printf '20 99 0 0\n630 0 0 99\n' > $wnkCyc
dispImg wrt
echo "Copy current META data (S/N, ... etc.)"
echo "Invoke: dd if=/dev/mmcblk0 of=$vol bs=512K count=20"
dd if=/dev/mmcblk0 of=$vol bs=512K count=20
sync; sync; sync; 

echo "Clear partition table"
echo "Invoke: dd if=/dev/zero of=$vol bs=2 seek=223 count=32"
dd if=/dev/zero of=$vol bs=2 seek=223 count=32
sync; sync; sync; 
{
hdparm -z ./$vol
sync; sync; sync;
hdparm -z ./$vol
sync; sync; sync;
} >/dev/null 2>&1

echo "Partitioning"
fdiskBatch w >/dev/null
sync; sync; sync;
{
hdparm -z ./$vol
sync; sync; sync;
hdparm -z ./$vol
sync; sync; sync;
} >/dev/null 2>&1
mkDevices

fdisk -l $vol ||
  exitWithMsg "fdisk fails partitioning" 13
echo 'Device files:'
ls -l "$vol"*
n=1
while [ $n -le $ptn ] ; do
  [ -e "${vol}p$n" ] || exitWithMsg "fdisk fails partitioning" 14
  n=$((n+1))
done

mkdir -m 000 src
mount /dev/mmcblk0p2 -t ext4 -o ro,noatime,nodiratime src

exitUnmountWithMsg () {
  for mtpt in */ ; do
    umount ${mtpt%/}
  done >/dev/null 2>&1
  sync; sync; sync
  for mtpt in */ ; do
    umount ${mtpt%/}
  done >/dev/null 2>&1
  sync; sync; sync
  exitWithMsg "$1" "$2"
}

PRODUCT=$(/bin/kobo_config.sh)
[ "$PRODUCT" != trilogy ] && PREFIX="$PRODUCT"-
PLATFORM=freescale
[ $(dd if=/dev/mmcblk0 bs=512 skip=1024 count=1 2>/dev/null |
      grep -c "HW CONFIG") == 1 ] && PLATFORM=ntx508

UBOOT="src/upgrade/$PLATFORM/u-boot.bin"
if [ "$PLATFORM" = ntx508 ] ; then
  PCB=$(ntx_hwconfig -s -p /dev/mmcblk0 PCB)
  RAM=$(ntx_hwconfig -s -p /dev/mmcblk0 RAMType)
  NEW_UBOOT="src/upgrade/$PLATFORM/u-boot_mddr_256-$PCB-$RAM.bin"
  [ -e "$NEW_UBOOT" ] && UBOOT="$NEW_UBOOT"
fi
[ -e "$UBOOT" ] || exitUnmountWithMsg "NO U-Boot: $UBOOT" 15

printf \\n
echo "Install: U-Boot"
echo "Invoke: dd if=$UBOOT of=$vol bs=1K seek=1 skip=1"
dd if=$UBOOT of=$vol bs=1K seek=1 skip=1 ||
  exitUnmountWithMsg "Fail:" 16
sync; sync; sync

KERNEL="src/upgrade/$PLATFORM/uImage"
[ -e "$KERNEL" ] || exitUnmountWithMsg "NO kernel: $KERNEL" 17

printf \\n
echo "Install: kernel"
echo "Invoke: dd if=$KERNEL of=$vol bs=512 seek=2048"
dd if=$KERNEL of=$vol bs=512 seek=2048 ||
  exitUnmountWithMsg "Fail:" 18
sync; sync; sync

printf \\n
date '+---- %T ----'
printf '20 99 0 0\n430 0 0 99\n' > $wnkCyc

printf \\n
echo "Format partitions..."
mkfs="./src/sbin/mkfs.ext4"
[ -x "$mkfs" ] || exitUnmountWithMsg "***ERROR NO: $mkfs" 19

printf \\n
echo "Invoke: $mkfs -v -L rootfs -m 0 ${vol}p1"
$mkfs -v -L rootfs -m 0 "$vol"p1 ||
  exitUnmountWithMsg "***ERROR $mkfs ${vol}p1" 20
sync; sync; sync

printf \\n
echo "Invoke: $mkfs -v -L recoveryfs -m 0 ${vol}p2"
$mkfs -v -L recoveryfs -m 0 "$vol"p2 ||
  exitUnmountWithMsg "***ERROR $mkfs ${vol}p2" 21
sync; sync; sync

printf \\n
if [ -z "$spcl" ] ; then
  echo "Invoke: mkfs.vfat -v -n KOBOeReader ${vol}p3"
  busybox mkfs.vfat -v -n KOBOeReader "$vol"p3 ||
    exitUnmountWithMsg "***ERROR mkfs.vfat ${vol}p3" 22
elif [ $spcl -gt 0 ] ; then
  echo "Invoke: /bin/mkdosfs -F 32 -s $spcl -v -n KOBOeReader ${vol}p3"
  /bin/mkdosfs -F 32 -s $spcl -v -n KOBOeReader "$vol"p3 ||
    exitUnmountWithMsg "***ERROR mkdosfs ${vol}p3" 22
else
  echo "Invoke: $mkfs -v -L KOBOeReader -m 0 ${vol}p3"
  $mkfs -v -L KOBOeReader -m 0 "$vol"p3 ||
    exitUnmountWithMsg "***ERROR $mkfs ${vol}p3" 22
fi
sync; sync; sync

printf \\n
if [ -e "$vol"p5 ] ; then
  echo "Invoke: mkswap -L koboswap ${vol}p5"
  mkswap -L koboswap "$vol"p5 ||
    exitUnmountWithMsg "***ERROR mkswap ${vol}p5" 23
  sync; sync; sync
else
  echo "NO SWAP PARTITON: ${vol}p5"
fi

if [ -e "$vol"p6 ] ; then
  printf \\n
  echo "Invoke: $mkfs -v -L kobohome -m 0 ${vol}p6"
  $mkfs -v -L kobohome -m 0 "$vol"p6 ||
    exitUnmountWithMsg "***ERROR $mkfs ${vol}p6" 24
  sync; sync; sync
fi

if [ -e "$vol"p7 ] ; then
  printf \\n
  echo "Invoke: $mkfs -v -L kobohome -m 0 ${vol}p7"
  $mkfs -v -L koboextra -m 0 "$vol"p7 ||
    exitUnmountWithMsg "***ERROR $mkfs ${vol}p7" 24
  sync; sync; sync
fi

printf \\n
date '+---- %T ----'
printf '20 99 0 0\n130 0 0 99\n' > $wnkCyc

printf \\n
echo "Cloning recoveryfs"
mkdir -m 000 dst
mtopt="norelatime,noatime,nodiratime"
mount -t ext4 -o $mtopt "$vol"p2 dst ||
   exitUnmountWithMsg "***ERROR mounting ${vol}p2" 25
for d in src/.* src/* ; do
  case "${d#*/}" in
  . | .. | 'lost+found') continue ;;
  esac
  [ -e "$d" -o -L "$d" ] || continue
  printf '%s ' "${d#*/}"
  cp -a "$d" dst/
done
## change: /sbin/mkfs.vfat
##   /bin/wrapping-mount-dosfsck.sh /bin/mount  /bin/umount /bin/dosfsck 
if [ ! -L dst//sbin/mkfs.vfat ] &&
      grep -q '# a part of fakesh-kobo' dst/sbin/mkfs.vfat ; then
    printf '\nRestore /sbin/mkfs.vfat'
    rm -rf dst/sbin/mkfs.vfat
    ln -s ../bin/busybox dst/sbin/mkfs.vfat
fi
if [ -f dst/bin/wrapping-mount-dosfsck.sh ] ; then
  printf '\nRestore /bin/mount , /bin/umount and /bin/dosfsck,'
  $wrappingMD_sh dst restore
  printf '\nand delete wrapping-mount-dosfsck.sh'
  rm -f dst/bin/wrapping-mount-dosfsck.sh
fi
# wrap
if [ -n "$spcl" ] ; then
  if [ $spcl -gt 0 -a -x dst/bin/mkdosfs ] ; then
    printf '\nReplacing "mkfs.vfat" to "/bin/mkdosfs -F 32 -s %d"' $spcl
    ## dst/sbin/mkdosfs is busybox 
    rm -rf dst/sbin/mkfs.vfat
    cat > dst/sbin/mkfs.vfat <<- EOWRAP1
	#!/bin/busybox sh
	# a part of fakesh-kobo
	exec /bin/mkdosfs -F 32 -s $spcl "\$@"
	EOWRAP1
    chmod 755 dst/sbin/mkfs.vfat
  elif [ $spcl -eq 0 -a -x dst/sbin/mkfs.ext4 ] ; then
    printf '\nReplacing "mkfs.vfat -n" to "mkfs.ext4 -m 0 -L"'
    rm -rf dst/sbin/mkfs.vfat
    cat > dst/sbin/mkfs.vfat <<- 'EOWRAP2'
	#!/bin/busybox sh
	# a part of fakesh-kobo
	a='set --'; n=1
	for i do
	  case "$i" in
	  -*n*) a="$a ${i%n*}L${i##*n}" ;; # change
	  *) a="$a \"\$$n\"" ;;
	  esac
	  n=$((n+1))
	done
	eval "$a"
	exec /sbin/mkfs.ext4 -m 0 "$@"
	EOWRAP2
    chmod 755 dst/sbin/mkfs.vfat
    printf '\nInstall the wrapping script /bin/wrapping-mount-dosfsck.sh'
    cp -p $wrappingMD_sh dst/bin/wrapping-mount-dosfsck.sh
    printf '\nWrap /bin/mount , /bin/umount and /bin/dosfsck'
    $wrappingMD_sh dst
  fi
fi
sync; sync; sync

printf \\n
umount dst ||
   exitUnmountWithMsg "***ERROR unmounting ${vol}p2" 26
sync; sync; sync

printf \\n
date '+---- %T ----'
printf '20 99 0 0\n80 0 0 99\n' > $wnkCyc

printf \\n
fstgz=src/upgrade/fs.tgz
[ -e $fstgz ] ||
   exitUnmountWithMsg "***ERROR No $fstgz" 27
mount -t ext4 -o $mtopt "$vol"p1 dst ||
   exitUnmountWithMsg "***ERROR mounting ${vol}p1" 28
echo "Expanding factory image of rootfs. Take a while..."
tar zxf $fstgz -C dst ||
   exitUnmountWithMsg "***ERROR " 29
if [ "$spcl" = 0 ] ; then
  echo 'Wrap /bin/mount and /bin/dosfsck on rootfs'
  $wrappingMD_sh dst
fi
sync; sync; sync
umount dst ||
   exitUnmountWithMsg "***ERROR unmounting ${vol}p1" 30
sync; sync; sync

printf \\n
date '+---- %T ----'
printf \\n
dbtgz=src/upgrade/db.tgz
[ -e $dbtgz ] ||
   exitUnmountWithMsg "***ERROR No $dbtgz" 31
mount $mtoptp3 "$vol"p3 dst ||
   exitUnmountWithMsg "***ERROR mounting ${vol}p3" 32
echo "Expanding factory image of KOBOeReader"
tar zxf $dbtgz -C dst ||
   exitUnmountWithMsg "***ERROR " 33
[ "$spcl" = 0 ] && chmod 1777 dst
sync; sync; sync
umount dst ||
   exitUnmountWithMsg "***ERROR unmounting ${vol}p3" 34
sync; sync; sync
rmdir dst ||
   exitUnmountWithMsg "***ERROR nonempty dst" 35

printf \\n
ubmmc="src/etc/u-boot/$PLATFORM/u-boot.mmc"
[ -e $ubmmc ] ||
   exitUnmountWithMsg "***ERROR No $ubmmc" 36
echo "Invoke: dd if=$ubmmc of=$vol bs=128K seek=6 count=1"
dd if=$ubmmc of=$vol bs=128K seek=6 count=1 ||
  exitUnmountWithMsg "Fail:" 37
{
hdparm -z ./$vol
sync; sync; sync; 
hdparm -z ./$vol
sync; sync; sync; 
} >/dev/null 2>&1

printf \\n
umount src ||
   exitUnmountWithMsg "***ERROR unmounting /dev/mmcblk0p2" 38
sync; sync; sync
rmdir src ||
   exitUnmountWithMsg "***ERROR nonempty src" 39

sync; sync; sync
sleep 1
sync; sync; sync
sleep 1
sync; sync; sync
sleep 1
exitUnmountWithMsg "|+++ OKOKOK SUCCESSFULLY BACKUPED +++|" 0

exit
