/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.netezza;

import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetezzaDataTypeFactory
extends DefaultDataTypeFactory {
    private static final Logger logger = LoggerFactory.getLogger((Class)NetezzaDataTypeFactory.class);
    public static final int RECADDR = 1;
    public static final int NUMERIC = 2;
    public static final int DECIMAL = 3;
    public static final int INTEGER = 4;
    public static final int SMALLINT = 5;
    public static final int DOUBLE = 8;
    public static final int INTERVAL = 10;
    public static final int BOOLEAN = -7;
    public static final int CHAR = -1;
    public static final int FLOAT = 6;
    public static final int REAL = 7;
    public static final int VARCHAR = 12;
    public static final int DATE = 91;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int TIMETZ = 1266;
    public static final int UNKNOWN = 18;
    public static final int BYTEINT = -6;
    public static final int INT8 = 20;
    public static final int VARFIXEDCHAR = 21;
    public static final int NUCL = 22;
    public static final int PROT = 23;
    public static final int BLOB = 24;
    public static final int BIGINT = -5;
    public static final int NCHAR = -8;
    public static final int NVARCHAR = -9;
    public static final int NTEXT = 27;

    public DataType createDataType(int sqlType, String sqlTypeName) throws DataTypeException {
        if (logger.isDebugEnabled()) {
            logger.debug("createDataType(sqlType={}, sqlTypeName={}) - start", (Object)String.valueOf(sqlType), (Object)sqlTypeName);
        }
        switch (sqlType) {
            case 1: {
                return DataType.VARCHAR;
            }
            case 4: {
                return DataType.INTEGER;
            }
            case 10: {
                return DataType.TIMESTAMP;
            }
            case 1266: {
                return DataType.TIMESTAMP;
            }
            case -7: {
                return DataType.BOOLEAN;
            }
            case 5: {
                return DataType.SMALLINT;
            }
            case 7: {
                return DataType.FLOAT;
            }
            case -6: {
                return DataType.INTEGER;
            }
            case 20: {
                return DataType.BIGINT;
            }
            case 21: {
                return DataType.CHAR;
            }
            case 22: {
                return DataType.CHAR;
            }
            case 23: {
                return DataType.CHAR;
            }
            case 91: {
                return DataType.DATE;
            }
            case 24: {
                return DataType.BLOB;
            }
            case -8: {
                return DataType.CHAR;
            }
            case -9: {
                return DataType.VARCHAR;
            }
            case 27: {
                return DataType.LONGVARCHAR;
            }
            case 12: {
                return DataType.VARCHAR;
            }
        }
        return super.createDataType(sqlType, sqlTypeName);
    }
}

