/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.dataset.sqlloader;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.common.handlers.IllegalInputCharacterException;
import org.dbunit.dataset.common.handlers.PipelineException;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.sqlloader.SqlLoaderControlParserException;
import org.dbunit.dataset.sqlloader.SqlLoaderControlParserImpl;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.dbunit.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlLoaderControlProducer
implements IDataSetProducer {
    private static final Logger logger = LoggerFactory.getLogger((Class)SqlLoaderControlProducer.class);
    private static final String TMP_TABLE_LIST_FILENAME = "table-list.txt";
    public static final String NULL = "null";
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private IDataSetConsumer consumer = EMPTY_CONSUMER;
    private final File controlFilesDir;
    private List orderedTableNames;

    public SqlLoaderControlProducer(String controlFilesDir, String tableOrderFile) throws DataSetException {
        this(new File(controlFilesDir), new File(tableOrderFile));
    }

    public SqlLoaderControlProducer(File controlFilesDir, File tableOrderFile) throws DataSetException {
        this.controlFilesDir = controlFilesDir;
        try {
            this.orderedTableNames = SqlLoaderControlProducer.getTables(controlFilesDir, tableOrderFile);
        }
        catch (IOException e) {
            throw new DataSetException("error getting list of tables from file '" + tableOrderFile + "'", e);
        }
    }

    public SqlLoaderControlProducer(File controlFilesDir, List orderedTableNames) {
        this.controlFilesDir = controlFilesDir;
        this.orderedTableNames = orderedTableNames;
    }

    public void setConsumer(IDataSetConsumer consumer) throws DataSetException {
        this.consumer = consumer;
    }

    public void produce() throws DataSetException {
        logger.debug("produce() - start");
        File dir = this.controlFilesDir;
        if (!this.controlFilesDir.isDirectory()) {
            throw new DataSetException("'" + this.controlFilesDir + "' should be a directory of the control files");
        }
        this.consumer.startDataSet();
        Iterator tableIter = this.orderedTableNames.iterator();
        while (tableIter.hasNext()) {
            String table = (String)tableIter.next();
            try {
                File ctlFile = new File(dir, table + ".ctl");
                this.produceFromControlFile(ctlFile);
            }
            catch (SqlLoaderControlParserException e) {
                throw new DataSetException("error producing dataset for table '" + table + "'", e);
            }
            catch (DataSetException e) {
                throw new DataSetException("error producing dataset for table '" + table + "'", e);
            }
        }
        this.consumer.endDataSet();
    }

    private void produceFromControlFile(File controlFile) throws DataSetException, SqlLoaderControlParserException {
        logger.debug("produceFromControlFile(controlFile={}) - start", (Object)controlFile);
        try {
            SqlLoaderControlParserImpl parser = new SqlLoaderControlParserImpl();
            List readData = parser.parse(controlFile);
            List readColumns = (List)readData.get(0);
            Column[] columns = new Column[readColumns.size()];
            for (int i = 0; i < readColumns.size(); ++i) {
                columns[i] = new Column((String)readColumns.get(i), DataType.UNKNOWN);
            }
            String tableName = parser.getTableName();
            DefaultTableMetaData metaData = new DefaultTableMetaData(tableName, columns);
            this.consumer.startTable(metaData);
            for (int i = 1; i < readData.size(); ++i) {
                List rowList = (List)readData.get(i);
                Object[] row = rowList.toArray();
                for (int col = 0; col < row.length; ++col) {
                    row[col] = row[col].equals(NULL) ? null : row[col];
                }
                this.consumer.row(row);
            }
            this.consumer.endTable();
        }
        catch (PipelineException e) {
            throw new DataSetException(e);
        }
        catch (IllegalInputCharacterException e) {
            throw new DataSetException(e);
        }
        catch (IOException e) {
            throw new DataSetException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getTables(File controlFilesDir, File tableList) throws IOException {
        List orderedNames;
        logger.debug("getTables(controlFilesDir={}, tableList={}) - start", (Object)controlFilesDir, (Object)tableList);
        File tmpTableList = new File(controlFilesDir, TMP_TABLE_LIST_FILENAME);
        FileHelper.copyFile(tableList, tmpTableList);
        try {
            orderedNames = FileHelper.readLines(tmpTableList);
        }
        finally {
            boolean success = tmpTableList.delete();
            if (!success) {
                throw new IOException("Deletion of temorary file failed: " + tmpTableList);
            }
        }
        return orderedNames;
    }
}

