/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.dbunit.DatabaseUnitRuntimeException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseDataSet;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.IResultSetTable;
import org.dbunit.database.IResultSetTableFactory;
import org.dbunit.database.statement.IStatementFactory;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.util.QualifiedTableName;
import org.dbunit.util.SQLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatabaseConnection
implements IDatabaseConnection {
    private static final Logger logger = LoggerFactory.getLogger((Class)AbstractDatabaseConnection.class);
    private IDataSet _dataSet = null;
    private final DatabaseConfig _databaseConfig = new DatabaseConfig();

    public IDataSet createDataSet() throws SQLException {
        logger.debug("createDataSet() - start");
        if (this._dataSet == null) {
            this._dataSet = new DatabaseDataSet(this);
        }
        return this._dataSet;
    }

    public IDataSet createDataSet(String[] tableNames) throws DataSetException, SQLException {
        logger.debug("createDataSet(tableNames={}) - start", (Object[])tableNames);
        return new FilteredDataSet(tableNames, this.createDataSet());
    }

    public ITable createQueryTable(String resultName, String sql) throws DataSetException, SQLException {
        logger.debug("createQueryTable(resultName={}, sql={}) - start", (Object)resultName, (Object)sql);
        IResultSetTableFactory tableFactory = this.getResultSetTableFactory();
        IResultSetTable rsTable = tableFactory.createTable(resultName, sql, (IDatabaseConnection)this);
        if (logger.isDebugEnabled()) {
            String rowCount = null;
            try {
                int rowCountInt = rsTable.getRowCount();
                rowCount = String.valueOf(rowCountInt);
            }
            catch (Exception e) {
                rowCount = "Unable to determine row count due to Exception: " + e.getLocalizedMessage();
            }
            logger.debug("createQueryTable: rowCount={}", (Object)rowCount);
        }
        return rsTable;
    }

    public ITable createTable(String resultName, PreparedStatement preparedStatement) throws DataSetException, SQLException {
        logger.debug("createQueryTable(resultName={}, preparedStatement={}) - start", (Object)resultName, (Object)preparedStatement);
        IResultSetTableFactory tableFactory = this.getResultSetTableFactory();
        IResultSetTable rsTable = tableFactory.createTable(resultName, preparedStatement, (IDatabaseConnection)this);
        return rsTable;
    }

    public ITable createTable(String tableName) throws DataSetException, SQLException {
        logger.debug("createTable(tableName={}) - start", (Object)tableName);
        if (tableName == null) {
            throw new NullPointerException("The parameter 'tableName' must not be null");
        }
        QualifiedTableName qualifiedTableName = new QualifiedTableName(tableName, this.getSchema());
        String qualifiedName = qualifiedTableName.getQualifiedName();
        String sql = "select * from " + qualifiedName;
        return this.createQueryTable(tableName, sql);
    }

    public int getRowCount(String tableName) throws SQLException {
        logger.debug("getRowCount(tableName={}) - start", (Object)tableName);
        return this.getRowCount(tableName, null);
    }

    public int getRowCount(String tableName, String whereClause) throws SQLException {
        logger.debug("getRowCount(tableName={}, whereClause={}) - start", (Object)tableName, (Object)whereClause);
        StringBuffer sqlBuffer = new StringBuffer(128);
        sqlBuffer.append("select count(*) from ");
        QualifiedTableName qualifiedTableName = new QualifiedTableName(tableName, this.getSchema());
        String qualifiedName = qualifiedTableName.getQualifiedName();
        sqlBuffer.append(qualifiedName);
        if (whereClause != null) {
            sqlBuffer.append(" ");
            sqlBuffer.append(whereClause);
        }
        Statement statement = this.getConnection().createStatement();
        ResultSet resultSet = null;
        try {
            resultSet = statement.executeQuery(sqlBuffer.toString());
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
                return n;
            }
            throw new DatabaseUnitRuntimeException("Select count did not return any results for table '" + tableName + "'. Statement: " + sqlBuffer.toString());
        }
        finally {
            SQLHelper.close(resultSet, statement);
        }
    }

    public DatabaseConfig getConfig() {
        return this._databaseConfig;
    }

    public IStatementFactory getStatementFactory() {
        return (IStatementFactory)this._databaseConfig.getProperty("http://www.dbunit.org/properties/statementFactory");
    }

    private IResultSetTableFactory getResultSetTableFactory() {
        return (IResultSetTableFactory)this._databaseConfig.getProperty("http://www.dbunit.org/properties/resultSetTableFactory");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("_databaseConfig=").append(this._databaseConfig);
        sb.append(", _dataSet=").append(this._dataSet);
        return sb.toString();
    }
}

