package org.routine_work.android_r.utils;

/**
 *
 * @author sawai
 */
public class Log
{
	public static final int VERBOSE = android.util.Log.VERBOSE;
	public static final int DEBUG = android.util.Log.DEBUG;
	public static final int INFO = android.util.Log.INFO;
	public static final int WARN = android.util.Log.WARN;
	public static final int ERROR = android.util.Log.ERROR;
	private static final int DEFAULT_OUTPUT_LEVEL = INFO;
	private static final boolean DEFAULT_TRACE_MODE = false;
	static int outputLevel = DEFAULT_OUTPUT_LEVEL;
	static boolean traceMode = DEFAULT_TRACE_MODE;

	public static int getOutputLevel()
	{
		return outputLevel;
	}

	public static void setOutputLevel(int outputLevel)
	{
		Log.outputLevel = outputLevel;
	}

	public static boolean isTraceMode()
	{
		return traceMode;
	}

	public static void setTraceMode(boolean traceMode)
	{
		Log.traceMode = traceMode;
	}

	public static void v(String tag, String message)
	{
		print(VERBOSE, tag, message, null);
	}

	public static void v(String tag, String message, Throwable ex)
	{
		print(VERBOSE, tag, message, ex);
	}

	public static void d(String tag, String message)
	{
		print(DEBUG, tag, message, null);
	}

	public static void d(String tag, String message, Throwable ex)
	{
		print(DEBUG, tag, message, ex);
	}

	public static void i(String tag, String message)
	{
		print(INFO, tag, message, null);
	}

	public static void i(String tag, String message, Throwable ex)
	{
		print(INFO, tag, message, ex);
	}

	public static void w(String tag, String message)
	{
		print(WARN, tag, message, null);
	}

	public static void w(String tag, String message, Throwable ex)
	{
		print(WARN, tag, message, ex);
	}

	public static void e(String tag, String message)
	{
		print(ERROR, tag, message, null);
	}

	public static void e(String tag, String message, Throwable ex)
	{
		print(ERROR, tag, message, ex);
	}

	public static void log(int priority, String tag, String message)
	{
		print(priority, tag, message, null);
	}

	public static void log(int priority, String tag, String message, Throwable ex)
	{
		print(priority, tag, message, ex);
	}

	private static void print(int priority, String tag, String message, Throwable ex)
	{
		if (priority < outputLevel)
		{
			return;
		}

		String log = message;
		if (traceMode)
		{
			StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
			if (stackTraceElements.length >= 5)
			{
				StackTraceElement e = stackTraceElements[4];
				log = "[" + e.getClassName() + "#" + e.getMethodName() + "():" + e.getLineNumber() + "]"
					+ " : " + message;
			}
		}


		if (ex == null)
		{
			switch (priority)
			{
				case VERBOSE:
					android.util.Log.v(tag, log);
					break;
				case DEBUG:
					android.util.Log.d(tag, log);
					break;
				case INFO:
					android.util.Log.i(tag, log);
					break;
				case WARN:
					android.util.Log.w(tag, log);
					break;
				case ERROR:
					android.util.Log.e(tag, log);
					break;
			}
		}
		else
		{
			switch (priority)
			{
				case VERBOSE:
					android.util.Log.v(tag, log, ex);
					break;
				case DEBUG:
					android.util.Log.d(tag, log, ex);
					break;
				case INFO:
					android.util.Log.i(tag, log, ex);
					break;
				case WARN:
					android.util.Log.w(tag, log, ex);
					break;
				case ERROR:
					android.util.Log.e(tag, log, ex);
					break;
			}
		}
	}
}
