/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.routine_work.android_r.drawable;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.Checkable;
import android.widget.FrameLayout;
import org.routine_work.android_r.R;

/**
 *
 * @author sawai
 */
public class ColorSampleView extends FrameLayout implements Checkable
{

	private Checkable checkable;

	public ColorSampleView(Context context, AttributeSet attrs, int defStyle)
	{
		super(context, attrs, defStyle);
		initViews();
	}

	public ColorSampleView(Context context, AttributeSet attrs)
	{
		super(context, attrs);
		initViews();
	}

	public ColorSampleView(Context context)
	{
		super(context);
		initViews();
	}

	private void initViews()
	{
		LayoutInflater inflater = (LayoutInflater) getContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View rootView = inflater.inflate(R.layout.color_sample_view, this);
		View colorNameView = rootView.findViewById(R.id.color_name_textview);
		if (colorNameView instanceof Checkable)
		{
			checkable = (Checkable) colorNameView;
		}
	}

	public void toggle()
	{
		checkable.toggle();
	}

	public void setChecked(boolean arg0)
	{
		checkable.setChecked(arg0);
	}

	public boolean isChecked()
	{
		return checkable.isChecked();
	}
}
