package org.routine_work.android_r.array;

import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.ArrayAdapter;
import java.lang.reflect.Field;
import org.routine_work.android_r.AppConstants;
import org.routine_work.android_r.PreferencesActivity;
import org.routine_work.android_r.utils.Log;
import org.routine_work.android_r.R;

public class ArrayResourceListActivity extends ListActivity
{

	public static final String EXTRA_ARRAY_FIELD_NAME = "EXTRA_ARRAY_FIELD_NAME";
	private static final String LOG_TAG = "android.R";

	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.simple_list_activity);

		Bundle extras = getIntent().getExtras();
		String fieldName = extras.getString(EXTRA_ARRAY_FIELD_NAME);

		String titleBase = getString(R.string.array_viewer_title);
		setTitle(titleBase + "." + fieldName);

		String[] stringArray = loadStringArray(fieldName);
		if (stringArray == null)
		{
			stringArray = new String[0];
		}

		ArrayAdapter listADapter = new ArrayAdapter(this,
			android.R.layout.simple_list_item_1, stringArray);
		setListAdapter(listADapter);
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();

		menuInflater.inflate(R.menu.preference_menu, menu);
		menuInflater.inflate(R.menu.quit_menu, menu);

		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		boolean result = false;
		Log.v(LOG_TAG, "selected item => " + item);

		int itemId = item.getItemId();
		switch (itemId)
		{
			case R.id.preference_menuitem:
				Intent preferencesIntent = new Intent(this, PreferencesActivity.class);
				startActivityForResult(preferencesIntent, AppConstants.REQUEST_CHILD_ACTIVITY);
				result = true;
				break;
			case R.id.quit_menuitem:
				setResult(AppConstants.RESULT_QUIT);
				finish();
				result = true;
				break;
			default:
				result = super.onOptionsItemSelected(item);
		}

		return result;
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		switch (requestCode)
		{
			case AppConstants.REQUEST_CHILD_ACTIVITY:
				if (resultCode == AppConstants.RESULT_QUIT)
				{
					setResult(resultCode);
					finish();
				}
				break;
		}
	}

	private String[] loadStringArray(String fieldName)
	{
		String[] result = null;
		try
		{
			Field field = android.R.array.class.getField(fieldName);
			int resourceID = field.getInt(null);
			result = getResources().getStringArray(resourceID);
		}
		catch (NoSuchFieldException ex)
		{
			Log.e(LOG_TAG, "loadStringArray() Failed.", ex);
		}
		catch (SecurityException ex)
		{
			Log.e(LOG_TAG, "loadStringArray() Failed.", ex);
		}
		catch (IllegalArgumentException ex)
		{
			Log.e(LOG_TAG, "loadStringArray() Failed.", ex);
		}
		catch (IllegalAccessException ex)
		{
			Log.e(LOG_TAG, "loadStringArray() Failed.", ex);
		}

		return result;
	}
}
