/*
 *  The MIT License
 * 
 *  Copyright 2011 Masahiko, SAWAI <say@users.sourceforge.jp>.
 * 
 *  Permission is hereby granted, free of charge, to any person obtaining a copy
 *  of this software and associated documentation files (the "Software"), to deal
 *  in the Software without restriction, including without limitation the rights
 *  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 *  copies of the Software, and to permit persons to whom the Software is
 *  furnished to do so, subject to the following conditions:
 * 
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 * 
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 *  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 *  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 *  THE SOFTWARE.
 */
package org.routine_work.android_r.style.theme;

import org.routine_work.android_r.*;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.TextView;

/**
 *
 * @author Masahiko, SAWAI <say@users.sourceforge.jp>
 */
public class ThemeExampleActivity extends Activity
{
	public static final String EXTRA_KEY_THEME_NAME = "theme_name";
	public static final String EXTRA_KEY_THEME_ID = "theme_id";

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		// get extra data
		Intent intent = getIntent();
		String themeName = intent.getStringExtra(EXTRA_KEY_THEME_NAME);
		int themeID = intent.getIntExtra(EXTRA_KEY_THEME_ID, -1);

		// set activity theme
		if (themeID != -1)
		{
			setTheme(themeID);
		}

		super.onCreate(savedInstanceState);

		setContentView(R.layout.theme_example_activity);

		// set theme name
		if (themeName != null)
		{
			TextView themeNameTextView = (TextView) findViewById(R.id.theme_name_textview);
			themeNameTextView.setText(themeName);
		}
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu)
	{
		MenuInflater menuInflater = getMenuInflater();

		menuInflater.inflate(R.menu.preference_menu, menu);
		menuInflater.inflate(R.menu.quit_menu, menu);

		return true;
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item)
	{
		boolean result = false;

		switch (item.getItemId())
		{
			case R.id.preference_menuitem:
				Intent preferencesIntent = new Intent(this, PreferencesActivity.class);
				startActivityForResult(preferencesIntent, AppConstants.REQUEST_CHILD_ACTIVITY);
				result = true;
				break;
			case R.id.quit_menuitem:
				setResult(AppConstants.RESULT_QUIT);
				finish();
				result = true;
				break;
			default:
				result = super.onOptionsItemSelected(item);
		}

		return result;
	}

	@Override
	protected void onActivityResult(int requestCode, int resultCode, Intent data)
	{
		switch (requestCode)
		{
			case AppConstants.REQUEST_CHILD_ACTIVITY:
				if (resultCode == AppConstants.RESULT_QUIT)
				{
					setResult(resultCode);
					finish();
				}
				break;
		}
	}
}
