/*
 * Decompiled with CFR 0.152.
 */
package com.fujitsu.jp.ssl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.regex.Pattern;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;

public class MethodTransformer
implements ClassFileTransformer {
    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            CtMethod[] ctMethods;
            ClassPool classPool = ClassPool.getDefault();
            ByteArrayInputStream stream = new ByteArrayInputStream(classfileBuffer);
            CtClass ctClass = classPool.makeClass((InputStream)stream);
            CtMethod[] ctMethodArray = ctMethods = ctClass.getDeclaredMethods();
            int n = ctMethods.length;
            int n2 = 0;
            while (n2 < n) {
                CtMethod ctMethod = ctMethodArray[n2];
                Pattern pattern = Pattern.compile("^jp");
                if (pattern.matcher(ctClass.getName()).find()) {
                    ctMethod.addLocalVariable("start", CtClass.longType);
                    ctMethod.insertBefore("start = System.currentTimeMillis();");
                    ctMethod.insertBefore("System.out.println(\"[PFRM:START]," + ctClass.getName() + "," + ctMethod.getName() + "()," + "0\");");
                    ctMethod.insertAfter("System.out.println(\"[PFRM:END  ]," + ctClass.getName() + "," + ctMethod.getName() + "()," + "\" + (System.currentTimeMillis() - start));");
                }
                ++n2;
            }
            return ctClass.toBytecode();
        }
        catch (CannotCompileException e) {
            IllegalClassFormatException ecfe = new IllegalClassFormatException();
            ecfe.initCause(e);
            throw ecfe;
        }
        catch (IOException e) {
            IllegalClassFormatException ecfe = new IllegalClassFormatException();
            ecfe.initCause(e);
            throw ecfe;
        }
    }
}

