/* -*- mode: c++ -*-
 * $Id: xbm.c,v 1.4 2005/08/03 10:09:20 tfuruka1 Exp $
 * $Name:  $
 *
 * xbm, uncompface t@C̓WJsȂ܂B{, X
 * uncompface WĴړI, uncompface  -X IvVŐ
 *  xbm t@CWJł̂mFƂŁc uncompface 
 * -X IvV, version ɂ, T|[gȂĂ
 * ܂, }, umcompface ɑΉ̂łB
 *
 * ŃAgdi32.lib, user32.lib KvłBP̃fobO
 * XBM_DEBUG RpCIvVɎw肷ƁÃt@Cœ
 * 삵܂B
 *
 *    cl /W3 /Zi /DXBM_DEBUG xbm.c /link gdi32.lib user32.lib
 *
 * $Log: xbm.c,v $
 * Revision 1.4  2005/08/03 10:09:20  tfuruka1
 * [Faceł悤ɂ܂B
 *
 * Revision 1.3  2005/05/08 13:03:27  tfuruka1
 * X-Face֘A̒ǉ
 *
 * Revision 1.2  2005/05/07 12:14:33  tfuruka1
 * printfōsĂfobOak2prp̂̂ɕύX܂B
 *
 * Revision 1.1  2005/04/30 17:15:08  tfuruka1
 * VKǉ
 *
 */

#include "xbm.h"

#define XFACE_STR "X-Face:"
#define FACE_STR "Face:"

#define PROCESS_TIMEOUT 100                     // vZX^CAEg

#if defined(XBM_DEBUG)
HWND WINAPI
DbgPrint(
    HWND hWnd,                                  // EChEnh
    int nFlag,                                  // tO
    LPCSTR lpstr,                               // printfƓ
    ...                                         // 
    )
{
    va_list args;                               // WJp
    // ɍĐ`
    va_start(args, lpstr);
    vprintf(lpstr, args);
    va_end(args);
    printf("\n");
    return NULL;
}

BOOL WINAPI
MakeTempFileAndClose(
    IN const char *mode,                        // [h
    IN OUT LPTSTR lpszFileName                  // 쐬ƃt@C
    )
{
    FILE *fp;

    sprintf(lpszFileName, "XBM_XXXXXX");
    if (!_mktemp(lpszFileName)) {
        return FALSE;
    }
    fp = fopen(lpszFileName, mode);
    fclose(fp);
    return TRUE;
}

#else
HWND WINAPI
DbgPrint(
    HWND hWnd,                                  // EChEnh
    int nFlag,                                  // tO
    LPCSTR lpstr,                               // printfƓ
    ...                                         // 
    );

BOOL WINAPI
MakeTempFileAndClose(
    IN const char *mode,                        // [h
    IN OUT LPTSTR lpszFileName                  // 쐬ƃt@C
    );

#endif

/*
 * qvZX̎s
 */
static int WINAPI
ExecuteProcess(LPTSTR lpCmd)
{
    DWORD exitCode;
    HANDLE hProcess;
    long ret;
    STARTUPINFO stInfo;
    PROCESS_INFORMATION procInfo;
    int i;

    stInfo.cb = sizeof(STARTUPINFO);
    stInfo.lpReserved = NULL;
    stInfo.lpDesktop = NULL;
    stInfo.lpTitle = NULL;
    stInfo.dwFlags = STARTF_USESHOWWINDOW;
    stInfo.cbReserved2 = 0;
    stInfo.lpReserved2 = NULL;
    stInfo.wShowWindow = SW_HIDE;               // ʕ\
    ret = CreateProcess(NULL, (LPTSTR)lpCmd, NULL, NULL, FALSE, 0, NULL,
                        NULL, &stInfo, &procInfo);

    if (!ret) {
        int nErr = GetLastError();
        DbgPrint(0, 'E', "%s(%d) R}hssF %s", __FILE__, __LINE__,
                 lpCmd);
        return 255;
    }

    // nh͎gpȂ̂ŕ
    CloseHandle(procInfo.hProcess);
    CloseHandle(procInfo.hThread);

    // vZX̏I҂킹
    hProcess = OpenProcess(PROCESS_QUERY_INFORMATION, 1, procInfo.dwProcessId);
    for (i = 0; i < PROCESS_TIMEOUT; i++) {
        GetExitCodeProcess(hProcess, &exitCode);
        if (STILL_ACTIVE != exitCode) {
            DbgPrint(0, 'I', "R}hs(%s)I: ExitCode=%d",
                     lpCmd, exitCode);
            CloseHandle(hProcess);
            return exitCode;
        }
        Sleep(100);
    }
    // ^CAEg
    DbgPrint(0, 'W', "vZXI܂ %s", lpCmd);
    TerminateProcess(hProcess, 255);
    CloseHandle(hProcess);
    return 255;
}

/*
 * XBMt@CAA͍𓾂
 */
static int
GetXbmValue(FILE *fp, char *lpszItem)
{
    char szBuf[1024];
    char *p;
    char *p1;

    // t@C̐擪փV[N
    if (0 != fseek(fp, 0, SEEK_SET)) {
        perror("SEEK");
        return 0;
    }

    while (fgets(szBuf, 1024, fp)) {
        if ('#' != szBuf[0]) {
            continue;
        }
        if (NULL == (p = strstr(szBuf, lpszItem))) {
            continue;
        }
        if (NULL == (p1 = strrchr(p, ' '))) {
            continue;
        }
        return atoi(p1);
    }
    return 0;
}

/*
 * XBMt@CA𓾂
 */
static int
GetXbmWidth(FILE *fp)
{
    return GetXbmValue(fp, "_width ");
}

/*
 * XBMt@CA𓾂
 */
static int
GetXbmHeight(FILE *fp)
{
    return GetXbmValue(fp, "_height ");
}

/*
 * XBMt@C̃f[^̐擪ɃV[N
 */
static BOOL
SkipToFirstByte(FILE *fp)
{
    int c;

    while (EOF != (c = getc(fp))) {
        if ('{' == c) {
            return TRUE;
        }
    }
    return FALSE;
}

/*
 * XBMt@C1oCgǂݍނAuncompresso͂f[^t@
 * C2oCgǂݍށB
 */
static long
GetByte(FILE *fp, int kind)
{
    int c;
    int idx;
    int max = (SETXBM_XBM == kind) ? 4 : 6;
    char szBuf[12];

    // ŏ̋󔒂
    while (EOF != (c = getc(fp))) {
        if (!isspace(c)) {
            break;
        }
    }
    idx = 0;
    if (!isdigit(c)) {
        DbgPrint(0, 'D', "%s#(%d)zO̕: %c[%02x]",
                 __FILE__, __LINE__, c, c);
        return -1;
    }
    szBuf[idx] = c;
    idx++;
    szBuf[idx] = '\0';
    while (EOF != (c = getc(fp))) {
        if (isspace(c)) {
            continue;
        }
        if (('X' != c) && ('x' != c) && (!isxdigit(c))) {
            return (int)strtol(szBuf, NULL, 16);
        }
        szBuf[idx] = c;
        idx++;
        szBuf[idx] = '\0';
        if (max < idx) {
            DbgPrint(0, 'D', "%s(%d)܂: %s\n",
                     __FILE__, __LINE__, szBuf);
            return -1;
        }
    }
    DbgPrint(0, 'D', "%s(%d)EOFo", __FILE__, __LINE__);
    return -1;
}

/*
 * XBM ܂, uncompface t@C̏WJBLPXBM_INFOlpData
 * ɓWJ̈ƁAcbData lpDatãoCgݒ肳ĂKv
 * B̒lzTCYWJ鎖͂ł܂B
 */
BOOL WINAPI
SetXBM(LPXBM_INFO lpXbm, LPCTSTR lpszFileName, int kind)
{
    int i;
    long c;
    size_t size;
    FILE *fp;

    if (!(fp = fopen(lpszFileName, "rt"))) {
        DbgPrint(0, 'E', "%s(%d) %s", __FILE__, __LINE__,
                 _strerror(lpszFileName));
        return FALSE;
    }

    lpXbm->kind = kind;

    if (SETXBM_XBM == kind) {                   // xbm
        lpXbm->nWidth = GetXbmWidth(fp);
        lpXbm->nHeight = GetXbmHeight(fp);
    } else {                                    // uncompface
        lpXbm->nWidth = 48;
        lpXbm->nHeight = 48;
    }
    lpXbm->cbWidth = ((lpXbm->nWidth / 8)
                      + (0 == (lpXbm->nWidth % 8) ? 0 : 1));
    size = lpXbm->cbWidth * lpXbm->nHeight;
    if (size > lpXbm->cbData) {
        DbgPrint(NULL, 'E', "%s(%d) XBMɓWJł܂B"
                 "%doCg̗̈悪KvłA%doCg܂B",
                 __FILE__, __LINE__, size, lpXbm->cbData);
        return FALSE;
    }
    lpXbm->cbData = size;

    if (SETXBM_XBM == kind) {                   // xbm
        SkipToFirstByte(fp);

        for (i = 0; i < (int)lpXbm->cbData; i++) {
            c = GetByte(fp, kind);
            *(lpXbm->lpData + i) = c & 0xff;
        }
    } else {                                    // uncompface
        for (i = 0; i < (int)lpXbm->cbData; i += 2) {
            c = GetByte(fp, kind);
            *(lpXbm->lpData + i) = (c >> 8)& 0xff;
            *(lpXbm->lpData + i + 1) = c & 0xff;
        }
    }
    fclose(fp);

    return TRUE;
}

/*
 * XBM̍W̓eԋp܂B
 */
int
PeekXBM(LPXBM_INFO lpXbm, int x, int y)
{
    int idx = y * (lpXbm->cbWidth) + (x / 8);
    int shift = (x % 8);
    int c = *(lpXbm->lpData + idx);

    if (SETXBM_UFACE == lpXbm->kind) {
        shift = 7 - shift;
    }
    return (c >> shift) & 1;
}

/*
 * XBM̓e`悵܂B
 */
BOOL WINAPI
DrawXBM(
    LPXBM_INFO lpXbm,                           // xbm
    HDC hDC,                                    // `悷DC
    int x,                                      // `W
    int y,                                      // `W
    int nWidth,                                 // `敝
    int nHeight,                                // `捂
    COLORREF crFg,                              // SiF
    COLORREF crBg,                              // wiF
    DWORD dwRop                              // X^[Iy[V
    )
{
    HDC hMemDC;                        // foCXReLXgizj
    HBITMAP hBitMap;                            // rbg}bv
    HBITMAP hOldBitmap;                         // Ârbg}bv
    int xx, yy;

    // zfoCXReLXg쐬
    if (!(hMemDC = CreateCompatibleDC(hDC))) {
        DbgPrint(0, 'D', "%s(%d)zfoCXReLXg쐬s",
                 __FILE__, __LINE__);
        return FALSE;
    }

    // rbg}bv̍쐬
    if (!(hBitMap = CreateBitmap(lpXbm->nWidth,
                                 lpXbm->nHeight, 1, 1, NULL))) {
        DbgPrint(0, 'D', "%s(%d)rbg}bv̍쐬Ɏs܂",
                 __FILE__, __LINE__);
        DeleteDC(hMemDC);                  // foCXReLXg폜
        return FALSE;
    }

    // rbg}bv̑I
    if (!(hOldBitmap = SelectObject(hMemDC, hBitMap))) {
        DbgPrint(0, 'D', "%s(%d)rbg}bv̑IɎs܂B",
                 __FILE__, __LINE__);
        DeleteDC(hMemDC);                  // foCXReLXg폜
        DeleteObject(hBitMap);                  // rbg}bv폜
        return FALSE;
    }

    // XBM̕`
    for (yy = 0; yy < lpXbm->nWidth; yy++) {
        for (xx = 0; xx < lpXbm->nHeight; xx++) {
            SetPixel(hMemDC, xx, yy,
                     PeekXBM(lpXbm, xx, yy) ? crFg : crBg);
        }
    }

    // XBM̓]
    StretchBlt(hDC, x, y, nWidth, nHeight,
               hMemDC, 0, 0, lpXbm->nWidth, lpXbm->nHeight, dwRop);

    // n
    SelectObject(hMemDC, hOldBitmap);           // rbg}bv߂
    DeleteObject(hBitMap);                      // rbg}bv폜
    DeleteDC(hMemDC);                           // zDC폜

    return TRUE;
}

/*
 * [t@CX-FACE؂oAt@Cɏo͂
 */
static BOOL WINAPI
CutXFACEToFile(
    LPTSTR lpszInFile,                          // [t@C
    LPTSTR lpszOutFile                          // X-FACEo͐
    )
{
    FILE *fpIn;
    FILE *fpOut;
    int cbXFace = strlen(XFACE_STR);
    BOOL bFind = FALSE;
    TCHAR szBuf[1024];

    if (!(fpIn = fopen(lpszInFile, "rt"))) {
        DbgPrint(0, 'E', "%s(%d) %s", __FILE__, __LINE__,
                 _strerror(lpszInFile));
        return FALSE;
    }
    if (!(fpOut = fopen(lpszOutFile, "wt"))) {
        DbgPrint(0, 'E', "%s(%d) %s", __FILE__, __LINE__,
                 _strerror(lpszOutFile));
        fclose(fpIn);
        return FALSE;
    }

    // X-Face:t閘Aǂݔ΂
    while (fgets(szBuf, 1024, fpIn)) {
        if (0 == memicmp(szBuf, XFACE_STR, cbXFace)) {
            bFind = TRUE;
            break;
        }
    }
    if (!bFind) {
        DbgPrint(0, 'I', "%s ݂͑܂", XFACE_STR);
        fclose(fpIn);
        fclose(fpOut);
        return FALSE;
    }
    fprintf(fpOut, "%s", szBuf + cbXFace);

    while (fgets(szBuf, 1024, fpIn)) {
        // psłȂΏI
        if (' ' != szBuf[0]) {
            break;
        }
        fprintf(fpOut, "%s", szBuf);
    }
    fclose(fpIn);
    fclose(fpOut);
    return TRUE;
}

/*
 * [t@CFACE؂oAt@Cɏo͂
 */
static BOOL WINAPI
CutFACEToFile(
    LPTSTR lpszInFile,                          // [t@C
    LPTSTR lpszOutFile                          // FACEo͐
    )
{
    FILE *fpIn;
    FILE *fpOut;
    int cbFace = strlen(FACE_STR);
    BOOL bFind = FALSE;
    TCHAR szBuf[1024];

    if (!(fpIn = fopen(lpszInFile, "rt"))) {
        DbgPrint(0, 'E', "%s(%d) %s", __FILE__, __LINE__,
                 _strerror(lpszInFile));
        return FALSE;
    }
    if (!(fpOut = fopen(lpszOutFile, "wt"))) {
        DbgPrint(0, 'E', "%s(%d) %s", __FILE__, __LINE__,
                 _strerror(lpszOutFile));
        fclose(fpIn);
        return FALSE;
    }

    // Face:t閘Aǂݔ΂
    while (fgets(szBuf, 1024, fpIn)) {
        if (0 == memicmp(szBuf, FACE_STR, cbFace)) {
            bFind = TRUE;
            break;
        }
    }
    if (!bFind) {
        DbgPrint(0, 'I', "%s ݂͑܂", FACE_STR);
        fclose(fpIn);
        fclose(fpOut);
        return FALSE;
    }
    fprintf(fpOut, "%s", szBuf + cbFace);

    while (fgets(szBuf, 1024, fpIn)) {
        // psłȂΏI
        if (' ' != szBuf[0]) {
            break;
        }
        fprintf(fpOut, "%s", szBuf);
    }
    fclose(fpIn);
    fclose(fpOut);
    return TRUE;
}

/*
 * uncompfaces
 */
BOOL WINAPI
ExecuteUncompface(
    LPTSTR lpszCmdPath,                         // uncompfacepX
    LPTSTR lpszInFile,                          // [t@C
    LPTSTR lpszOutFile                          // o̓t@C
    )
{
    TCHAR szCmd[1024];
    TCHAR szTempFile[MAX_PATH];
    int exitCode;

    strcpy(szTempFile, "XFACE");
    if (!MakeTempFileAndClose("wt", szTempFile)) {
        return FALSE;
    }

    if (!CutXFACEToFile(lpszInFile, szTempFile)) {
        unlink(szTempFile);
        return FALSE;
    }

    sprintf(szCmd, "\"%s\" \"%s\" \"%s\"",
            lpszCmdPath, szTempFile, lpszOutFile);
    exitCode = ExecuteProcess(szCmd);
    unlink(szTempFile);
    return 0 == exitCode ? TRUE : FALSE;
}

/*
 * Convert(Facepngbmp)sBConvert.exeImageMagick̕g
 * p܂Bڍׂ http://www.imagemagick.org QƁB
 */
BOOL WINAPI
ExecuteConvert(
    LPTSTR lpszCmdPath,                         // convertpX
    LPTSTR lpszInFile,                          // [t@C
    LPTSTR lpszOutFile                          // o̓t@C(BMP)
    )
{
    TCHAR szCmd[1024];
    TCHAR szTempFile[MAX_PATH];                 // Facep
    TCHAR szPngFile[MAX_PATH];                  // PNGp
    int exitCode;

    // Convert.exew肳ĂȂꍇ͏ȂB
    if (!lpszCmdPath[0]) {
        return FALSE;
    }

    strcpy(szTempFile, "FACE");
    if (!MakeTempFileAndClose("wt", szTempFile)) {
        return FALSE;
    }

    strcpy(szPngFile, "PNG");
    if (!MakeTempFileAndClose("wt", szPngFile)) {
        unlink(szTempFile);
        return FALSE;
    }

    // Face؂o
    if (!CutFACEToFile(lpszInFile, szTempFile)) {
        unlink(szTempFile);
        unlink(szPngFile);
        return FALSE;
    }

    // FACEPNG쐬
    DecodeBase64File(szTempFile, szPngFile);
    unlink(szTempFile);

    // PNGBMP쐬
    sprintf(szCmd, "\"%s\" \"png:%s\" \"bmp:%s\"",
            lpszCmdPath, szPngFile, lpszOutFile);
    exitCode = ExecuteProcess(szCmd);
    unlink(szPngFile);

    return 0 == exitCode ? TRUE : FALSE;
}

#if defined(XBM_DEBUG) // 
/*
 * SDK32:R\[EBhẼnh擾
 *
 * {֐͈ȉ̋LQlɂč쐬܂B
 *
 * ŏIXV: 1999/02/09
 * ԍ: J046738
 *
 * ͈̎ȉɂċLq̂łB
 *
 * Microsoft(R) Win32(R) Software Development Kit (SDK)
 *
 * ̎́Ač Microsoft Corporation 񋟂Ă Knowledge
 * Base  Article ID Q124103 (ŏIXV 1988-12-23) Ƃɍ쐬
 * ̂łB
 */
#define MY_BUFSIZE 1024                      // R\[̃^Cgp
HWND GetConsoleHwnd(VOID)
{
    HWND hwndFound;
    char pszNewWindowTitle[MY_BUFSIZE];
    char pszOldWindowTitle[MY_BUFSIZE];
    int i;

    // R\[^Cg̎擾
    GetConsoleTitle(pszOldWindowTitle, MY_BUFSIZE);

    // ƎɁAEBhE̐VK^CgtH[}bg܂
    wsprintf(pszNewWindowTitle,"%d/%d-%s",
             GetTickCount(),
             GetCurrentProcessId(),
             pszOldWindowTitle);

    // ݂̃EBhE^CgύX܂
    SetConsoleTitle(pszNewWindowTitle);

    for (i = 0; i < 100; i++) {
        // EBhE̐VK^CgTɂ܂
        hwndFound = FindWindow(NULL, pszNewWindowTitle);
        if (hwndFound) {
            DbgPrint(0, 'D', "%s(%d)GetConsoleHwnd(): =%d, T=%s\n",
                     __FILE__, __LINE__, i, pszNewWindowTitle);
            break;                              // 
        }
        Sleep(10);                              // 10m Wait
    }

    // ̃EBhE^Cg֖߂܂
    SetConsoleTitle(pszOldWindowTitle);

    return hwndFound;
}

int main(int argc, char *argv[])
{
    int x, y;
    int kind;
    LPCTSTR lpszFileName;
    TCHAR szFileName[MAX_PATH];
    HWND hWnd = GetConsoleHwnd();
    HDC hDC = GetDC(hWnd);
    unsigned char xbmBuf[6 * 48];
    XBM_INFO xbmInfo;

    xbmInfo.lpData = xbmBuf;
    xbmInfo.cbData = sizeof(xbmBuf);

    if (3 != argc) {
        printf("Usage: xbm [u | x | m<uncompfacePath>] FileName\n");
        printf(" u - uncompfaceŏꂽt@C\n"
               " x - xbmt@C\n"
               " m - X-FACE܂܂ꂽ[t@C\n");
        return 1;
    }

    kind = (*argv[1] != 'x') ? SETXBM_UFACE : SETXBM_XBM;
    lpszFileName = argv[2];
    if (*argv[1] == 'm') {
        strcpy(szFileName, "X-FACE");
        if (!MakeTempFileAndClose("wt", szFileName)) {
            return 1;
        }
        if (!ExecuteUncompface(argv[1] + 1, argv[2], szFileName)) {
            unlink(szFileName);
            return 1;
        }
        lpszFileName = szFileName;
    }
    if (!SetXBM(&xbmInfo, lpszFileName, kind)) {
        if (*argv[1] == 'm') {
            unlink(lpszFileName);
        }
        return 1;
    }
    if (*argv[1] == 'm') {
        unlink(lpszFileName);
    }

    // eLXgŕ`
    for (y = 0; y < xbmInfo.nHeight; y++) {
        for (x = 0; x < xbmInfo.nWidth; x++) {
            printf("%c", PeekXBM(&xbmInfo, x, y) ? 'X': ' ');
        }
        printf("\n");
    }

    // OtBbNŕ`
    DrawXBM(&xbmInfo, hDC, 100, 100, xbmInfo.nWidth * 2, xbmInfo.nHeight * 2,
            RGB(0, 0, 0), RGB(255, 255, 255), SRCCOPY);

    ReleaseDC(hWnd, hDC);
    return 0;
}
#endif
