package org.apache.maven.archiva.web.action.admin.repositories;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.archiva.database.ArchivaDatabaseException;
import org.apache.maven.archiva.database.ArtifactDAO;
import org.apache.maven.archiva.database.Constraint;
import org.apache.maven.archiva.database.DeclarativeConstraint;
import org.apache.maven.archiva.database.ObjectNotFoundException;
import org.apache.maven.archiva.model.ArchivaArtifact;
import org.apache.maven.archiva.model.ArchivaArtifactModel;

import java.util.ArrayList;
import java.util.List;

/**
 * ArtifactDAOStub
 * 
 * @version
 */
public class ArtifactDAOStub
    implements ArtifactDAO
{

    public ArchivaArtifact createArtifact( String groupId, String artifactId, String version, String classifier,
                                           String type, String repositoryId )
    {
        // TODO Auto-generated method stub
        return null;
    }

    public void deleteArtifact( ArchivaArtifact artifact )
        throws ArchivaDatabaseException
    {
        // TODO Auto-generated method stub

    }

    public long countArtifacts( DeclarativeConstraint constraint )
    {
        return queryArtifacts( constraint ).size();
    }

    public ArchivaArtifact getArtifact( String groupId, String artifactId, String version, String classifier,
                                        String type, String repositoryId )
        throws ObjectNotFoundException, ArchivaDatabaseException
    {
        // TODO Auto-generated method stub
        return null;
    }

    public List<ArchivaArtifact> queryArtifacts( Constraint constraint )
    {

        List<ArchivaArtifact> artifacts = new ArrayList<ArchivaArtifact>();

        ArchivaArtifactModel model = new ArchivaArtifactModel();
        model.setGroupId( "org.apache.maven.archiva" );
        model.setArtifactId( "test-artifact" );
        model.setVersion( "1.0" );
        model.setType( "jar" );
        model.setRepositoryId( "repo-ident" );

        ArchivaArtifact artifact = new ArchivaArtifact( model );
        artifacts.add( artifact );

        return artifacts;
    }

    public ArchivaArtifact saveArtifact( ArchivaArtifact artifact )
        throws ArchivaDatabaseException
    {
        // TODO Auto-generated method stub
        return null;
    }
        
}
