package org.apache.maven.archiva.web.action.admin.database;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.commons.collections.Closure;
import org.apache.maven.archiva.database.updater.ArchivaArtifactConsumer;

import java.util.ArrayList;
import java.util.List;

/**
 * AddAdminDatabaseConsumerClosure 
 *
 * @version $Id: AddAdminDatabaseConsumerClosure.java 755318 2009-03-17 16:53:49Z brett $
 */
public class AddAdminDatabaseConsumerClosure
    implements Closure
{
    private List<AdminDatabaseConsumer> list = new ArrayList<AdminDatabaseConsumer>();

    private List<String> selectedIds;

    public AddAdminDatabaseConsumerClosure( List<String> selectedIds )
    {
        this.selectedIds = selectedIds;
    }

    public void execute( Object input )
    {
        if ( input instanceof ArchivaArtifactConsumer )
        {
            ArchivaArtifactConsumer consumer = (ArchivaArtifactConsumer) input;

            boolean enabled = this.selectedIds.contains( consumer.getId() );

            AdminDatabaseConsumer adminconsumer = new AdminDatabaseConsumer();
            adminconsumer.setEnabled( enabled );
            adminconsumer.setId( consumer.getId() );
            adminconsumer.setDescription( consumer.getDescription() );

            list.add( adminconsumer );
        }
    }

    public List<AdminDatabaseConsumer> getList()
    {
        return list;
    }
}
