package org.apache.maven.archiva.database.constraints;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.archiva.database.Constraint;

/**
 * RepositoryProblemByTypeConstraint 
 *
 * @version $Id: RepositoryProblemByTypeConstraint.java 718864 2008-11-19 06:33:35Z brett $
 */
public class RepositoryProblemByTypeConstraint
    extends AbstractDeclarativeConstraint
    implements Constraint
{
    private String whereClause;

    public RepositoryProblemByTypeConstraint( String desiredType )
    {
        whereClause = "type == desiredType";
        declParams = new String[] { "String desiredType" };
        params = new Object[] { desiredType };
    }

    public String getSortColumn()
    {
        return "groupId";
    }

    public String getWhereCondition()
    {
        return whereClause;
    }
}
